/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.starter.module;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import jakarta.inject.Singleton;
import java.util.Optional;
import org.apache.bifromq.baserpc.server.RPCServerBuilder;
import org.apache.bifromq.inbox.client.IInboxClient;
import org.apache.bifromq.mqtt.inbox.IMqttBrokerClient;
import org.apache.bifromq.sessiondict.server.ISessionDictServer;
import org.apache.bifromq.starter.config.StandaloneConfig;
import org.apache.bifromq.starter.config.model.dict.SessionDictServerConfig;
import org.apache.bifromq.starter.module.ServiceInjector;

public class SessionDictServiceModule
extends AbstractModule {
    protected void configure() {
        this.bind((TypeLiteral)new TypeLiteral<Optional<ISessionDictServer>>(){}).toProvider(SessionDictServerProvider.class).in(Singleton.class);
    }

    private static class SessionDictServerProvider
    implements Provider<Optional<ISessionDictServer>> {
        private final StandaloneConfig config;
        private final ServiceInjector injector;

        @Inject
        private SessionDictServerProvider(StandaloneConfig config, ServiceInjector injector) {
            this.config = config;
            this.injector = injector;
        }

        public Optional<ISessionDictServer> get() {
            SessionDictServerConfig serverConfig = this.config.getSessionDictServiceConfig().getServer();
            if (!serverConfig.isEnable()) {
                return Optional.empty();
            }
            return Optional.of(ISessionDictServer.builder().rpcServerBuilder(this.injector.getInstance(RPCServerBuilder.class)).mqttBrokerClient(this.injector.getInstance(IMqttBrokerClient.class)).inboxClient(this.injector.getInstance(IInboxClient.class)).workerThreads(serverConfig.getWorkerThreads()).attributes(serverConfig.getAttributes()).defaultGroupTags(serverConfig.getDefaultGroups()).build());
        }
    }
}

