/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.store;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.NavigableMap;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.bifromq.basekv.client.IBaseKVStoreClient;
import org.apache.bifromq.basekv.client.KVRangeRouterUtil;
import org.apache.bifromq.basekv.client.KVRangeSetting;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.store.proto.KVRangeRORequest;
import org.apache.bifromq.basekv.store.proto.ROCoProcInput;
import org.apache.bifromq.basekv.store.proto.ReplyCode;
import org.apache.bifromq.basekv.utils.BoundaryUtil;
import org.apache.bifromq.basekv.utils.KVRangeIdUtil;
import org.apache.bifromq.inbox.storage.proto.GCRequest;
import org.apache.bifromq.inbox.storage.proto.InboxServiceROCoProcInput;
import org.apache.bifromq.inbox.store.IInboxStoreGCProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InboxStoreGCProcessor
implements IInboxStoreGCProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InboxStoreGCProcessor.class);
    protected final IBaseKVStoreClient storeClient;
    private final String localServerId;

    public InboxStoreGCProcessor(IBaseKVStoreClient storeClient, String localStoreId) {
        this.storeClient = storeClient;
        this.localServerId = localStoreId;
    }

    @Override
    public final CompletableFuture<Void> gc(long reqId, long now) {
        HashSet rangeSettingList = Sets.newHashSet((Iterable)KVRangeRouterUtil.findByBoundary((Boundary)BoundaryUtil.FULL_BOUNDARY, (NavigableMap)this.storeClient.latestEffectiveRouter()));
        if (rangeSettingList.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture[] gcResults = (CompletableFuture[])rangeSettingList.stream().filter(setting -> setting.leader().equals(this.localServerId)).map(setting -> this.doGC(reqId, (KVRangeSetting)setting, now)).toArray(CompletableFuture[]::new);
        log.debug("[InboxStore] start gc: reqId={}, rangeCount={}", (Object)reqId, (Object)gcResults.length);
        return CompletableFuture.allOf(gcResults).whenComplete((v, e) -> {
            if (e != null) {
                log.debug("[InboxStore] gc failed: reqId={}", (Object)reqId, e);
            } else {
                log.debug("[InboxStore] gc finished: reqId={}", (Object)reqId);
            }
        });
    }

    private CompletableFuture<Void> doGC(long reqId, KVRangeSetting rangeSetting, long now) {
        log.debug("[InboxStore] gc running: reqId={}, rangeId={}", (Object)reqId, (Object)KVRangeIdUtil.toString((KVRangeId)rangeSetting.id()));
        return this.storeClient.query(rangeSetting.leader(), KVRangeRORequest.newBuilder().setReqId(reqId).setKvRangeId(rangeSetting.id()).setVer(rangeSetting.ver()).setRoCoProc(ROCoProcInput.newBuilder().setInboxService(this.buildGCRequest(reqId, now)).build()).build()).handle((v, e) -> {
            if (e != null) {
                log.debug("[InboxStore] gc error: reqId={}, rangeId={}", new Object[]{reqId, KVRangeIdUtil.toString((KVRangeId)rangeSetting.id()), e});
                return null;
            }
            if (v.getCode() == ReplyCode.Ok) {
                log.debug("[InboxStore] gc done: reqId={}, rangeId={}", (Object)reqId, (Object)KVRangeIdUtil.toString((KVRangeId)rangeSetting.id()));
            } else {
                log.debug("[InboxStore] gc rejected: reqId={}, rangeId={}, reason={}", new Object[]{reqId, KVRangeIdUtil.toString((KVRangeId)rangeSetting.id()), v.getCode()});
            }
            return null;
        });
    }

    private InboxServiceROCoProcInput buildGCRequest(long reqId, long now) {
        return InboxServiceROCoProcInput.newBuilder().setReqId(reqId).setGc(GCRequest.newBuilder().setNow(now).build()).build();
    }
}

