/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.client;

import java.util.function.Consumer;
import lombok.Generated;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.inbox.client.IInboxClient;
import org.apache.bifromq.inbox.client.InboxFetchPipeline;
import org.apache.bifromq.inbox.storage.proto.Fetched;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InboxReader
implements IInboxClient.IInboxReader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InboxReader.class);
    private final String inboxId;
    private final long incarnation;
    private final InboxFetchPipeline ppln;
    private final long sessionId = HLC.INST.get();
    private volatile long lastFetchQoS0Seq = -1L;
    private volatile long lastFetchSendBufferSeq = -1L;

    public InboxReader(String inboxId, long incarnation, InboxFetchPipeline ppln) {
        this.inboxId = inboxId;
        this.incarnation = incarnation;
        this.ppln = ppln;
    }

    @Override
    public void fetch(Consumer<Fetched> consumer) {
        this.ppln.fetch(this.sessionId, this.inboxId, this.incarnation, fetched -> {
            if (fetched.getResult() == Fetched.Result.OK) {
                if (fetched.getQos0MsgCount() > 0) {
                    this.lastFetchQoS0Seq = fetched.getQos0Msg(fetched.getQos0MsgCount() - 1).getSeq();
                }
                if (fetched.getSendBufferMsgCount() > 0) {
                    this.lastFetchSendBufferSeq = fetched.getSendBufferMsg(fetched.getSendBufferMsgCount() - 1).getSeq();
                }
            }
            consumer.accept((Fetched)fetched);
        });
    }

    @Override
    public void hint(int bufferCapacity) {
        try {
            this.ppln.hint(this.sessionId, this.inboxId, this.incarnation, bufferCapacity, this.lastFetchQoS0Seq, this.lastFetchSendBufferSeq);
        }
        catch (Throwable e) {
            log.warn("Failed to send hint: inboxId={}", (Object)this.inboxId, (Object)e);
        }
    }

    @Override
    public void close() {
        this.hint(-1);
        this.ppln.stopFetch(this.sessionId, this.inboxId, this.incarnation);
    }
}

