/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.utils;

import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttConnectVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdAndPropertiesVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttProperties;
import io.netty.handler.codec.mqtt.MqttPubReplyMessageVariableHeader;
import io.netty.handler.codec.mqtt.MqttReasonCodeAndPropertiesVariableHeader;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttUnsubAckMessage;
import io.netty.handler.codec.mqtt.MqttUnsubAckPayload;
import io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;

public class MQTTMessageTrimmer {
    public static MqttMessage trim(MqttMessage message, boolean trimReasonString, boolean trimUserProps) {
        return switch (message.fixedHeader().messageType()) {
            case MqttMessageType.CONNECT -> {
                MqttConnectMessage connMsg = (MqttConnectMessage)message;
                yield new MqttConnectMessage(connMsg.fixedHeader(), MQTTMessageTrimmer.trimVarHeader(connMsg.variableHeader(), trimReasonString, trimUserProps), connMsg.payload());
            }
            case MqttMessageType.SUBSCRIBE -> {
                MqttSubscribeMessage subMsg = (MqttSubscribeMessage)message;
                MqttMessageIdVariableHeader var5_8 = subMsg.variableHeader();
                if (var5_8 instanceof MqttMessageIdAndPropertiesVariableHeader) {
                    MqttMessageIdAndPropertiesVariableHeader header = (MqttMessageIdAndPropertiesVariableHeader)var5_8;
                    yield new MqttSubscribeMessage(subMsg.fixedHeader(), MQTTMessageTrimmer.trimVarHeader(header, trimReasonString, trimUserProps), subMsg.payload());
                }
                yield subMsg;
            }
            case MqttMessageType.UNSUBSCRIBE -> {
                MqttUnsubscribeMessage unsubMsg = (MqttUnsubscribeMessage)message;
                MqttMessageIdVariableHeader var5_9 = unsubMsg.variableHeader();
                if (var5_9 instanceof MqttMessageIdAndPropertiesVariableHeader) {
                    MqttMessageIdAndPropertiesVariableHeader header = (MqttMessageIdAndPropertiesVariableHeader)var5_9;
                    yield new MqttUnsubscribeMessage(unsubMsg.fixedHeader(), MQTTMessageTrimmer.trimVarHeader(header, trimReasonString, trimUserProps), unsubMsg.payload());
                }
                yield unsubMsg;
            }
            case MqttMessageType.SUBACK -> {
                MqttSubAckMessage subAckMsg = (MqttSubAckMessage)message;
                MqttMessageIdVariableHeader var5_10 = subAckMsg.variableHeader();
                if (var5_10 instanceof MqttMessageIdAndPropertiesVariableHeader) {
                    MqttMessageIdAndPropertiesVariableHeader header = (MqttMessageIdAndPropertiesVariableHeader)var5_10;
                    yield new MqttSubAckMessage(subAckMsg.fixedHeader(), MQTTMessageTrimmer.trimVarHeader(header, trimReasonString, trimUserProps), subAckMsg.payload());
                }
                yield subAckMsg;
            }
            case MqttMessageType.UNSUBACK -> {
                Object var4_14 = message.variableHeader();
                if (var4_14 instanceof MqttMessageIdAndPropertiesVariableHeader) {
                    MqttMessageIdAndPropertiesVariableHeader header = (MqttMessageIdAndPropertiesVariableHeader)var4_14;
                    yield new MqttUnsubAckMessage(message.fixedHeader(), MQTTMessageTrimmer.trimVarHeader(header, trimReasonString, trimUserProps), (MqttUnsubAckPayload)message.payload());
                }
                yield message;
            }
            case MqttMessageType.PUBACK, MqttMessageType.PUBREC, MqttMessageType.PUBREL, MqttMessageType.PUBCOMP -> {
                if (message.variableHeader() instanceof MqttPubReplyMessageVariableHeader) {
                    yield new MqttMessage(message.fixedHeader(), (Object)MQTTMessageTrimmer.trimVarHeader((MqttPubReplyMessageVariableHeader)message.variableHeader(), trimReasonString, trimUserProps));
                }
                yield message;
            }
            case MqttMessageType.AUTH -> new MqttMessage(message.fixedHeader(), (Object)MQTTMessageTrimmer.trimVarHeader((MqttReasonCodeAndPropertiesVariableHeader)message.variableHeader(), trimReasonString, trimUserProps));
            default -> message;
        };
    }

    private static MqttConnectVariableHeader trimVarHeader(MqttConnectVariableHeader header, boolean trimReasonString, boolean trimUserProps) {
        return new MqttConnectVariableHeader(header.name(), header.version(), header.hasUserName(), header.hasPassword(), header.isWillRetain(), header.willQos(), header.isWillFlag(), header.isCleanSession(), header.keepAliveTimeSeconds(), MQTTMessageTrimmer.trimMqttProps(header.properties(), trimReasonString, trimUserProps));
    }

    private static MqttPubReplyMessageVariableHeader trimVarHeader(MqttPubReplyMessageVariableHeader header, boolean trimReasonString, boolean trimUserProps) {
        return new MqttPubReplyMessageVariableHeader(header.messageId(), header.reasonCode(), MQTTMessageTrimmer.trimMqttProps(header.properties(), trimReasonString, trimUserProps));
    }

    private static MqttMessageIdAndPropertiesVariableHeader trimVarHeader(MqttMessageIdAndPropertiesVariableHeader header, boolean trimReasonString, boolean trimUserProps) {
        return new MqttMessageIdAndPropertiesVariableHeader(header.messageId(), MQTTMessageTrimmer.trimMqttProps(header.properties(), trimReasonString, trimUserProps));
    }

    private static MqttReasonCodeAndPropertiesVariableHeader trimVarHeader(MqttReasonCodeAndPropertiesVariableHeader header, boolean trimReasonString, boolean trimUserProps) {
        return new MqttReasonCodeAndPropertiesVariableHeader(header.reasonCode(), MQTTMessageTrimmer.trimMqttProps(header.properties(), trimReasonString, trimUserProps));
    }

    private static MqttProperties trimMqttProps(MqttProperties props, boolean trimReasonString, boolean trimUserProps) {
        MqttProperties trimmed = new MqttProperties();
        block4: for (MqttProperties.MqttProperty prop : props.listAll()) {
            switch (MqttProperties.MqttPropertyType.valueOf((int)prop.propertyId())) {
                case REASON_STRING: {
                    if (trimReasonString) continue block4;
                    trimmed.add(prop);
                    continue block4;
                }
                case USER_PROPERTY: {
                    if (trimUserProps) continue block4;
                    trimmed.add(prop);
                    continue block4;
                }
            }
            trimmed.add(prop);
        }
        return trimmed;
    }
}

