/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Interner;
import com.github.benmanes.caffeine.cache.RemovalCause;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;

public class DedupCache {
    private static final Interner<String> TOPIC_INTERNER = Interner.newWeakInterner();
    private final Cache<String, ChannelTopicCache> channelTopicCaches;
    private final long expireAfterAccessMillis;
    private final long maxTopicsPerChannel;
    private final LongAdder totalTopics = new LongAdder();
    private final LongAdder channelSizeEvicted = new LongAdder();
    private final LongAdder topicSizeEvicted = new LongAdder();
    private final LongAdder channelExpiredEvicted = new LongAdder();
    private final LongAdder topicExpiredEvicted = new LongAdder();

    public DedupCache(long expireAfterAccessMillis, long maxChannels, long maxTopicsPerChannel) {
        this.expireAfterAccessMillis = expireAfterAccessMillis;
        this.maxTopicsPerChannel = maxTopicsPerChannel;
        this.channelTopicCaches = Caffeine.newBuilder().expireAfterAccess(expireAfterAccessMillis, TimeUnit.MILLISECONDS).maximumSize(maxChannels).removalListener((key, channelTopicCache, cause) -> {
            long remaining = channelTopicCache.count.sum();
            if (remaining > 0L) {
                this.totalTopics.add(-remaining);
            }
            if (cause == RemovalCause.SIZE) {
                this.channelSizeEvicted.increment();
            } else if (cause == RemovalCause.EXPIRED) {
                this.channelExpiredEvicted.increment();
            }
        }).build();
    }

    public boolean isDuplicate(String channelId, String topic, long timestamp) {
        ChannelTopicCache perChannel;
        String normalizedTopic = (String)TOPIC_INTERNER.intern((Object)topic);
        AtomicReference lastRef = (AtomicReference)perChannel.cache.get((Object)normalizedTopic, arg_0 -> this.lambda$isDuplicate$2(perChannel = (ChannelTopicCache)this.channelTopicCaches.get((Object)channelId, k -> new ChannelTopicCache()), arg_0));
        Long last = (Long)lastRef.get();
        if (last >= timestamp) {
            return true;
        }
        lastRef.set(timestamp);
        return false;
    }

    public long estimatedChannels() {
        return this.channelTopicCaches.estimatedSize();
    }

    public long totalCachedTopics() {
        return this.totalTopics.sum();
    }

    public long channelEvictedBySize() {
        return this.channelSizeEvicted.sum();
    }

    public long topicEvictedBySize() {
        return this.topicSizeEvicted.sum();
    }

    public long channelEvictedByExpired() {
        return this.channelExpiredEvicted.sum();
    }

    public long topicEvictedByExpired() {
        return this.topicExpiredEvicted.sum();
    }

    private /* synthetic */ AtomicReference lambda$isDuplicate$2(ChannelTopicCache perChannel, String k) {
        perChannel.count.increment();
        this.totalTopics.increment();
        return new AtomicReference<Long>(0L);
    }

    private final class ChannelTopicCache {
        final Cache<String, AtomicReference<Long>> cache;
        final LongAdder count = new LongAdder();

        ChannelTopicCache() {
            this.cache = Caffeine.newBuilder().expireAfterAccess(DedupCache.this.expireAfterAccessMillis, TimeUnit.MILLISECONDS).maximumSize(DedupCache.this.maxTopicsPerChannel).removalListener((key, value, cause) -> {
                Objects.requireNonNull(cause);
                this.count.decrement();
                DedupCache.this.totalTopics.decrement();
                if (cause == RemovalCause.SIZE) {
                    DedupCache.this.topicSizeEvicted.increment();
                } else if (cause == RemovalCause.EXPIRED) {
                    DedupCache.this.topicExpiredEvicted.increment();
                }
            }).build();
        }
    }
}

