/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.balance;

import com.google.common.collect.Lists;
import com.google.protobuf.Struct;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.bifromq.basekv.balance.AwaitBalance;
import org.apache.bifromq.basekv.balance.BalanceNow;
import org.apache.bifromq.basekv.balance.BalanceResult;
import org.apache.bifromq.basekv.balance.IStoreBalancerFactory;
import org.apache.bifromq.basekv.balance.RangeBootstrapBalancerFactory;
import org.apache.bifromq.basekv.balance.RedundantRangeRemovalBalancerFactory;
import org.apache.bifromq.basekv.balance.StoreBalancer;
import org.apache.bifromq.basekv.balance.UnreachableReplicaRemovalBalancerFactory;
import org.apache.bifromq.basekv.balance.command.BalanceCommand;
import org.apache.bifromq.basekv.balance.command.BootstrapCommand;
import org.apache.bifromq.basekv.balance.command.ChangeConfigCommand;
import org.apache.bifromq.basekv.balance.command.CommandType;
import org.apache.bifromq.basekv.balance.command.MergeCommand;
import org.apache.bifromq.basekv.balance.command.QuitCommand;
import org.apache.bifromq.basekv.balance.command.RangeCommand;
import org.apache.bifromq.basekv.balance.command.RecoveryCommand;
import org.apache.bifromq.basekv.balance.command.SplitCommand;
import org.apache.bifromq.basekv.balance.command.TransferLeadershipCommand;
import org.apache.bifromq.basekv.balance.impl.RangeBootstrapBalancer;
import org.apache.bifromq.basekv.balance.impl.RedundantRangeRemovalBalancer;
import org.apache.bifromq.basekv.balance.impl.UnreachableReplicaRemovalBalancer;
import org.apache.bifromq.basekv.client.IBaseKVStoreClient;
import org.apache.bifromq.basekv.metaservice.IBaseKVMetaService;
import org.apache.bifromq.basekv.metaservice.IBaseKVStoreBalancerStatesProposal;
import org.apache.bifromq.basekv.metaservice.IBaseKVStoreBalancerStatesReporter;
import org.apache.bifromq.basekv.proto.BalancerStateSnapshot;
import org.apache.bifromq.basekv.proto.KVRangeDescriptor;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.proto.KVRangeStoreDescriptor;
import org.apache.bifromq.basekv.store.proto.BootstrapRequest;
import org.apache.bifromq.basekv.store.proto.ChangeReplicaConfigReply;
import org.apache.bifromq.basekv.store.proto.ChangeReplicaConfigRequest;
import org.apache.bifromq.basekv.store.proto.KVRangeMergeReply;
import org.apache.bifromq.basekv.store.proto.KVRangeMergeRequest;
import org.apache.bifromq.basekv.store.proto.KVRangeSplitReply;
import org.apache.bifromq.basekv.store.proto.KVRangeSplitRequest;
import org.apache.bifromq.basekv.store.proto.RecoverRequest;
import org.apache.bifromq.basekv.store.proto.ReplyCode;
import org.apache.bifromq.basekv.store.proto.TransferLeadershipReply;
import org.apache.bifromq.basekv.store.proto.TransferLeadershipRequest;
import org.apache.bifromq.basekv.store.proto.ZombieQuitRequest;
import org.apache.bifromq.basekv.utils.KVRangeIdUtil;
import org.apache.bifromq.logger.MDCLogger;
import org.slf4j.Logger;

public class KVStoreBalanceController {
    private final IBaseKVMetaService metaService;
    private final IBaseKVStoreClient storeClient;
    private final Map<KVRangeId, Long> rangeCommandHistory = new ConcurrentHashMap<KVRangeId, Long>();
    private final AtomicBoolean scheduling = new AtomicBoolean();
    private final AtomicReference<State> state = new AtomicReference<State>(State.Init);
    private final ScheduledExecutorService executor;
    private final CompositeDisposable disposables = new CompositeDisposable();
    private final List<? extends IStoreBalancerFactory> builtinBalancerFactories;
    private final List<? extends IStoreBalancerFactory> customBalancerFactories;
    private final Map<String, StoreBalancerState> balancers;
    private final Duration retryDelay;
    private final IBaseKVStoreBalancerStatesProposal statesProposal;
    private IBaseKVStoreBalancerStatesReporter statesReporter;
    private String localStoreId;
    private Logger log;
    private MetricManager metricsManager;
    private volatile Map<String, BalancerStateSnapshot> expectedBalancerStates;
    private volatile Set<KVRangeStoreDescriptor> landscape;
    private volatile ScheduledFuture<?> task;

    public KVStoreBalanceController(IBaseKVMetaService metaService, IBaseKVStoreClient storeClient, List<? extends IStoreBalancerFactory> factories, Duration bootstrapDelay, Duration zombieProbeDelay, Duration retryDelay, ScheduledExecutorService executor) {
        this.metaService = metaService;
        this.storeClient = storeClient;
        this.customBalancerFactories = Lists.newArrayList(factories);
        this.builtinBalancerFactories = Lists.newArrayList((Object[])new IStoreBalancerFactory[]{new RangeBootstrapBalancerFactory(bootstrapDelay), new RedundantRangeRemovalBalancerFactory(zombieProbeDelay), new UnreachableReplicaRemovalBalancerFactory(zombieProbeDelay)});
        this.statesProposal = metaService.balancerStatesProposal(storeClient.clusterId());
        this.balancers = new HashMap<String, StoreBalancerState>();
        this.retryDelay = retryDelay;
        this.executor = executor;
    }

    public void start(String localStoreId) {
        if (this.state.compareAndSet(State.Init, State.Started)) {
            this.localStoreId = localStoreId;
            this.statesReporter = this.metaService.balancerStatesReporter(this.storeClient.clusterId(), localStoreId);
            this.log = MDCLogger.getLogger((String)"balancer.logger", (String[])new String[]{"clusterId", this.storeClient.clusterId(), "storeId", localStoreId, "balancer", "CONTROLLER"});
            for (IStoreBalancerFactory iStoreBalancerFactory : this.builtinBalancerFactories) {
                StoreBalancer balancer = iStoreBalancerFactory.newBalancer(this.storeClient.clusterId(), localStoreId);
                this.log.info("Create builtin balancer: {}", (Object)balancer.getClass().getSimpleName());
                this.balancers.put(iStoreBalancerFactory.getClass().getName(), new StoreBalancerState(balancer, true));
            }
            for (IStoreBalancerFactory iStoreBalancerFactory : this.customBalancerFactories) {
                String balancerFactoryFQN = iStoreBalancerFactory.getClass().getName();
                StoreBalancer balancer = iStoreBalancerFactory.newBalancer(this.storeClient.clusterId(), localStoreId);
                this.log.info("Create balancer[{}] from factory: {}", (Object)balancer.getClass().getName(), (Object)balancerFactoryFQN);
                if (balancer instanceof RangeBootstrapBalancer || balancer instanceof RedundantRangeRemovalBalancer || balancer instanceof UnreachableReplicaRemovalBalancer) {
                    this.log.warn("Builtin balancer[{}] should not be created from custom balancer factory", (Object)balancer.getClass().getSimpleName());
                    continue;
                }
                StoreBalancerState balancerState = new StoreBalancerState(balancer, false);
                this.balancers.put(balancerFactoryFQN, balancerState);
                this.statesReporter.reportBalancerState(balancerFactoryFQN, false, balancerState.loadRules.get());
            }
            this.metricsManager = new MetricManager(localStoreId, this.storeClient.clusterId());
            this.log.info("BalancerController start");
            this.disposables.add(this.statesProposal.expectedBalancerStates().subscribe(currentExpected -> {
                this.log.trace("Expected balancer states changed: {}", currentExpected);
                this.expectedBalancerStates = currentExpected;
                this.trigger();
            }));
            this.disposables.add(this.storeClient.describe().subscribe(descriptors -> {
                this.log.trace("Landscape changed: {}", descriptors);
                this.landscape = descriptors;
                this.trimRangeHistory((Set<KVRangeStoreDescriptor>)descriptors);
                this.trigger();
            }));
            this.disposables.add(this.statesReporter.refreshSignal().subscribe(ts -> {
                for (Map.Entry<String, StoreBalancerState> entry : this.balancers.entrySet()) {
                    String balancerFacClassFQN = entry.getKey();
                    StoreBalancerState balancerState = entry.getValue();
                    if (balancerState.isBuiltin) continue;
                    this.log.debug("Report balancer state for {}", (Object)balancerFacClassFQN);
                    this.statesReporter.reportBalancerState(balancerFacClassFQN, balancerState.disabled.get(), balancerState.loadRules.get());
                }
            }));
        }
    }

    public void stop() {
        if (this.state.compareAndSet(State.Started, State.Closed)) {
            this.statesProposal.stop();
            if (this.task != null) {
                this.task.cancel(true);
                if (!this.task.isDone()) {
                    try {
                        this.task.get(5L, TimeUnit.SECONDS);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            this.statesReporter.stop();
            this.disposables.dispose();
            this.balancers.values().forEach(sbs -> sbs.balancer.close());
        }
    }

    private void trigger() {
        if (this.state.get() == State.Started && this.scheduling.compareAndSet(false, true)) {
            long jitter = ThreadLocalRandom.current().nextLong(0L, this.retryDelay.toMillis());
            if (this.task != null && !this.task.isDone()) {
                this.log.trace("Cancel scheduled balance task");
                this.task.cancel(true);
            }
            this.task = this.executor.schedule(this::updateAndBalance, jitter, TimeUnit.MILLISECONDS);
        }
    }

    private void updateAndBalance() {
        Map<String, BalancerStateSnapshot> expectedBalancerState = this.expectedBalancerStates;
        Set<KVRangeStoreDescriptor> landscape = this.landscape;
        if (landscape == null || landscape.isEmpty()) {
            this.scheduling.set(false);
            if (!Objects.equals(this.landscape, landscape)) {
                this.trigger();
            }
            return;
        }
        for (Map.Entry<String, StoreBalancerState> entry : this.balancers.entrySet()) {
            String balancerFacClassFQN = entry.getKey();
            StoreBalancerState balancerState = entry.getValue();
            try {
                BalancerStateSnapshot expectedState;
                if (expectedBalancerState != null && (expectedState = expectedBalancerState.get(balancerFacClassFQN)) != null) {
                    if (!balancerState.isBuiltin) {
                        Struct expectedLoadRules;
                        boolean disable = expectedState.getDisable();
                        Struct loadRules = balancerState.loadRules.get();
                        boolean needReport = false;
                        if (balancerState.disabled.get() != disable) {
                            this.log.info("Balancer[{}] is {}", (Object)balancerState.balancer.getClass().getSimpleName(), (Object)(disable ? "disabled" : "enabled"));
                            balancerState.disabled.set(disable);
                            needReport = true;
                        }
                        if (!loadRules.equals((Object)(expectedLoadRules = loadRules.toBuilder().mergeFrom(expectedState.getLoadRules()).build()))) {
                            if (balancerState.balancer.validate(expectedLoadRules)) {
                                loadRules = expectedLoadRules;
                                balancerState.loadRules.set(expectedLoadRules);
                                balancerState.balancer.update(expectedLoadRules);
                                needReport = true;
                            } else {
                                this.log.warn("Balancer[{}] load rules not valid: {}", (Object)balancerState.balancer.getClass().getSimpleName(), (Object)expectedLoadRules);
                            }
                        }
                        if (needReport) {
                            this.statesReporter.reportBalancerState(balancerFacClassFQN, disable, loadRules);
                        }
                    } else {
                        this.log.warn("Cannot change the state of builtin balancer: {}", (Object)balancerFacClassFQN);
                    }
                }
                balancerState.balancer.update(landscape);
            }
            catch (Throwable e) {
                this.log.error("Balancer[{}] update failed", (Object)balancerState.balancer.getClass().getSimpleName(), (Object)e);
            }
        }
        this.balance(expectedBalancerState, landscape);
    }

    private void scheduleRetry(Map<String, BalancerStateSnapshot> expected, Set<KVRangeStoreDescriptor> landscape, Duration delay) {
        this.log.debug("Retry balance after {}s", (Object)delay.toSeconds());
        this.task = this.executor.schedule(() -> {
            if (!Objects.equals(expected, this.expectedBalancerStates) || landscape != this.landscape) {
                this.log.trace("Balance retry is preempted");
                return;
            }
            if (this.scheduling.compareAndSet(false, true)) {
                this.balance(expected, landscape);
            }
        }, delay.toNanos(), TimeUnit.NANOSECONDS);
    }

    private void balance(Map<String, BalancerStateSnapshot> expected, Set<KVRangeStoreDescriptor> landscape) {
        this.metricsManager.scheduleCount.increment();
        Duration delay = null;
        block6: for (Map.Entry<String, StoreBalancerState> entry : this.balancers.entrySet()) {
            StoreBalancerState fromBalancerState = entry.getValue();
            StoreBalancer fromBalancer = fromBalancerState.balancer;
            String balancerName = fromBalancer.getClass().getSimpleName();
            if (fromBalancerState.disabled.get()) continue;
            try {
                BalanceResult result = fromBalancer.balance();
                switch (result.type()) {
                    case BalanceNow: {
                        BalanceCommand commandToRun = ((BalanceNow)result).command;
                        if (this.isStaleCommand(commandToRun)) continue block6;
                        String cmdName = commandToRun.getClass().getSimpleName();
                        this.log.info("Balancer[{}] command run: {}", (Object)balancerName, (Object)commandToRun);
                        Timer.Sample start = Timer.start();
                        this.runCommand(commandToRun).whenCompleteAsync((success, e) -> {
                            MetricManager.CommandMetrics metrics = this.metricsManager.getCommandMetrics(balancerName, cmdName);
                            if (e != null) {
                                this.log.error("Should not be here, error when run command", e);
                                metrics.cmdFailedCounter.increment();
                            } else {
                                this.log.info("Balancer[{}] command run result[{}]: {}", new Object[]{balancerName, success, commandToRun});
                                if (success.booleanValue()) {
                                    metrics.cmdSucceedCounter.increment();
                                    start.stop(metrics.cmdRunTimer);
                                } else {
                                    metrics.cmdFailedCounter.increment();
                                }
                            }
                            this.scheduling.set(false);
                            if (success.booleanValue()) {
                                if (!Objects.equals(this.landscape, landscape) || !Objects.equals(this.expectedBalancerStates, expected)) {
                                    this.trigger();
                                }
                            } else {
                                this.scheduleRetry(expected, landscape, this.retryDelay);
                            }
                        }, (Executor)this.executor);
                        return;
                    }
                    case AwaitBalance: {
                        Duration await = ((AwaitBalance)result).await;
                        delay = delay != null ? (await.toNanos() < delay.toNanos() ? await : delay) : await;
                        break;
                    }
                }
            }
            catch (Throwable e2) {
                this.log.warn("Balancer[{}] unexpected error", (Object)balancerName, (Object)e2);
            }
        }
        this.scheduling.set(false);
        if (!Objects.equals(this.landscape, landscape) || !Objects.equals(this.expectedBalancerStates, expected)) {
            this.trigger();
        } else if (delay != null) {
            this.scheduleRetry(expected, landscape, delay);
        }
    }

    private boolean isStaleCommand(BalanceCommand command) {
        RangeCommand rangeCommand;
        Long prevCMDVer;
        if (command instanceof RangeCommand && (prevCMDVer = (Long)this.rangeCommandHistory.getOrDefault((rangeCommand = (RangeCommand)command).getKvRangeId(), null)) != null && prevCMDVer >= rangeCommand.getExpectedVer()) {
            this.log.debug("Ignore staled command: {}", (Object)rangeCommand);
            return true;
        }
        return false;
    }

    private void trimRangeHistory(Set<KVRangeStoreDescriptor> landscape) {
        for (KVRangeStoreDescriptor storeDescriptor : landscape) {
            if (!storeDescriptor.getId().equals(this.localStoreId)) continue;
            Set localRangeIds = storeDescriptor.getRangesList().stream().map(KVRangeDescriptor::getId).collect(Collectors.toSet());
            this.rangeCommandHistory.keySet().retainAll(localRangeIds);
        }
    }

    private CompletableFuture<Boolean> runCommand(BalanceCommand command) {
        return switch (command.type()) {
            default -> throw new IncompatibleClassChangeError();
            case CommandType.CHANGE_CONFIG -> {
                if (!$assertionsDisabled && !(command instanceof ChangeConfigCommand)) {
                    throw new AssertionError();
                }
                ChangeConfigCommand changeConfigCommand = (ChangeConfigCommand)command;
                ChangeReplicaConfigRequest changeConfigRequest = ChangeReplicaConfigRequest.newBuilder().setReqId(System.nanoTime()).setKvRangeId(changeConfigCommand.getKvRangeId()).setVer(changeConfigCommand.getExpectedVer()).addAllNewVoters((Iterable)changeConfigCommand.getVoters()).addAllNewLearners((Iterable)changeConfigCommand.getLearners()).build();
                yield this.handleStoreReplyCode(command, (CompletableFuture<ReplyCode>)this.storeClient.changeReplicaConfig(command.getToStore(), changeConfigRequest).thenApply(ChangeReplicaConfigReply::getCode));
            }
            case CommandType.MERGE -> {
                if (!$assertionsDisabled && !(command instanceof MergeCommand)) {
                    throw new AssertionError();
                }
                MergeCommand mergeCommand = (MergeCommand)command;
                KVRangeMergeRequest rangeMergeRequest = KVRangeMergeRequest.newBuilder().setReqId(System.nanoTime()).setVer(mergeCommand.getExpectedVer()).setMergerId(mergeCommand.getKvRangeId()).setMergeeId(mergeCommand.getMergeeId()).addAllMergeeVoters((Iterable)mergeCommand.getVoters()).build();
                yield this.handleStoreReplyCode(command, (CompletableFuture<ReplyCode>)this.storeClient.mergeRanges(command.getToStore(), rangeMergeRequest).thenApply(KVRangeMergeReply::getCode));
            }
            case CommandType.SPLIT -> {
                if (!$assertionsDisabled && !(command instanceof SplitCommand)) {
                    throw new AssertionError();
                }
                SplitCommand splitCommand = (SplitCommand)command;
                KVRangeSplitRequest kvRangeSplitRequest = KVRangeSplitRequest.newBuilder().setReqId(System.nanoTime()).setKvRangeId(splitCommand.getKvRangeId()).setVer(splitCommand.getExpectedVer()).setSplitKey(splitCommand.getSplitKey()).build();
                yield this.handleStoreReplyCode(command, (CompletableFuture<ReplyCode>)this.storeClient.splitRange(command.getToStore(), kvRangeSplitRequest).thenApply(KVRangeSplitReply::getCode));
            }
            case CommandType.TRANSFER_LEADERSHIP -> {
                if (!$assertionsDisabled && !(command instanceof TransferLeadershipCommand)) {
                    throw new AssertionError();
                }
                TransferLeadershipCommand transferLeadershipCommand = (TransferLeadershipCommand)command;
                TransferLeadershipRequest transferLeadershipRequest = TransferLeadershipRequest.newBuilder().setReqId(System.nanoTime()).setKvRangeId(transferLeadershipCommand.getKvRangeId()).setVer(transferLeadershipCommand.getExpectedVer()).setNewLeaderStore(transferLeadershipCommand.getNewLeaderStore()).build();
                yield this.handleStoreReplyCode(command, (CompletableFuture<ReplyCode>)this.storeClient.transferLeadership(command.getToStore(), transferLeadershipRequest).thenApply(TransferLeadershipReply::getCode));
            }
            case CommandType.RECOVERY -> {
                if (!$assertionsDisabled && !(command instanceof RecoveryCommand)) {
                    throw new AssertionError();
                }
                RecoveryCommand recoveryCommand = (RecoveryCommand)command;
                RecoverRequest recoverRequest = RecoverRequest.newBuilder().setReqId(System.nanoTime()).setKvRangeId(recoveryCommand.getKvRangeId()).build();
                yield this.storeClient.recover(command.getToStore(), recoverRequest).handle((r, e) -> {
                    if (e != null) {
                        this.log.error("Unexpected error when recover, req: {}", (Object)recoverRequest, e);
                    }
                    return true;
                });
            }
            case CommandType.QUIT -> {
                if (!$assertionsDisabled && !(command instanceof QuitCommand)) {
                    throw new AssertionError();
                }
                QuitCommand quitCommand = (QuitCommand)command;
                ZombieQuitRequest zombieQuitRequest = ZombieQuitRequest.newBuilder().setReqId(System.nanoTime()).setKvRangeId(quitCommand.getKvRangeId()).build();
                yield this.storeClient.zombieQuit(command.getToStore(), zombieQuitRequest).handle((r, e) -> {
                    if (e != null) {
                        this.log.error("Unexpected error when recover, req: {}", (Object)zombieQuitRequest, e);
                    }
                    this.log.debug("Range[{}] in zombie state and quit?: {}", (Object)KVRangeIdUtil.toString((KVRangeId)quitCommand.getKvRangeId()), (Object)r.getQuit());
                    return true;
                });
            }
            case CommandType.BOOTSTRAP -> {
                if (!$assertionsDisabled && !(command instanceof BootstrapCommand)) {
                    throw new AssertionError();
                }
                BootstrapCommand bootstrapCommand = (BootstrapCommand)command;
                BootstrapRequest bootstrapRequest = BootstrapRequest.newBuilder().setReqId(System.nanoTime()).setKvRangeId(bootstrapCommand.getKvRangeId()).setBoundary(bootstrapCommand.getBoundary()).build();
                yield this.storeClient.bootstrap(command.getToStore(), bootstrapRequest).handle((r, e) -> {
                    if (e != null) {
                        this.log.error("Unexpected error when bootstrap: {}", (Object)command, e);
                    }
                    return true;
                });
            }
        };
    }

    private CompletableFuture<Boolean> handleStoreReplyCode(BalanceCommand command, CompletableFuture<ReplyCode> storeReply) {
        CompletableFuture<Boolean> onDone = new CompletableFuture<Boolean>();
        storeReply.whenComplete((code, e) -> {
            if (e != null) {
                this.log.error("Unexpected error when run command: {}", (Object)command, e);
                onDone.complete(false);
                return;
            }
            switch (code) {
                case Ok: {
                    switch (command.type()) {
                        case CHANGE_CONFIG: 
                        case MERGE: 
                        case SPLIT: {
                            RangeCommand rangeCommand = (RangeCommand)command;
                            this.rangeCommandHistory.compute(rangeCommand.getKvRangeId(), (k, v) -> {
                                if (v == null) {
                                    v = rangeCommand.getExpectedVer();
                                }
                                return Math.max(v, rangeCommand.getExpectedVer());
                            });
                            break;
                        }
                    }
                    onDone.complete(true);
                    break;
                }
                case BadRequest: 
                case BadVersion: 
                case TryLater: 
                case InternalError: {
                    this.log.warn("Failed with reply: {}, command: {}", code, (Object)command);
                    onDone.complete(false);
                    break;
                }
                default: {
                    onDone.complete(false);
                }
            }
        });
        return onDone;
    }

    private static enum State {
        Init,
        Started,
        Closed;

    }

    private static class StoreBalancerState {
        final StoreBalancer balancer;
        final boolean isBuiltin;
        final AtomicReference<Struct> loadRules;
        final AtomicBoolean disabled = new AtomicBoolean(false);

        private StoreBalancerState(StoreBalancer balancer, boolean isBuiltin) {
            this.balancer = balancer;
            this.loadRules = new AtomicReference<Struct>(balancer.initialLoadRules());
            this.isBuiltin = isBuiltin;
        }
    }

    static class MetricManager {
        private final Tags tags;
        private final Counter scheduleCount;
        private final Map<MetricsKey, CommandMetrics> metricsMap = new HashMap<MetricsKey, CommandMetrics>();

        public MetricManager(String localStoreId, String clusterId) {
            this.tags = Tags.of((String)"storeId", (String)localStoreId).and("clusterId", clusterId);
            this.scheduleCount = Counter.builder((String)"basekv.balance.scheduled").tags((Iterable)this.tags).register((MeterRegistry)Metrics.globalRegistry);
        }

        public CommandMetrics getCommandMetrics(String fromBalancer, String command) {
            MetricsKey metricsKey = MetricsKey.builder().balancer(fromBalancer).cmdName(command).build();
            return this.metricsMap.computeIfAbsent(metricsKey, k -> new CommandMetrics(this.tags.and("balancer", k.balancer).and("cmd", k.cmdName)));
        }

        public void close() {
            Metrics.globalRegistry.remove((Meter)this.scheduleCount);
            this.metricsMap.values().forEach(CommandMetrics::clear);
        }

        private static class MetricsKey {
            private String balancer;
            private String cmdName;

            @Generated
            MetricsKey(String balancer, String cmdName) {
                this.balancer = balancer;
                this.cmdName = cmdName;
            }

            @Generated
            public static MetricsKeyBuilder builder() {
                return new MetricsKeyBuilder();
            }

            @Generated
            public static class MetricsKeyBuilder {
                @Generated
                private String balancer;
                @Generated
                private String cmdName;

                @Generated
                MetricsKeyBuilder() {
                }

                @Generated
                public MetricsKeyBuilder balancer(String balancer) {
                    this.balancer = balancer;
                    return this;
                }

                @Generated
                public MetricsKeyBuilder cmdName(String cmdName) {
                    this.cmdName = cmdName;
                    return this;
                }

                @Generated
                public MetricsKey build() {
                    return new MetricsKey(this.balancer, this.cmdName);
                }

                @Generated
                public String toString() {
                    return "KVStoreBalanceController.MetricManager.MetricsKey.MetricsKeyBuilder(balancer=" + this.balancer + ", cmdName=" + this.cmdName + ")";
                }
            }
        }

        static class CommandMetrics {
            Counter cmdSucceedCounter;
            Counter cmdFailedCounter;
            Timer cmdRunTimer;

            private CommandMetrics(Tags tags) {
                this.cmdSucceedCounter = Counter.builder((String)"basekv.balance.cmd.succeed").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
                this.cmdFailedCounter = Counter.builder((String)"basekv.balance.cmd.failed").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
                this.cmdRunTimer = Timer.builder((String)"basekv.balance.cmd.run").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
            }

            private void clear() {
                Metrics.globalRegistry.remove((Meter)this.cmdSucceedCounter);
                Metrics.globalRegistry.remove((Meter)this.cmdFailedCounter);
                Metrics.globalRegistry.remove((Meter)this.cmdRunTimer);
            }
        }
    }
}

