/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.apache.bifromq.basekv.localengine.ISyncContext;

public class SyncContext
implements ISyncContext {
    private final AtomicLong stateGenVer = new AtomicLong(0L);
    private final AtomicLong stateModVer = new AtomicLong(0L);
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();

    @Override
    public ISyncContext.IRefresher refresher() {
        return new Refresher();
    }

    @Override
    public ISyncContext.IMutator mutator() {
        return new Mutator();
    }

    private class Refresher
    implements ISyncContext.IRefresher {
        private final Lock rLock;
        private long genVer = 0L;
        private long readVer = -1L;

        Refresher() {
            this.rLock = SyncContext.this.rwLock.readLock();
        }

        @Override
        public void runIfNeeded(ISyncContext.IRefresh refresh) {
            this.rLock.lock();
            try {
                boolean sameGen;
                boolean bl = sameGen = this.genVer == SyncContext.this.stateGenVer.get();
                if (sameGen && this.readVer == SyncContext.this.stateModVer.get()) {
                    return;
                }
                this.genVer = SyncContext.this.stateGenVer.get();
                this.readVer = SyncContext.this.stateModVer.get();
                refresh.refresh(!sameGen);
            }
            finally {
                this.rLock.unlock();
            }
        }

        @Override
        public <T> T call(Supplier<T> supplier) {
            this.rLock.lock();
            try {
                T t = supplier.get();
                return t;
            }
            finally {
                this.rLock.unlock();
            }
        }
    }

    private class Mutator
    implements ISyncContext.IMutator {
        private final Lock wLock;

        Mutator() {
            this.wLock = SyncContext.this.rwLock.writeLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean run(ISyncContext.IMutation mutation) {
            this.wLock.lock();
            try {
                boolean genBumped = mutation.mutate();
                if (genBumped) {
                    SyncContext.this.stateGenVer.incrementAndGet();
                    SyncContext.this.stateModVer.set(0L);
                } else {
                    SyncContext.this.stateModVer.incrementAndGet();
                }
                boolean bl = genBumped;
                return bl;
            }
            finally {
                this.wLock.unlock();
            }
        }
    }
}

