/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.store;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import com.google.protobuf.Struct;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.subjects.BehaviorSubject;
import io.reactivex.rxjava3.subjects.Subject;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.bifromq.base.util.AsyncRunner;
import org.apache.bifromq.baseenv.EnvProvider;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.basekv.InProcStores;
import org.apache.bifromq.basekv.localengine.ICPableKVSpace;
import org.apache.bifromq.basekv.localengine.IKVEngine;
import org.apache.bifromq.basekv.localengine.KVEngineFactory;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.proto.EnsureRange;
import org.apache.bifromq.basekv.proto.EnsureRangeReply;
import org.apache.bifromq.basekv.proto.KVRangeDescriptor;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.proto.KVRangeMessage;
import org.apache.bifromq.basekv.proto.KVRangeSnapshot;
import org.apache.bifromq.basekv.proto.KVRangeStoreDescriptor;
import org.apache.bifromq.basekv.proto.MergeDoneReply;
import org.apache.bifromq.basekv.proto.MergeReply;
import org.apache.bifromq.basekv.proto.PrepareMergeToReply;
import org.apache.bifromq.basekv.proto.SaveSnapshotDataRequest;
import org.apache.bifromq.basekv.proto.State;
import org.apache.bifromq.basekv.proto.StoreMessage;
import org.apache.bifromq.basekv.raft.proto.ClusterConfig;
import org.apache.bifromq.basekv.raft.proto.Snapshot;
import org.apache.bifromq.basekv.store.IKVRangeStore;
import org.apache.bifromq.basekv.store.IStoreMessenger;
import org.apache.bifromq.basekv.store.KVRangeMessenger;
import org.apache.bifromq.basekv.store.KVRangeStoreStatsCollector;
import org.apache.bifromq.basekv.store.api.IKVRangeCoProcFactory;
import org.apache.bifromq.basekv.store.exception.KVRangeStoreException;
import org.apache.bifromq.basekv.store.option.KVRangeStoreOptions;
import org.apache.bifromq.basekv.store.proto.ROCoProcInput;
import org.apache.bifromq.basekv.store.proto.ROCoProcOutput;
import org.apache.bifromq.basekv.store.proto.RWCoProcInput;
import org.apache.bifromq.basekv.store.proto.RWCoProcOutput;
import org.apache.bifromq.basekv.store.range.IKVRange;
import org.apache.bifromq.basekv.store.range.IKVRangeFSM;
import org.apache.bifromq.basekv.store.range.KVRangeFSM;
import org.apache.bifromq.basekv.store.range.KVRangeFactory;
import org.apache.bifromq.basekv.store.range.hinter.IKVRangeSplitHinter;
import org.apache.bifromq.basekv.store.range.hinter.SplitHinterContext;
import org.apache.bifromq.basekv.store.range.hinter.SplitHinterRegistry;
import org.apache.bifromq.basekv.store.stats.IStatsCollector;
import org.apache.bifromq.basekv.store.util.ExecutorServiceUtil;
import org.apache.bifromq.basekv.store.wal.IKVRangeWALStore;
import org.apache.bifromq.basekv.store.wal.KVRangeWALStorageEngine;
import org.apache.bifromq.basekv.utils.KVRangeIdUtil;
import org.apache.bifromq.logger.MDCLogger;
import org.slf4j.Logger;

public class KVRangeStore
implements IKVRangeStore {
    private final Logger log;
    private final String clusterId;
    private final String id;
    private final AtomicReference<Status> status = new AtomicReference<Status>(Status.INIT);
    private final Map<KVRangeId, RangeFSMHolder> kvRangeMap = Maps.newConcurrentMap();
    private final Subject<List<Observable<KVRangeDescriptor>>> descriptorListSubject = BehaviorSubject.create().toSerialized();
    private final IKVRangeCoProcFactory coProcFactory;
    private final KVRangeWALStorageEngine walStorageEngine;
    private final IKVEngine<? extends ICPableKVSpace> kvRangeEngine;
    private final IStatsCollector storeStatsCollector;
    private final CompositeDisposable disposable = new CompositeDisposable();
    private final Executor queryExecutor;
    private final ScheduledExecutorService tickExecutor;
    private final ScheduledExecutorService bgTaskExecutor;
    private final ScheduledExecutorService mgmtTaskExecutor;
    private final AsyncRunner mgmtTaskRunner;
    private final KVRangeStoreOptions opts;
    private final MetricsManager metricsManager;
    private final Map<String, String> attributes;
    private final SplitHinterRegistry splitHinterRegistry;
    private volatile ScheduledFuture<?> tickFuture;
    private IStoreMessenger messenger;

    public KVRangeStore(String clusterId, KVRangeStoreOptions opts, IKVRangeCoProcFactory coProcFactory, @NonNull Executor queryExecutor, int tickerThreads, @NonNull ScheduledExecutorService bgTaskExecutor, Map<String, String> attributes) {
        if (queryExecutor == null) {
            throw new NullPointerException("queryExecutor is marked non-null but is null");
        }
        if (bgTaskExecutor == null) {
            throw new NullPointerException("bgTaskExecutor is marked non-null but is null");
        }
        this.clusterId = clusterId;
        this.coProcFactory = coProcFactory;
        this.opts = opts.toBuilder().build();
        this.walStorageEngine = new KVRangeWALStorageEngine(clusterId, opts.getOverrideIdentity(), opts.getWalEngineType(), opts.getWalEngineConf());
        this.id = this.walStorageEngine.id();
        String[] tags = new String[]{"clusterId", clusterId, "storeId", this.id};
        this.log = MDCLogger.getLogger(KVRangeStore.class, (String[])tags);
        if (opts.getOverrideIdentity() != null && !opts.getOverrideIdentity().trim().isEmpty() && !opts.getOverrideIdentity().equals(this.id)) {
            this.log.warn("KVRangeStore has been initialized with identity[{}], the override[{}] is ignored", (Object)this.id, (Object)opts.getOverrideIdentity());
        }
        this.kvRangeEngine = KVEngineFactory.createCPable(null, (String)opts.getDataEngineType(), (Struct)opts.getDataEngineConf());
        this.queryExecutor = queryExecutor;
        this.bgTaskExecutor = bgTaskExecutor;
        this.tickExecutor = ExecutorServiceMetrics.monitor((MeterRegistry)Metrics.globalRegistry, (ScheduledExecutorService)new ScheduledThreadPoolExecutor(tickerThreads, EnvProvider.INSTANCE.newThreadFactory("basekv-store-ticker-" + clusterId)), (String)"ticker", (String)"basekv.store", (Iterable)Tags.of((String[])tags));
        this.mgmtTaskExecutor = ExecutorServiceMetrics.monitor((MeterRegistry)Metrics.globalRegistry, (ScheduledExecutorService)new ScheduledThreadPoolExecutor(1, EnvProvider.INSTANCE.newThreadFactory("basekv-store-manager-" + clusterId)), (String)"manager", (String)"basekv.store", (Iterable)Tags.of((String[])tags));
        this.mgmtTaskRunner = new AsyncRunner((Executor)this.mgmtTaskExecutor);
        this.metricsManager = new MetricsManager(clusterId, this.id);
        this.attributes = attributes;
        this.splitHinterRegistry = new SplitHinterRegistry(opts.getSplitHinterFactoryConfig(), this.log);
        this.storeStatsCollector = new KVRangeStoreStatsCollector(opts, Duration.ofSeconds(opts.getStatsCollectIntervalSec()), this.bgTaskExecutor);
    }

    @Override
    public String clusterId() {
        return this.clusterId;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public boolean isStarted() {
        return this.status.get() == Status.STARTED;
    }

    @Override
    public void start(IStoreMessenger messenger) {
        if (this.status.compareAndSet(Status.INIT, Status.STARTING)) {
            try {
                this.messenger = messenger;
                this.walStorageEngine.start();
                this.kvRangeEngine.start(new String[]{"clusterId", this.clusterId, "storeId", this.id, "type", "data"});
                this.log.debug("KVRangeStore started");
                this.status.set(Status.STARTED);
                this.disposable.add(messenger.receive().subscribe(this::receive));
                this.loadExisting();
                this.scheduleTick(0L);
                InProcStores.regInProcStore((String)this.clusterId, (String)this.id);
            }
            catch (Throwable e) {
                this.status.set(Status.FATAL_FAILURE);
                throw new KVRangeStoreException("Failed to start kv range store", e);
            }
        } else {
            this.log.warn("KVRangeStore cannot start in {} status", (Object)this.status.get().name());
        }
    }

    private void loadExisting() {
        this.mgmtTaskRunner.add(() -> {
            this.kvRangeEngine.spaces().forEach((id, kvSpace) -> {
                KVRangeId rangeId = KVRangeIdUtil.fromString((String)id);
                if (this.walStorageEngine.has(rangeId)) {
                    IKVRangeWALStore walStore = this.walStorageEngine.get(rangeId);
                    String[] rangeTags = this.rangeTags(rangeId);
                    IKVRange range = this.buildKVRange(rangeId, (ICPableKVSpace)kvSpace, null, rangeTags);
                    if (!this.validate(range, walStore)) {
                        this.log.warn("Destroy inconsistent KVRange: {}", id);
                        kvSpace.destroy();
                        walStore.destroy();
                        return;
                    }
                    this.putAndOpen(this.loadKVRangeFSM(rangeId, range, walStore, rangeTags)).join();
                } else {
                    this.log.debug("Destroy orphan KVRange: {}", id);
                    kvSpace.destroy();
                }
            });
            this.updateDescriptorList();
        }).toCompletableFuture().join();
    }

    private boolean validate(IKVRange range, IKVRangeWALStore walStore) {
        long lastAppliedIndex = (Long)range.lastAppliedIndex().blockingFirst();
        return lastAppliedIndex <= -1L || lastAppliedIndex >= walStore.latestSnapshot().getIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.status.compareAndSet(Status.STARTED, Status.CLOSING)) {
            try {
                this.log.debug("Stopping KVRange store");
                this.log.debug("Await for all management tasks to finish");
                this.tickFuture.get();
                this.mgmtTaskRunner.awaitDone().toCompletableFuture().join();
                ArrayList<CompletableFuture<Void>> closeFutures = new ArrayList<CompletableFuture<Void>>();
                try {
                    for (RangeFSMHolder holder : this.kvRangeMap.values()) {
                        closeFutures.add(holder.fsm.close());
                    }
                }
                catch (Throwable e) {
                    this.log.error("Failed to close range", e);
                }
                CompletableFuture.allOf((CompletableFuture[])closeFutures.toArray(CompletableFuture[]::new)).join();
                this.disposable.dispose();
                this.storeStatsCollector.stop().toCompletableFuture().join();
                this.log.debug("Stopping WAL Engine");
                this.walStorageEngine.stop();
                this.log.debug("Stopping KVRange Engine");
                this.kvRangeEngine.stop();
                this.descriptorListSubject.onComplete();
                this.status.set(Status.CLOSED);
                this.status.set(Status.TERMINATING);
            }
            catch (Throwable e) {
                this.log.error("Error occurred during stopping range store", e);
            }
            finally {
                this.messenger.close();
                ExecutorServiceUtil.awaitShutdown(this.tickExecutor).join();
                ExecutorServiceUtil.awaitShutdown(this.mgmtTaskExecutor).join();
                this.status.set(Status.TERMINATED);
            }
        }
    }

    @Override
    public CompletableFuture<Boolean> bootstrap(KVRangeId rangeId, Boundary boundary) {
        return this.mgmtTaskRunner.add(() -> {
            if (this.status.get() != Status.STARTED) {
                return CompletableFuture.failedFuture(new IllegalStateException("Store not running"));
            }
            if (this.kvRangeMap.containsKey(rangeId)) {
                return CompletableFuture.completedFuture(false);
            }
            this.log.debug("Bootstrap KVRange: rangeId={}, boundary={}", (Object)KVRangeIdUtil.toString((KVRangeId)rangeId), (Object)boundary);
            if (this.kvRangeEngine.spaces().containsKey(KVRangeIdUtil.toString((KVRangeId)rangeId))) {
                ICPableKVSpace keyRange = (ICPableKVSpace)this.kvRangeEngine.spaces().get(KVRangeIdUtil.toString((KVRangeId)rangeId));
                this.log.debug("Destroy existing KeySpace: rangeId={}", (Object)KVRangeIdUtil.toString((KVRangeId)rangeId));
                keyRange.destroy();
            }
            if (this.walStorageEngine.has(rangeId)) {
                this.log.debug("Destroy staled WALStore: rangeId={}", (Object)KVRangeIdUtil.toString((KVRangeId)rangeId));
                this.walStorageEngine.get(rangeId).destroy();
            }
            ClusterConfig initConfig = ClusterConfig.newBuilder().addVoters(this.id()).build();
            KVRangeSnapshot rangeSnapshot = KVRangeSnapshot.newBuilder().setId(rangeId).setVer(0L).setLastAppliedIndex(5L).setState(State.newBuilder().setType(State.StateType.Normal).build()).setBoundary(boundary).setClusterConfig(initConfig).build();
            Snapshot snapshot = Snapshot.newBuilder().setClusterConfig(initConfig).setTerm(0L).setIndex(5L).setData(rangeSnapshot.toByteString()).build();
            return this.putAndOpen(this.createKVRangeFSM(rangeId, snapshot, rangeSnapshot)).thenApply(v -> {
                this.updateDescriptorList();
                return true;
            });
        });
    }

    @Override
    public boolean isHosting(KVRangeId rangeId) {
        return this.kvRangeMap.containsKey(rangeId);
    }

    @Override
    public CompletionStage<Void> recover(KVRangeId rangeId) {
        this.checkStarted();
        RangeFSMHolder holder = this.kvRangeMap.get(rangeId);
        if (holder != null) {
            this.metricsManager.runningRecoverNum.increment();
            return holder.fsm.recover().whenComplete((v, e) -> this.metricsManager.runningRecoverNum.decrement());
        }
        return CompletableFuture.failedFuture(KVRangeStoreException.rangeNotFound());
    }

    @Override
    public CompletionStage<Boolean> quit(KVRangeId rangeId) {
        this.checkStarted();
        RangeFSMHolder holder = this.kvRangeMap.get(rangeId);
        if (holder != null) {
            this.metricsManager.runningQuitNum.increment();
            return holder.fsm.quit().whenComplete((v, e) -> this.metricsManager.runningQuitNum.decrement());
        }
        return CompletableFuture.failedFuture(KVRangeStoreException.rangeNotFound());
    }

    @Override
    public Observable<KVRangeStoreDescriptor> describe() {
        this.checkStarted();
        return this.descriptorListSubject.distinctUntilChanged().switchMap(descriptorList -> {
            BehaviorSubject descListObservable = descriptorList.isEmpty() ? BehaviorSubject.createDefault(Collections.emptyList()) : Observable.combineLatest((Iterable)descriptorList, descs -> Arrays.stream(descs).map(desc -> (KVRangeDescriptor)desc).collect(Collectors.toList()));
            return Observable.combineLatest((ObservableSource)this.storeStatsCollector.collect().distinctUntilChanged(), (ObservableSource)descListObservable, (storeStats, descList) -> KVRangeStoreDescriptor.newBuilder().setId(this.id).putAllStatistics(storeStats).addAllRanges((Iterable)descList).setHlc(HLC.INST.get()).putAllAttributes(this.attributes).build());
        }).distinctUntilChanged();
    }

    private void receive(StoreMessage storeMessage) {
        if (this.status.get() == Status.STARTED) {
            KVRangeMessage payload = storeMessage.getPayload();
            switch (payload.getPayloadTypeCase()) {
                case ENSURERANGE: {
                    EnsureRange request = storeMessage.getPayload().getEnsureRange();
                    this.mgmtTaskRunner.add(() -> {
                        if (this.status.get() != Status.STARTED) {
                            return CompletableFuture.completedFuture(null);
                        }
                        KVRangeId rangeId = payload.getRangeId();
                        RangeFSMHolder holder = this.kvRangeMap.get(rangeId);
                        try {
                            Snapshot walSnapshot = request.getInitSnapshot();
                            KVRangeSnapshot rangeSnapshot = KVRangeSnapshot.parseFrom((ByteString)walSnapshot.getData());
                            if (holder != null) {
                                if (holder.fsm.ver() < request.getVer()) {
                                    this.log.debug("Range already exists, pinning it: rangeId={}", (Object)KVRangeIdUtil.toString((KVRangeId)rangeId));
                                    holder.pin(request.getVer(), walSnapshot, rangeSnapshot);
                                }
                                this.messenger.send(StoreMessage.newBuilder().setFrom(this.id).setSrcRange(payload.getRangeId()).setPayload(KVRangeMessage.newBuilder().setRangeId(storeMessage.getSrcRange()).setHostStoreId(storeMessage.getFrom()).setEnsureRangeReply(EnsureRangeReply.newBuilder().setResult(EnsureRangeReply.Result.OK).build()).build()).build());
                                return CompletableFuture.completedFuture(null);
                            }
                            return this.ensureRange(rangeId, walSnapshot, rangeSnapshot).whenComplete((v, e) -> {
                                this.updateDescriptorList();
                                this.messenger.send(StoreMessage.newBuilder().setFrom(this.id).setSrcRange(payload.getRangeId()).setPayload(KVRangeMessage.newBuilder().setRangeId(storeMessage.getSrcRange()).setHostStoreId(storeMessage.getFrom()).setEnsureRangeReply(EnsureRangeReply.newBuilder().setResult(EnsureRangeReply.Result.OK).build()).build()).build());
                            });
                        }
                        catch (Throwable e2) {
                            this.log.error("Unexpected error", e2);
                            this.messenger.send(StoreMessage.newBuilder().setFrom(this.id).setSrcRange(payload.getRangeId()).setPayload(KVRangeMessage.newBuilder().setRangeId(storeMessage.getSrcRange()).setHostStoreId(storeMessage.getFrom()).setEnsureRangeReply(EnsureRangeReply.newBuilder().setResult(EnsureRangeReply.Result.Error).build()).build()).build());
                            return CompletableFuture.completedFuture(null);
                        }
                    });
                    break;
                }
                case PREPAREMERGETOREQUEST: {
                    KVRangeId mergeeRangeId = payload.getRangeId();
                    this.mgmtTaskRunner.add(() -> {
                        if (!this.kvRangeMap.containsKey(mergeeRangeId)) {
                            this.messenger.send(StoreMessage.newBuilder().setFrom(this.id).setSrcRange(mergeeRangeId).setPayload(KVRangeMessage.newBuilder().setRangeId(payload.getPrepareMergeToRequest().getId()).setHostStoreId(storeMessage.getFrom()).setPrepareMergeToReply(PrepareMergeToReply.newBuilder().setTaskId(payload.getPrepareMergeToRequest().getTaskId()).build()).build()).build());
                        }
                    });
                    break;
                }
                case MERGEREQUEST: {
                    KVRangeId mergerRangeId = payload.getRangeId();
                    this.mgmtTaskRunner.add(() -> {
                        if (!this.kvRangeMap.containsKey(mergerRangeId)) {
                            this.messenger.send(StoreMessage.newBuilder().setFrom(this.id).setSrcRange(mergerRangeId).setPayload(KVRangeMessage.newBuilder().setRangeId(payload.getMergeRequest().getMergeeId()).setHostStoreId(storeMessage.getFrom()).setMergeReply(MergeReply.newBuilder().setTaskId(payload.getMergeRequest().getTaskId()).build()).build()).build());
                        }
                    });
                    break;
                }
                case MERGEDONEREQUEST: {
                    KVRangeId mergeeRangeId = payload.getRangeId();
                    this.mgmtTaskRunner.add(() -> {
                        if (!this.kvRangeMap.containsKey(mergeeRangeId)) {
                            this.messenger.send(StoreMessage.newBuilder().setFrom(this.id).setSrcRange(mergeeRangeId).setPayload(KVRangeMessage.newBuilder().setRangeId(payload.getMergeDoneRequest().getId()).setHostStoreId(storeMessage.getFrom()).setMergeDoneReply(MergeDoneReply.newBuilder().setTaskId(payload.getMergeDoneRequest().getTaskId()).build()).build()).build());
                        }
                    });
                    break;
                }
                case DATAMERGEREQUEST: {
                    KVRangeId mergeeRangeId = payload.getRangeId();
                    this.mgmtTaskRunner.add(() -> {
                        if (!this.kvRangeMap.containsKey(mergeeRangeId)) {
                            this.messenger.send(StoreMessage.newBuilder().setFrom(this.id).setSrcRange(mergeeRangeId).setPayload(KVRangeMessage.newBuilder().setRangeId(payload.getDataMergeRequest().getMergerId()).setHostStoreId(storeMessage.getFrom()).setSaveSnapshotDataRequest(SaveSnapshotDataRequest.newBuilder().setSessionId(payload.getDataMergeRequest().getSessionId()).setFlag(SaveSnapshotDataRequest.Flag.NotFound).build()).build()).build());
                        }
                    });
                    break;
                }
            }
        }
    }

    @Override
    public CompletionStage<Void> transferLeadership(long ver, KVRangeId rangeId, String newLeader) {
        this.checkStarted();
        RangeFSMHolder holder = this.kvRangeMap.get(rangeId);
        if (holder != null) {
            this.metricsManager.runningTransferLeaderNum.increment();
            return holder.fsm.transferLeadership(ver, newLeader).whenComplete((v, e) -> this.metricsManager.runningTransferLeaderNum.decrement());
        }
        return CompletableFuture.failedFuture(KVRangeStoreException.rangeNotFound());
    }

    @Override
    public CompletionStage<Void> changeReplicaConfig(long ver, KVRangeId rangeId, Set<String> newVoters, Set<String> newLearners) {
        this.checkStarted();
        RangeFSMHolder holder = this.kvRangeMap.get(rangeId);
        if (holder != null) {
            this.metricsManager.runningConfigChangeNum.increment();
            return holder.fsm.changeReplicaConfig(ver, newVoters, newLearners).whenComplete((v, e) -> this.metricsManager.runningConfigChangeNum.decrement());
        }
        return CompletableFuture.failedFuture(KVRangeStoreException.rangeNotFound());
    }

    @Override
    public CompletionStage<Void> split(long ver, KVRangeId rangeId, ByteString splitKey) {
        this.checkStarted();
        RangeFSMHolder holder = this.kvRangeMap.get(rangeId);
        if (holder != null) {
            this.metricsManager.runningSplitNum.increment();
            return holder.fsm.split(ver, splitKey).whenComplete((v, e) -> this.metricsManager.runningSplitNum.decrement());
        }
        return CompletableFuture.failedFuture(KVRangeStoreException.rangeNotFound());
    }

    @Override
    public CompletionStage<Void> merge(long ver, KVRangeId mergerId, KVRangeId mergeeId, Set<String> mergeeVoters) {
        this.checkStarted();
        RangeFSMHolder holder = this.kvRangeMap.get(mergerId);
        if (holder != null) {
            this.metricsManager.runningMergeNum.increment();
            return holder.fsm.merge(ver, mergeeId, mergeeVoters).whenComplete((v, e) -> this.metricsManager.runningMergeNum.decrement());
        }
        return CompletableFuture.failedFuture(KVRangeStoreException.rangeNotFound());
    }

    @Override
    public CompletionStage<Boolean> exist(long ver, KVRangeId id, ByteString key, boolean linearized) {
        this.checkStarted();
        RangeFSMHolder holder = this.kvRangeMap.get(id);
        if (holder != null) {
            return holder.fsm.exist(ver, key, linearized);
        }
        return CompletableFuture.failedFuture(KVRangeStoreException.rangeNotFound());
    }

    @Override
    public CompletionStage<Optional<ByteString>> get(long ver, KVRangeId id, ByteString key, boolean linearized) {
        this.checkStarted();
        RangeFSMHolder holder = this.kvRangeMap.get(id);
        if (holder != null) {
            return holder.fsm.get(ver, key, linearized);
        }
        return CompletableFuture.failedFuture(KVRangeStoreException.rangeNotFound());
    }

    @Override
    public CompletionStage<ROCoProcOutput> queryCoProc(long ver, KVRangeId id, ROCoProcInput query, boolean linearized) {
        this.checkStarted();
        RangeFSMHolder holder = this.kvRangeMap.get(id);
        if (holder != null) {
            this.metricsManager.runningQueryNum.increment();
            return holder.fsm.queryCoProc(ver, query, linearized).whenComplete((v, e) -> this.metricsManager.runningQueryNum.decrement());
        }
        return CompletableFuture.failedFuture(KVRangeStoreException.rangeNotFound());
    }

    @Override
    public CompletionStage<ByteString> put(long ver, KVRangeId id, ByteString key, ByteString value) {
        this.checkStarted();
        RangeFSMHolder holder = this.kvRangeMap.get(id);
        if (holder != null) {
            return holder.fsm.put(ver, key, value);
        }
        return CompletableFuture.failedFuture(KVRangeStoreException.rangeNotFound());
    }

    @Override
    public CompletionStage<ByteString> delete(long ver, KVRangeId id, ByteString key) {
        this.checkStarted();
        RangeFSMHolder holder = this.kvRangeMap.get(id);
        if (holder != null) {
            return holder.fsm.delete(ver, key);
        }
        return CompletableFuture.failedFuture(KVRangeStoreException.rangeNotFound());
    }

    @Override
    public CompletionStage<RWCoProcOutput> mutateCoProc(long ver, KVRangeId id, RWCoProcInput mutate) {
        this.checkStarted();
        RangeFSMHolder holder = this.kvRangeMap.get(id);
        if (holder != null) {
            this.metricsManager.runningMutateNum.increment();
            return holder.fsm.mutateCoProc(ver, mutate).whenComplete((v, e) -> this.metricsManager.runningMutateNum.decrement());
        }
        return CompletableFuture.failedFuture(KVRangeStoreException.rangeNotFound());
    }

    private void scheduleTick(long delayInMS) {
        if (this.status.get() != Status.STARTED && this.status.get() != Status.CLOSING) {
            return;
        }
        this.tickFuture = this.tickExecutor.schedule(this::tick, delayInMS, TimeUnit.MILLISECONDS);
    }

    private void tick() {
        if (this.status.get() != Status.STARTED && this.status.get() != Status.CLOSING) {
            return;
        }
        try {
            this.kvRangeMap.forEach((v, r) -> r.fsm.tick());
            this.storeStatsCollector.tick();
        }
        catch (Throwable e) {
            this.log.error("Unexpected error during tick", e);
        }
        finally {
            this.scheduleTick(this.opts.getKvRangeOptions().getTickUnitInMS());
        }
    }

    private CompletableFuture<Void> ensureRange(KVRangeId rangeId, Snapshot walSnapshot, KVRangeSnapshot rangeSnapshot) {
        ICPableKVSpace kvSpace = (ICPableKVSpace)this.kvRangeEngine.spaces().get(KVRangeIdUtil.toString((KVRangeId)rangeId));
        if (kvSpace == null) {
            if (this.walStorageEngine.has(rangeId)) {
                this.log.warn("Destroy staled WALStore: rangeId={}", (Object)KVRangeIdUtil.toString((KVRangeId)rangeId));
                this.walStorageEngine.get(rangeId).destroy();
            }
            return this.putAndOpen(this.createKVRangeFSM(rangeId, walSnapshot, rangeSnapshot));
        }
        IKVRangeWALStore walStore = this.walStorageEngine.get(rangeId);
        if (walStore == null) {
            walStore = this.walStorageEngine.create(rangeId, walSnapshot);
        }
        return this.putAndOpen(this.loadKVRangeFSM(rangeId, KVRangeFactory.create(rangeId, kvSpace, new String[0]), walStore, this.rangeTags(rangeId)));
    }

    private void quitKVRange(IKVRangeFSM range, boolean reset) {
        if (this.status.get() != Status.STARTED) {
            return;
        }
        CompletableFuture afterDestroyed = this.mgmtTaskRunner.add(() -> {
            if (this.status.get() != Status.STARTED) {
                return CompletableFuture.failedFuture(new KVRangeStoreException("Not started"));
            }
            RangeFSMHolder holder = this.kvRangeMap.remove(range.id());
            assert (holder.fsm == range);
            KVRangeId id = range.id();
            long ver = range.ver();
            Boundary boundary = range.boundary();
            this.log.debug("Destroy kvrange: rangeId={}", (Object)KVRangeIdUtil.toString((KVRangeId)range.id()));
            return range.destroy().thenApply(v -> {
                if (holder.pinned != null && holder.pinned.ver > ver) {
                    return Optional.of(holder.pinned);
                }
                if (reset) {
                    KVRangeSnapshot fsmSnapshot = KVRangeSnapshot.newBuilder().setVer(0L).setId(id).setLastAppliedIndex(0L).setBoundary(boundary).setState(State.newBuilder().setType(State.StateType.NoUse).build()).setClusterConfig(ClusterConfig.getDefaultInstance()).build();
                    Snapshot walSnapshot = Snapshot.newBuilder().setTerm(0L).setIndex(0L).setClusterConfig(ClusterConfig.getDefaultInstance()).setData(fsmSnapshot.toByteString()).build();
                    return Optional.of(new PinnedRange(ver, walSnapshot, fsmSnapshot));
                }
                return Optional.empty();
            });
        });
        ((CompletableFuture)afterDestroyed.thenCompose(pinned -> this.mgmtTaskRunner.add(() -> {
            if (pinned.isPresent()) {
                PinnedRange pinnedRange = (PinnedRange)pinned.get();
                this.log.debug("Recreate range after destroy: rangeId={}", (Object)KVRangeIdUtil.toString((KVRangeId)range.id()));
                return this.ensureRange(range.id(), pinnedRange.walSnapshot, pinnedRange.fsmSnapshot);
            }
            return CompletableFuture.completedFuture(null);
        }))).thenAccept(v -> this.updateDescriptorList());
    }

    private IKVRangeFSM loadKVRangeFSM(KVRangeId rangeId, IKVRange range, IKVRangeWALStore walStore, String ... tags) {
        this.log.debug("Load existing kvrange: rangeId={}", (Object)KVRangeIdUtil.toString((KVRangeId)rangeId));
        return this.buildKVRangeFSM(rangeId, range, walStore, tags);
    }

    private IKVRangeFSM createKVRangeFSM(KVRangeId rangeId, Snapshot snapshot, KVRangeSnapshot rangeSnapshot) {
        this.log.debug("Creating new kvrange: rangeId={}", (Object)KVRangeIdUtil.toString((KVRangeId)rangeId));
        String[] rangeTags = this.rangeTags(rangeId);
        IKVRangeWALStore walStore = this.walStorageEngine.create(rangeId, snapshot);
        ICPableKVSpace kvSpace = (ICPableKVSpace)this.kvRangeEngine.createIfMissing(KVRangeIdUtil.toString((KVRangeId)rangeId));
        IKVRange kvRange = this.buildKVRange(rangeId, kvSpace, rangeSnapshot, rangeTags);
        return this.buildKVRangeFSM(rangeId, kvRange, walStore, rangeTags);
    }

    private IKVRange buildKVRange(KVRangeId rangeId, ICPableKVSpace kvSpace, @Nullable KVRangeSnapshot snapshot, String ... tags) {
        if (snapshot == null) {
            return KVRangeFactory.create(rangeId, kvSpace, tags);
        }
        return KVRangeFactory.create(rangeId, kvSpace, snapshot, tags);
    }

    private String[] rangeTags(KVRangeId rangeId) {
        return new String[]{"clusterId", this.clusterId, "storeId", this.id, "rangeId", KVRangeIdUtil.toString((KVRangeId)rangeId)};
    }

    private IKVRangeFSM buildKVRangeFSM(KVRangeId rangeId, IKVRange kvRange, IKVRangeWALStore walStore, String ... tags) {
        List<IKVRangeSplitHinter> hinters = this.splitHinterRegistry.createHinters(SplitHinterContext.builder().clusterId(this.clusterId).storeId(this.id).id(rangeId).readerProvider(kvRange::newReader).tags(tags).build());
        return new KVRangeFSM(this.clusterId, this.id, rangeId, this.coProcFactory, kvRange, walStore, this.queryExecutor, this.bgTaskExecutor, this.opts.getKvRangeOptions(), hinters, this::quitKVRange, tags);
    }

    private void updateDescriptorList() {
        this.descriptorListSubject.onNext(this.kvRangeMap.values().stream().map(h -> h.fsm).map(IKVRangeFSM::describe).collect(Collectors.toList()));
    }

    private CompletableFuture<Void> putAndOpen(IKVRangeFSM kvRangeFSM) {
        this.kvRangeMap.put(kvRangeFSM.id(), new RangeFSMHolder(kvRangeFSM));
        return kvRangeFSM.open(new KVRangeMessenger(this.id, kvRangeFSM.id(), this.messenger));
    }

    private void checkStarted() {
        Preconditions.checkState((this.status.get() == Status.STARTED ? 1 : 0) != 0, (Object)"Store not running");
    }

    private static enum Status {
        INIT,
        STARTING,
        STARTED,
        FATAL_FAILURE,
        CLOSING,
        CLOSED,
        TERMINATING,
        TERMINATED;

    }

    private static class MetricsManager {
        private final LongAdder runningConfigChangeNum;
        private final LongAdder runningTransferLeaderNum;
        private final LongAdder runningSplitNum;
        private final LongAdder runningMergeNum;
        private final LongAdder runningRecoverNum;
        private final LongAdder runningQuitNum;
        private final LongAdder runningQueryNum;
        private final LongAdder runningMutateNum;

        MetricsManager(String clusterId, String storeId) {
            Tags tags = Tags.of((String)"clusterId", (String)clusterId).and("storeId", storeId);
            this.runningConfigChangeNum = (LongAdder)Metrics.gauge((String)"basekv.store.running", (Iterable)tags.and("cmd", "configchange"), (Number)new LongAdder());
            this.runningTransferLeaderNum = (LongAdder)Metrics.gauge((String)"basekv.store.running", (Iterable)tags.and("cmd", "transferleader"), (Number)new LongAdder());
            this.runningSplitNum = (LongAdder)Metrics.gauge((String)"basekv.store.running", (Iterable)tags.and("cmd", "split"), (Number)new LongAdder());
            this.runningMergeNum = (LongAdder)Metrics.gauge((String)"basekv.store.running", (Iterable)tags.and("cmd", "merge"), (Number)new LongAdder());
            this.runningRecoverNum = (LongAdder)Metrics.gauge((String)"basekv.store.running", (Iterable)tags.and("cmd", "recover"), (Number)new LongAdder());
            this.runningQuitNum = (LongAdder)Metrics.gauge((String)"basekv.store.running", (Iterable)tags.and("cmd", "quit"), (Number)new LongAdder());
            this.runningQueryNum = (LongAdder)Metrics.gauge((String)"basekv.store.running", (Iterable)tags.and("cmd", "query"), (Number)new LongAdder());
            this.runningMutateNum = (LongAdder)Metrics.gauge((String)"basekv.store.running", (Iterable)tags.and("cmd", "mutate"), (Number)new LongAdder());
        }
    }

    private static class RangeFSMHolder {
        private final IKVRangeFSM fsm;
        private PinnedRange pinned;

        RangeFSMHolder(IKVRangeFSM fsm) {
            this.fsm = fsm;
        }

        void pin(long ver, Snapshot walSnapshot, KVRangeSnapshot fsmSnapshot) {
            if (this.pinned == null || ver >= this.pinned.ver) {
                this.pinned = new PinnedRange(ver, walSnapshot, fsmSnapshot);
            }
        }
    }

    record PinnedRange(long ver, Snapshot walSnapshot, KVRangeSnapshot fsmSnapshot) {
    }
}

