/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.util.index;

import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.bifromq.util.index.Branch;
import org.apache.bifromq.util.index.BranchTable;
import org.pcollections.PMap;

final class PMapBranchTable<V>
implements BranchTable<V> {
    private final PMap<String, Branch<V>> map;

    PMapBranchTable(PMap<String, Branch<V>> map) {
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Branch<V> get(String key) {
        return (Branch)this.map.get((Object)key);
    }

    @Override
    public BranchTable<V> plus(String key, Branch<V> value) {
        PMap nm = this.map.plus((Object)key, value);
        if (nm == this.map) {
            return this;
        }
        return new PMapBranchTable<V>(nm);
    }

    @Override
    public BranchTable<V> minus(String key) {
        PMap nm = this.map.minus((Object)key);
        if (nm == this.map) {
            return this;
        }
        return new PMapBranchTable<V>(nm);
    }

    @Override
    public void forEach(BiConsumer<String, Branch<V>> consumer) {
        for (Map.Entry e : this.map.entrySet()) {
            consumer.accept((String)e.getKey(), (Branch)e.getValue());
        }
    }

    @Override
    public Map<String, Branch<V>> asMapView() {
        return this.map;
    }
}

