/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.bifromq.basekv.store.range.hinter;

import com.google.protobuf.ByteString;
import java.util.Map;

/**
 * The load recorded collected during a time window.
 */
public interface IKVLoadRecord {
    /**
     * The start nanos of the record.
     *
     * @return the start time in nanos
     */
    long startNanos();

    /**
     * Get the kv io times.
     *
     * @return the access times to kv engine
     */
    int getKVIOs();

    /**
     * Get the total time spent on io of kv engine.
     *
     * @return the total time in nanos
     */
    long getKVIONanos();

    /**
     * Key distribution in the window.
     *
     * @return the map of key and access times.
     */
    Map<ByteString, Long> keyDistribution();
}