/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.command;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.apache.ignite3.internal.metastorage.command.GetRangeCommand;
import org.apache.ignite3.internal.metastorage.command.GetRangeCommandBuilder;
import org.apache.ignite3.internal.metastorage.command.GetRangeCommandSerializer;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class GetRangeCommandImpl
implements GetRangeCommand,
Cloneable {
    public static final short GROUP_TYPE = 111;
    public static final short TYPE = 60;
    @IgniteToStringInclude
    private final int batchSize;
    @IgniteToStringInclude
    private final boolean includeTombstones;
    @IgniteToStringInclude
    private final ByteBuffer keyFrom;
    @IgniteToStringInclude
    private final ByteBuffer keyTo;
    @IgniteToStringInclude
    private final byte[] previousKey;
    @IgniteToStringInclude
    private final long revUpperBound;

    private GetRangeCommandImpl(int batchSize, boolean includeTombstones, ByteBuffer keyFrom, ByteBuffer keyTo, byte[] previousKey, long revUpperBound) {
        this.batchSize = batchSize;
        this.includeTombstones = includeTombstones;
        this.keyFrom = keyFrom;
        this.keyTo = keyTo;
        this.previousKey = previousKey;
        this.revUpperBound = revUpperBound;
    }

    @Override
    public int batchSize() {
        return this.batchSize;
    }

    @Override
    public boolean includeTombstones() {
        return this.includeTombstones;
    }

    @Override
    public ByteBuffer keyFrom() {
        return this.keyFrom;
    }

    @Override
    public ByteBuffer keyTo() {
        return this.keyTo;
    }

    @Override
    public byte[] previousKey() {
        return this.previousKey;
    }

    @Override
    public long revUpperBound() {
        return this.revUpperBound;
    }

    public MessageSerializer serializer() {
        return GetRangeCommandSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 111;
    }

    public String toString() {
        return S.toString(GetRangeCommandImpl.class, this);
    }

    @Override
    public short messageType() {
        return 60;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GetRangeCommandImpl otherMessage = (GetRangeCommandImpl)other;
        return Objects.equals(this.keyFrom, otherMessage.keyFrom) && Objects.equals(this.keyTo, otherMessage.keyTo) && Arrays.equals(this.previousKey, otherMessage.previousKey) && this.batchSize == otherMessage.batchSize && this.includeTombstones == otherMessage.includeTombstones && this.revUpperBound == otherMessage.revUpperBound;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.batchSize, this.includeTombstones, this.revUpperBound, this.keyFrom, this.keyTo);
        result = 31 * result + Arrays.hashCode(this.previousKey);
        return result;
    }

    @Override
    public GetRangeCommandImpl clone() {
        try {
            return (GetRangeCommandImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static GetRangeCommandBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements GetRangeCommandBuilder {
        private int batchSize;
        private boolean includeTombstones;
        private ByteBuffer keyFrom;
        private ByteBuffer keyTo;
        private byte[] previousKey;
        private long revUpperBound;

        private Builder() {
        }

        @Override
        public GetRangeCommandBuilder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        @Override
        public GetRangeCommandBuilder includeTombstones(boolean includeTombstones) {
            this.includeTombstones = includeTombstones;
            return this;
        }

        @Override
        public GetRangeCommandBuilder keyFrom(ByteBuffer keyFrom) {
            Objects.requireNonNull(keyFrom, "keyFrom is not marked @Nullable");
            this.keyFrom = keyFrom;
            return this;
        }

        @Override
        public GetRangeCommandBuilder keyTo(ByteBuffer keyTo) {
            this.keyTo = keyTo;
            return this;
        }

        @Override
        public GetRangeCommandBuilder previousKey(byte[] previousKey) {
            this.previousKey = previousKey;
            return this;
        }

        @Override
        public GetRangeCommandBuilder revUpperBound(long revUpperBound) {
            this.revUpperBound = revUpperBound;
            return this;
        }

        @Override
        public int batchSize() {
            return this.batchSize;
        }

        @Override
        public boolean includeTombstones() {
            return this.includeTombstones;
        }

        @Override
        public ByteBuffer keyFrom() {
            return this.keyFrom;
        }

        @Override
        public ByteBuffer keyTo() {
            return this.keyTo;
        }

        @Override
        public byte[] previousKey() {
            return this.previousKey;
        }

        @Override
        public long revUpperBound() {
            return this.revUpperBound;
        }

        @Override
        public GetRangeCommand build() {
            return new GetRangeCommandImpl(this.batchSize, this.includeTombstones, Objects.requireNonNull(this.keyFrom, "keyFrom is not marked @Nullable"), this.keyTo, this.previousKey, this.revUpperBound);
        }
    }
}

