/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.deployunit.tempstorage;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite3.internal.deployunit.exception.DeploymentUnitWriteException;
import org.apache.ignite3.internal.deployunit.tempstorage.TempStorage;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.util.IgniteUtils;

public class TempStorageImpl
implements TempStorage {
    private static final IgniteLogger LOG = Loggers.forClass(TempStorageImpl.class);
    private final Path storageDir;
    private final Map<String, CompletableFuture<Path>> files = new HashMap<String, CompletableFuture<Path>>();
    private final Executor executor;

    public TempStorageImpl(Path storageDir, Executor executor) {
        this.storageDir = storageDir;
        this.executor = executor;
    }

    @Override
    public CompletableFuture<Path> store(String fileName, InputStream is) {
        CompletableFuture<Path> result = CompletableFuture.supplyAsync(() -> {
            try {
                Path path = Path.of(fileName, new String[0]);
                Path parent = path.getParent();
                if (parent != null) {
                    Files.createDirectories(this.storageDir.resolve(parent), new FileAttribute[0]);
                }
                Path resolve = this.storageDir.resolve(path);
                Files.copy(is, resolve, StandardCopyOption.REPLACE_EXISTING);
                return resolve;
            }
            catch (Exception e) {
                LOG.error("Failed to process unit storage action.", (Throwable)e);
                throw new DeploymentUnitWriteException("Failed to write unit to storage.", e);
            }
        }, this.executor);
        this.files.put(fileName, result);
        return result;
    }

    @Override
    public void rollback() {
        this.files.values().forEach(f -> f.cancel(true));
    }

    @Override
    public void close() {
        IgniteUtils.deleteIfExists(this.storageDir);
    }
}

