/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.systemview.view.sql;

import java.util.Map;
import org.apache.ignite.internal.managers.systemview.walker.Order;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.spi.systemview.view.SystemView;

public class SqlViewColumnView {
    private final SystemView<?> view;
    private final Map.Entry<String, Class<?>> col;

    public SqlViewColumnView(SystemView<?> view, Map.Entry<String, Class<?>> col) {
        this.view = view;
        this.col = col;
    }

    @Order
    public String columnName() {
        return MetricUtils.toSqlName(this.col.getKey());
    }

    @Order(value=2)
    public String schemaName() {
        return QueryUtils.SCHEMA_SYS;
    }

    @Order(value=1)
    public String viewName() {
        return MetricUtils.toSqlName(this.view.name());
    }

    public String type() {
        return this.col.getValue().getName();
    }

    public String defaultValue() {
        return null;
    }

    public int precision() {
        return -1;
    }

    public int scale() {
        return -1;
    }

    public boolean nullable() {
        return !this.col.getValue().isPrimitive();
    }
}

