/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.binary;

import java.io.Serializable;
import org.apache.ignite.internal.binary.BinaryMetadata;

final class BinaryMetadataHolder
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final BinaryMetadata metadata;
    private final int pendingVer;
    private final int acceptedVer;
    private final transient boolean removing;

    BinaryMetadataHolder(BinaryMetadata metadata, int pendingVer, int acceptedVer) {
        this(metadata, pendingVer, acceptedVer, false);
    }

    private BinaryMetadataHolder(BinaryMetadata metadata, int pendingVer, int acceptedVer, boolean removing) {
        assert (metadata != null);
        this.metadata = metadata;
        this.pendingVer = pendingVer;
        this.acceptedVer = acceptedVer;
        this.removing = removing;
    }

    BinaryMetadataHolder createRemoving() {
        return new BinaryMetadataHolder(this.metadata, this.pendingVer, this.acceptedVer, true);
    }

    BinaryMetadata metadata() {
        return this.metadata;
    }

    int pendingVersion() {
        return this.pendingVer;
    }

    int acceptedVersion() {
        return this.acceptedVer;
    }

    boolean removing() {
        return this.removing;
    }

    public String toString() {
        return "[typeId=" + this.metadata.typeId() + ", pendingVer=" + this.pendingVer + ", acceptedVer=" + this.acceptedVer + ", removing=" + this.removing + "]";
    }
}

