/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.tx;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.client.handler.ClientHandlerMetricSource;
import org.apache.ignite.client.handler.ClientResource;
import org.apache.ignite.client.handler.ClientResourceRegistry;
import org.apache.ignite.client.handler.ResponseWriter;
import org.apache.ignite.client.handler.requests.table.ClientTableCommon;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.tx.InternalTxOptions;
import org.apache.ignite.internal.tx.TxManager;

public class ClientTransactionBeginRequest {
    public static CompletableFuture<ResponseWriter> process(ClientMessageUnpacker in, TxManager txManager, ClientResourceRegistry resources, ClientHandlerMetricSource metrics, HybridTimestampTracker tsTracker) throws IgniteInternalCheckedException {
        boolean readOnly = in.unpackBoolean();
        long timeoutMillis = in.unpackLong();
        HybridTimestamp observableTs = null;
        if (readOnly) {
            observableTs = HybridTimestamp.nullableHybridTimestamp((long)in.unpackLong());
        }
        InternalTxOptions txOptions = InternalTxOptions.builder().timeoutMillis(timeoutMillis).build();
        InternalTransaction tx = ClientTableCommon.startExplicitTx(tsTracker, txManager, observableTs, readOnly, txOptions);
        if (readOnly) {
            tsTracker.update(tx.readTimestamp());
        }
        try {
            long resourceId = resources.put(new ClientResource(tx, () -> ((InternalTransaction)tx).rollbackAsync()));
            metrics.transactionsActiveIncrement();
            return CompletableFuture.completedFuture(out -> out.packLong(resourceId));
        }
        catch (IgniteInternalCheckedException e) {
            tx.rollback();
            throw e;
        }
    }
}

