/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor.util;

import com.lmax.disruptor.EventProcessor;
import com.lmax.disruptor.Sequence;

public final class Util {
    private static final int ONE_MILLISECOND_IN_NANOSECONDS = 1000000;

    public static int ceilingNextPowerOfTwo(int x) {
        return 1 << 32 - Integer.numberOfLeadingZeros(x - 1);
    }

    public static long getMinimumSequence(Sequence[] sequences) {
        return Util.getMinimumSequence(sequences, Long.MAX_VALUE);
    }

    public static long getMinimumSequence(Sequence[] sequences, long minimum) {
        long minimumSequence = minimum;
        int n = sequences.length;
        for (int i = 0; i < n; ++i) {
            long value = sequences[i].get();
            minimumSequence = Math.min(minimumSequence, value);
        }
        return minimumSequence;
    }

    public static Sequence[] getSequencesFor(EventProcessor ... processors) {
        Sequence[] sequences = new Sequence[processors.length];
        for (int i = 0; i < sequences.length; ++i) {
            sequences[i] = processors[i].getSequence();
        }
        return sequences;
    }

    public static int log2(int value) {
        if (value < 1) {
            throw new IllegalArgumentException("value must be a positive number");
        }
        return 32 - Integer.numberOfLeadingZeros(value) - 1;
    }

    public static long awaitNanos(Object mutex, long timeoutNanos) throws InterruptedException {
        long millis = timeoutNanos / 1000000L;
        long nanos = timeoutNanos % 1000000L;
        long t0 = System.nanoTime();
        mutex.wait(millis, (int)nanos);
        long t1 = System.nanoTime();
        return timeoutNanos - (t1 - t0);
    }
}

