/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.SameOperandTypeChecker;
import org.apache.calcite.util.Static;

public class NotNullOperandTypeChecker
extends SameOperandTypeChecker {
    private final boolean allowCast;

    public NotNullOperandTypeChecker(int nOperands, boolean allowCast) {
        super(nOperands);
        this.allowCast = allowCast;
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        for (SqlNode node : callBinding.operands()) {
            if (!SqlUtil.isNullLiteral(node, this.allowCast)) continue;
            if (throwOnFailure) {
                throw callBinding.getValidator().newValidationError(node, Static.RESOURCE.nullIllegal());
            }
            return false;
        }
        return true;
    }
}

