/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.rocksdb.instance;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.ignite.internal.failure.FailureProcessor;
import org.apache.ignite.internal.rocksdb.ColumnFamily;
import org.apache.ignite.internal.rocksdb.flush.RocksDbFlusher;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.rocksdb.ColumnFamilyUtils;
import org.apache.ignite.internal.storage.rocksdb.RocksDbMetaStorage;
import org.apache.ignite.internal.storage.rocksdb.RocksDbStorageEngine;
import org.apache.ignite.internal.storage.rocksdb.RocksDbStorageProfile;
import org.apache.ignite.internal.storage.rocksdb.instance.SharedRocksDbInstance;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.rocksdb.AbstractComparator;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.Filter;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.TableFormatConfig;

public class SharedRocksDbInstanceCreator {
    private final FailureProcessor failureProcessor;
    private final String nodeName;
    private final List<AutoCloseable> resources = new ArrayList<AutoCloseable>();

    public SharedRocksDbInstanceCreator(FailureProcessor failureProcessor, String nodeName) {
        this.failureProcessor = failureProcessor;
        this.nodeName = nodeName;
    }

    public SharedRocksDbInstance create(RocksDbStorageEngine engine, RocksDbStorageProfile profile, Path path) throws RocksDBException, IOException {
        IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            RocksDbFlusher flusher = new RocksDbFlusher("rocksdb storage profile [" + profile.name() + "]", this.nodeName, busyLock, engine.scheduledPool(), (Executor)engine.threadPool(), () -> engine.configuration().flushDelayMillis().value(), engine.logSyncer(), this.failureProcessor, () -> {});
            List<ColumnFamilyDescriptor> cfDescriptors = this.getExistingCfDescriptors(path);
            ArrayList cfHandles = new ArrayList(cfDescriptors.size());
            DBOptions dbOptions = this.add(new DBOptions().setCreateIfMissing(true).setCreateMissingColumnFamilies(true).setAtomicFlush(true).setListeners(List.of(flusher.listener())).setWriteBufferManager(profile.writeBufferManager()).setAvoidFlushDuringShutdown(true));
            RocksDB db = this.add(RocksDB.open((DBOptions)dbOptions, (String)path.toAbsolutePath().toString(), cfDescriptors, cfHandles));
            this.resources.addAll(cfHandles);
            RocksDbMetaStorage meta = null;
            ColumnFamily partitionCf = null;
            ColumnFamily gcQueueCf = null;
            ColumnFamily dataCf = null;
            ColumnFamily hashIndexCf = null;
            ArrayList<ColumnFamily> sortedIndexCfs = new ArrayList<ColumnFamily>();
            block15: for (ColumnFamilyHandle cfHandle : cfHandles) {
                ColumnFamily cf = ColumnFamily.wrap((RocksDB)db, (ColumnFamilyHandle)cfHandle);
                switch (ColumnFamilyUtils.ColumnFamilyType.fromCfName(cf.name())) {
                    case META: {
                        meta = new RocksDbMetaStorage(cf);
                        continue block15;
                    }
                    case PARTITION: {
                        partitionCf = cf;
                        continue block15;
                    }
                    case GC_QUEUE: {
                        gcQueueCf = cf;
                        continue block15;
                    }
                    case DATA: {
                        dataCf = cf;
                        continue block15;
                    }
                    case HASH_INDEX: {
                        hashIndexCf = cf;
                        continue block15;
                    }
                    case SORTED_INDEX: {
                        sortedIndexCfs.add(cf);
                        continue block15;
                    }
                }
                throw new StorageException("Unidentified column family: [name={}, path={}]", new Object[]{cf.name(), path});
            }
            flusher.init(db, cfHandles);
            SharedRocksDbInstance sharedRocksDbInstance = new SharedRocksDbInstance(engine, path, busyLock, flusher, db, Objects.requireNonNull(meta, "meta"), Objects.requireNonNull(partitionCf, "partitionCf"), Objects.requireNonNull(gcQueueCf, "gcQueueCf"), Objects.requireNonNull(dataCf, "dataCf"), Objects.requireNonNull(hashIndexCf, "hashIndexCf"), sortedIndexCfs, this.resources);
            return sharedRocksDbInstance;
        }
        catch (Throwable t) {
            Collections.reverse(this.resources);
            try {
                IgniteUtils.closeAll(this.resources);
            }
            catch (Exception e) {
                t.addSuppressed(e);
            }
            throw t;
        }
        finally {
            this.resources.clear();
        }
    }

    private List<ColumnFamilyDescriptor> getExistingCfDescriptors(Path path) throws RocksDBException {
        List<byte[]> existingNames;
        String absolutePathStr = path.toAbsolutePath().toString();
        try (Options opts = new Options();){
            existingNames = RocksDB.listColumnFamilies((Options)opts, (String)absolutePathStr);
            if (existingNames.isEmpty()) {
                existingNames = ColumnFamilyUtils.DEFAULT_CF_NAMES;
            }
        }
        return existingNames.stream().map(cfName -> new ColumnFamilyDescriptor(cfName, this.createCfOptions((byte[])cfName, path))).collect(Collectors.toList());
    }

    private ColumnFamilyOptions createCfOptions(byte[] cfName, Path path) {
        String utf8cfName = ColumnFamilyUtils.toStringName(cfName);
        switch (ColumnFamilyUtils.ColumnFamilyType.fromCfName(utf8cfName)) {
            case META: 
            case GC_QUEUE: 
            case DATA: {
                return this.add(new ColumnFamilyOptions());
            }
            case PARTITION: {
                return this.add(SharedRocksDbInstanceCreator.defaultCfOptions().useCappedPrefixExtractor(22));
            }
            case HASH_INDEX: {
                return this.add(SharedRocksDbInstanceCreator.defaultCfOptions().useCappedPrefixExtractor(14));
            }
            case SORTED_INDEX: {
                return this.add(SharedRocksDbInstanceCreator.sortedIndexCfOptions(cfName));
            }
        }
        throw new StorageException("Unidentified column family: [name={}, path={}]", new Object[]{cfName, path});
    }

    private static ColumnFamilyOptions defaultCfOptions() {
        return new ColumnFamilyOptions().setMemtablePrefixBloomSizeRatio(0.125).setTableFormatConfig((TableFormatConfig)new BlockBasedTableConfig().setFilterPolicy((Filter)new BloomFilter()));
    }

    static ColumnFamilyOptions sortedIndexCfOptions(byte[] cfName) {
        return new ColumnFamilyOptions().setComparator((AbstractComparator)ColumnFamilyUtils.comparatorFromCfName(cfName)).useCappedPrefixExtractor(10);
    }

    private <T extends AutoCloseable> T add(T value) {
        this.resources.add(value);
        return value;
    }
}

