/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.entity;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.WritableByteChannelMock;
import org.apache.hc.core5.http.nio.BasicDataStreamChannel;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.entity.FileEntityProducer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TestFileAsyncEntityProducer {
    private File tempFile;

    TestFileAsyncEntityProducer() {
    }

    @BeforeEach
    void setup() throws Exception {
        this.tempFile = File.createTempFile("testing", ".txt");
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.tempFile), StandardCharsets.US_ASCII);){
            ((Writer)writer).append("abcdef");
            ((Writer)writer).flush();
        }
    }

    @AfterEach
    void cleanup() {
        if (this.tempFile != null) {
            this.tempFile.delete();
            this.tempFile = null;
        }
    }

    @Test
    void testTextContent() throws Exception {
        FileEntityProducer producer = new FileEntityProducer(this.tempFile, ContentType.TEXT_PLAIN);
        Assertions.assertEquals((long)6L, (long)producer.getContentLength());
        Assertions.assertEquals((Object)ContentType.TEXT_PLAIN.toString(), (Object)producer.getContentType());
        Assertions.assertNull((Object)producer.getContentEncoding());
        WritableByteChannelMock byteChannel = new WritableByteChannelMock(1024);
        BasicDataStreamChannel streamChannel = new BasicDataStreamChannel(byteChannel);
        producer.produce((DataStreamChannel)streamChannel);
        producer.produce((DataStreamChannel)streamChannel);
        Assertions.assertFalse((boolean)byteChannel.isOpen());
        Assertions.assertEquals((Object)"abcdef", (Object)byteChannel.dump(StandardCharsets.US_ASCII));
    }

    @Test
    void testTextContentRepeatable() throws Exception {
        FileEntityProducer producer = new FileEntityProducer(this.tempFile, ContentType.TEXT_PLAIN);
        Assertions.assertEquals((long)6L, (long)producer.getContentLength());
        Assertions.assertEquals((Object)ContentType.TEXT_PLAIN.toString(), (Object)producer.getContentType());
        Assertions.assertNull((Object)producer.getContentEncoding());
        for (int i = 0; i < 3; ++i) {
            WritableByteChannelMock byteChannel = new WritableByteChannelMock(1024);
            BasicDataStreamChannel streamChannel = new BasicDataStreamChannel(byteChannel);
            producer.produce((DataStreamChannel)streamChannel);
            producer.produce((DataStreamChannel)streamChannel);
            Assertions.assertFalse((boolean)byteChannel.isOpen());
            Assertions.assertEquals((Object)"abcdef", (Object)byteChannel.dump(StandardCharsets.US_ASCII));
            producer.releaseResources();
        }
    }
}

