/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.mail.workflow.actions.getpop;

import jakarta.mail.Folder;
import jakarta.mail.MessagingException;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.mail.workflow.actions.getpop.ActionGetPOP;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class SelectFolderDialog
extends Dialog {
    private static final Class<?> PKG = ActionGetPOP.class;
    private final PropsUi props;
    private Shell shell;
    private Tree wTree;
    private TreeItem tiTree;
    private String selection;
    private final Folder folder;
    private final GuiResource guiresource = GuiResource.getInstance();

    public SelectFolderDialog(Shell parent, int style, Folder folder) {
        super(parent, style);
        this.props = PropsUi.getInstance();
        this.folder = folder;
        this.selection = null;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SelectFolderDialog.Dialog.Main.Title", (String[])new String[0]));
        this.shell.setImage(this.guiresource.getImageHopUi());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.wTree = new Tree((Composite)this.shell, 2052);
        PropsUi.setLook((Widget)this.wTree);
        this.wTree.addListener(14, e -> this.ok());
        if (!this.getData()) {
            return null;
        }
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wRefresh = new Button((Composite)this.shell, 8);
        wRefresh.setText(BaseMessages.getString(PKG, (String)"System.Button.Refresh", (String[])new String[0]));
        wRefresh.addListener(13, e -> this.getData());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.dispose());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wRefresh, wCancel}, (int)PropsUi.getMargin(), null);
        FormData fdTree = new FormData();
        fdTree.left = new FormAttachment(0, 0);
        fdTree.top = new FormAttachment(0, 0);
        fdTree.right = new FormAttachment(100, 0);
        fdTree.bottom = new FormAttachment((Control)wOk, -2 * PropsUi.getMargin());
        this.wTree.setLayoutData((Object)fdTree);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.dispose());
        return this.selection;
    }

    private boolean getData() {
        if (this.tiTree != null && !this.tiTree.isDisposed()) {
            this.tiTree.dispose();
        }
        this.wTree.removeAll();
        try {
            this.buildFoldersTree(this.folder, null, true);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void buildFoldersTree(Folder folder, TreeItem parentTreeItem, boolean topfolder) throws MessagingException {
        if ((folder.getType() & 2) != 0) {
            Folder[] f;
            for (Folder value : f = folder.list()) {
                this.tiTree = topfolder ? new TreeItem(this.wTree, 0) : new TreeItem(parentTreeItem, 0);
                this.tiTree.setImage(this.guiresource.getImageBol());
                this.tiTree.setText(value.getName());
                if ((value.getType() & 2) == 0) continue;
                this.buildFoldersTree(value, this.tiTree, false);
            }
        }
    }

    public void dispose() {
        if (this.folder != null) {
            try {
                this.folder.close(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void ok() {
        TreeItem[] ti = this.wTree.getSelection();
        if (ti.length == 1) {
            Object fullpath = ti[0].getText();
            for (TreeItem parent = ti[0].getParentItem(); parent != null; parent = parent.getParentItem()) {
                fullpath = parent.getText() + "/" + (String)fullpath;
            }
            this.selection = fullpath;
            this.dispose();
        }
    }
}

