/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.workflow.actions.start;

import org.apache.hop.core.Const;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.actions.start.ActionStart;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ActionStartDialog
extends ActionDialog {
    private static final Class<?> PKG = ActionStart.class;
    private static final String NO_SCHEDULING = BaseMessages.getString(PKG, (String)"ActionStart.Type.NoScheduling", (String[])new String[0]);
    private static final String INTERVAL = BaseMessages.getString(PKG, (String)"ActionStart.Type.Interval", (String[])new String[0]);
    private static final String DAILY = BaseMessages.getString(PKG, (String)"ActionStart.Type.Daily", (String[])new String[0]);
    private static final String WEEKLY = BaseMessages.getString(PKG, (String)"ActionStart.Type.Weekly", (String[])new String[0]);
    private static final String MONTHLY = BaseMessages.getString(PKG, (String)"ActionStart.Type.Monthly", (String[])new String[0]);
    private ActionStart action;
    private Group gRepeat;
    private Text wName;
    private Button wRepeat;
    private TextVar wIntervalSeconds;
    private TextVar wIntervalMinutes;
    private ComboVar wType;
    private TextVar wHour;
    private TextVar wMinutes;
    private ComboVar wDayOfWeek;
    private TextVar wDayOfMonth;
    private Button wDoNotWaitOnFirstExecution;

    public ActionStartDialog(Shell parent, ActionStart action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = action;
    }

    public IAction open() {
        this.shell = new Shell(this.getParent(), 3312);
        PropsUi.setLook((Widget)this.shell);
        WorkflowDialog.setShellImage(this.shell, (IAction)this.action);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionStart.Name", (String[])new String[0]));
        int margin = PropsUi.getMargin();
        int middle = this.props.getMiddlePct();
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, new Button[]{wOk, wCancel}, margin, null);
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"ActionStart.Name.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wName);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        Label wlRepeat = new Label((Composite)this.shell, 131072);
        wlRepeat.setText(BaseMessages.getString(PKG, (String)"ActionStart.Repeat.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlRepeat);
        FormData fdlRepeat = new FormData();
        fdlRepeat.left = new FormAttachment(0, 0);
        fdlRepeat.right = new FormAttachment(middle, -margin);
        fdlRepeat.top = new FormAttachment((Control)this.wName, margin);
        wlRepeat.setLayoutData((Object)fdlRepeat);
        this.wRepeat = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wRepeat);
        FormData fdRepeat = new FormData();
        fdRepeat.left = new FormAttachment(middle, 0);
        fdRepeat.right = new FormAttachment(100, 0);
        fdRepeat.top = new FormAttachment((Control)wlRepeat, 0, 0x1000000);
        this.wRepeat.setLayoutData((Object)fdRepeat);
        this.wRepeat.addListener(13, e -> this.enableDisableControls());
        this.gRepeat = new Group((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.gRepeat);
        this.gRepeat.setText(BaseMessages.getString(PKG, (String)"ActionStart.Repeat.Label", (String[])new String[0]));
        FormData fdgRepeat = new FormData();
        fdgRepeat.left = new FormAttachment(0, 0);
        fdgRepeat.right = new FormAttachment(100, 0);
        fdgRepeat.top = new FormAttachment((Control)this.wRepeat, 0);
        fdgRepeat.bottom = new FormAttachment((Control)wOk, -2 * margin);
        this.gRepeat.setLayoutData((Object)fdgRepeat);
        FormLayout groupLayout = new FormLayout();
        groupLayout.marginWidth = 10;
        groupLayout.marginHeight = 10;
        this.gRepeat.setLayout((Layout)groupLayout);
        Label wlType = new Label((Composite)this.gRepeat, 131072);
        PropsUi.setLook((Widget)wlType);
        wlType.setText(BaseMessages.getString(PKG, (String)"ActionStart.Type.Label", (String[])new String[0]));
        FormData fdlType = new FormData();
        fdlType.left = new FormAttachment(0, 0);
        fdlType.right = new FormAttachment(middle, -margin);
        fdlType.top = new FormAttachment(0, margin);
        wlType.setLayoutData((Object)fdlType);
        this.wType = new ComboVar(this.variables, (Composite)this.gRepeat, 18436);
        PropsUi.setLook((Widget)this.wType);
        this.wType.addListener(13, arg0 -> this.enableDisableControls());
        this.wType.setItems(new String[]{NO_SCHEDULING, INTERVAL, DAILY, WEEKLY, MONTHLY});
        this.wType.setEditable(false);
        this.wType.getCComboWidget().setVisibleItemCount(this.wType.getItemCount());
        FormData fdType = new FormData();
        fdType.left = new FormAttachment(middle, 0);
        fdType.right = new FormAttachment(100, 0);
        fdType.top = new FormAttachment((Control)wlType, 0, 0x1000000);
        this.wType.setLayoutData(fdType);
        this.wDoNotWaitOnFirstExecution = new Button((Composite)this.gRepeat, 32);
        this.placeControl((Composite)this.gRepeat, BaseMessages.getString(PKG, (String)"ActionStart.DoNotWaitAtFirstExecution.Label", (String[])new String[0]), (Control)this.wDoNotWaitOnFirstExecution, (Control)this.wType);
        this.wIntervalSeconds = new TextVar(this.variables, (Composite)this.gRepeat, 18436);
        this.placeControl((Composite)this.gRepeat, BaseMessages.getString(PKG, (String)"ActionStart.IntervalSeconds.Label", (String[])new String[0]), (Control)this.wIntervalSeconds, (Control)this.wDoNotWaitOnFirstExecution);
        this.wIntervalMinutes = new TextVar(this.variables, (Composite)this.gRepeat, 18436);
        this.placeControl((Composite)this.gRepeat, BaseMessages.getString(PKG, (String)"ActionStart.IntervalMinutes.Label", (String[])new String[0]), (Control)this.wIntervalMinutes, (Control)this.wIntervalSeconds);
        Composite time = new Composite((Composite)this.gRepeat, 0);
        time.setLayout((Layout)new FillLayout());
        this.wHour = new TextVar(this.variables, time, 18436);
        this.wMinutes = new TextVar(this.variables, time, 18436);
        this.placeControl((Composite)this.gRepeat, BaseMessages.getString(PKG, (String)"ActionStart.TimeOfDay.Label", (String[])new String[0]), (Control)time, (Control)this.wIntervalMinutes);
        this.wDayOfWeek = new ComboVar(this.variables, (Composite)this.gRepeat, 18436);
        this.wDayOfWeek.add(BaseMessages.getString(PKG, (String)"ActionStart.DayOfWeek.Sunday", (String[])new String[0]));
        this.wDayOfWeek.add(BaseMessages.getString(PKG, (String)"ActionStart.DayOfWeek.Monday", (String[])new String[0]));
        this.wDayOfWeek.add(BaseMessages.getString(PKG, (String)"ActionStart.DayOfWeek.Tuesday", (String[])new String[0]));
        this.wDayOfWeek.add(BaseMessages.getString(PKG, (String)"ActionStart.DayOfWeek.Wednesday", (String[])new String[0]));
        this.wDayOfWeek.add(BaseMessages.getString(PKG, (String)"ActionStart.DayOfWeek.Thursday", (String[])new String[0]));
        this.wDayOfWeek.add(BaseMessages.getString(PKG, (String)"ActionStart.DayOfWeek.Friday", (String[])new String[0]));
        this.wDayOfWeek.add(BaseMessages.getString(PKG, (String)"ActionStart.DayOfWeek.Saturday", (String[])new String[0]));
        this.wDayOfWeek.setEditable(false);
        this.wDayOfWeek.getCComboWidget().setVisibleItemCount(this.wDayOfWeek.getItemCount());
        this.placeControl((Composite)this.gRepeat, BaseMessages.getString(PKG, (String)"ActionStart.DayOfWeek.Label", (String[])new String[0]), (Control)this.wDayOfWeek, (Control)time);
        this.wDayOfMonth = new TextVar(this.variables, (Composite)this.gRepeat, 18436);
        this.placeControl((Composite)this.gRepeat, BaseMessages.getString(PKG, (String)"ActionStart.DayOfMonth.Label", (String[])new String[0]), (Control)this.wDayOfMonth, (Control)this.wDayOfWeek);
        this.getData();
        this.enableDisableControls();
        BaseDialog.defaultShellHandling(this.shell, n -> this.ok(), n -> this.cancel());
        return this.action;
    }

    public void getData() {
        this.wName.setText(this.action.getName());
        this.wRepeat.setSelection(this.action.isRepeat());
        this.wType.select(this.action.getSchedulerType());
        this.wIntervalSeconds.setText(Const.NVL((String)this.action.getIntervalSeconds(), (String)""));
        this.wIntervalMinutes.setText(Const.NVL((String)this.action.getIntervalMinutes(), (String)""));
        this.wHour.setText(Const.NVL((String)this.action.getHour(), (String)""));
        this.wMinutes.setText(Const.NVL((String)this.action.getMinutes(), (String)""));
        this.wDayOfWeek.setText(Const.NVL((String)this.action.getWeekDay(), (String)""));
        this.wDayOfMonth.setText(Const.NVL((String)this.action.getDayOfMonth(), (String)""));
        this.wDoNotWaitOnFirstExecution.setSelection(this.action.isDoNotWaitOnFirstExecution());
        this.wName.setFocus();
    }

    private void cancel() {
        this.action = null;
        this.dispose();
    }

    private void ok() {
        this.action.setName(this.wName.getText());
        this.action.setRepeat(this.wRepeat.getSelection());
        this.action.setSchedulerType(this.wType.getSelectionIndex());
        this.action.setIntervalSeconds(this.wIntervalSeconds.getText());
        this.action.setIntervalMinutes(this.wIntervalMinutes.getText());
        this.action.setHour(this.wHour.getText());
        this.action.setMinutes(this.wMinutes.getText());
        this.action.setWeekDay(this.wDayOfWeek.getText());
        this.action.setDayOfMonth(this.wDayOfMonth.getText());
        this.action.setDoNotWaitOnFirstExecution(this.wDoNotWaitOnFirstExecution.getSelection());
        this.action.setChanged();
        this.dispose();
    }

    private void placeControl(Composite composite, String text, Control control, Control under) {
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        int extraVerticalMargin = under instanceof Button ? 2 * margin : 0;
        Label label = new Label(composite, 131072);
        label.setText(text);
        PropsUi.setLook((Widget)label);
        FormData formDataLabel = new FormData();
        formDataLabel.left = new FormAttachment(0, 0);
        formDataLabel.top = under != null ? new FormAttachment(under, margin + extraVerticalMargin) : new FormAttachment(0, 0);
        formDataLabel.right = new FormAttachment(middle, 0);
        label.setLayoutData((Object)formDataLabel);
        PropsUi.setLook((Widget)control);
        FormData formDataControl = new FormData();
        formDataControl.left = new FormAttachment(middle, 0);
        formDataControl.top = under != null ? new FormAttachment(under, margin + extraVerticalMargin) : new FormAttachment(0, 0);
        formDataControl.right = new FormAttachment(100, 0);
        control.setLayoutData((Object)formDataControl);
    }

    private void enableDisableControls() {
        boolean repeatEnabled = this.wRepeat.getSelection();
        boolean intervalSecondsEnabled = false;
        boolean intervalMinutesEnabled = false;
        boolean hourEnabled = false;
        boolean minutesEnabled = false;
        boolean dayOfWeekEnabled = false;
        boolean dayOfMonthEnabled = false;
        boolean doNotWaitOnFirstExecutionEnabled = false;
        if (repeatEnabled) {
            if (INTERVAL.equals(this.wType.getText())) {
                intervalSecondsEnabled = true;
                intervalMinutesEnabled = true;
            } else if (DAILY.equals(this.wType.getText())) {
                hourEnabled = true;
                minutesEnabled = true;
            } else if (WEEKLY.equals(this.wType.getText())) {
                dayOfWeekEnabled = true;
                hourEnabled = true;
                minutesEnabled = true;
            } else if (MONTHLY.equals(this.wType.getText())) {
                dayOfMonthEnabled = true;
                hourEnabled = true;
                minutesEnabled = true;
            }
        }
        this.gRepeat.setEnabled(repeatEnabled);
        this.wType.setEnabled(repeatEnabled);
        this.wIntervalMinutes.setEnabled(intervalMinutesEnabled);
        this.wIntervalSeconds.setEnabled(intervalSecondsEnabled);
        this.wDayOfWeek.setEnabled(dayOfWeekEnabled);
        this.wDayOfMonth.setEnabled(dayOfMonthEnabled);
        this.wHour.setEnabled(hourEnabled);
        this.wMinutes.setEnabled(minutesEnabled);
        this.wDoNotWaitOnFirstExecution.setEnabled(repeatEnabled);
    }
}

