/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin2;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Bin8;
import com.ibm.as400.access.AS400ByteArray;
import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400Date;
import com.ibm.as400.access.AS400Float4;
import com.ibm.as400.access.AS400Float8;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400PackedDecimal;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.AS400Time;
import com.ibm.as400.access.AS400Timestamp;
import com.ibm.as400.access.AS400UnsignedBin2;
import com.ibm.as400.access.AS400UnsignedBin4;
import com.ibm.as400.access.AS400UnsignedBin8;
import com.ibm.as400.access.AS400ZonedDecimal;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlAttributeList;
import com.ibm.as400.data.PcmlData;
import com.ibm.as400.data.PcmlDimensions;
import com.ibm.as400.data.PcmlDocNode;
import com.ibm.as400.data.PcmlDocRoot;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.PcmlNode;
import com.ibm.as400.data.PcmlProgram;
import com.ibm.as400.data.PcmlSpecificationException;
import com.ibm.as400.data.PcmlStruct;
import com.ibm.as400.data.SystemResourceFinder;
import com.ibm.as400.data.XmlException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.UnknownHostException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.TimeZone;

class PcmlDocument
extends PcmlDocRoot {
    boolean compareSucceeded = true;
    static final long serialVersionUID = -8169008879805188674L;
    private static final String[] PCMLATTRIBUTES = new String[]{"version"};
    private static final int VERSION_1_ATTRIBUTE_COUNT = 1;
    private static final String DEFAULT_DATE_SEPARATOR = "hyphen";
    private static final String DEFAULT_TIME_SEPARATOR = "period";
    private String m_docName;
    private String m_XsdName;
    private String m_Version;
    private static AS400Bin2 m_Bin2 = new AS400Bin2();
    private static AS400UnsignedBin2 m_UBin2 = new AS400UnsignedBin2();
    private static AS400Bin4 m_Bin4 = new AS400Bin4();
    private static AS400UnsignedBin4 m_UBin4 = new AS400UnsignedBin4();
    private static AS400Bin8 m_Bin8 = new AS400Bin8();
    private static AS400UnsignedBin8 m_UBin8 = new AS400UnsignedBin8();
    private static AS400Float4 m_Float4 = new AS400Float4();
    private static AS400Float8 m_Float8 = new AS400Float8();
    private static AS400PackedDecimal m_Packed_15_5 = new AS400PackedDecimal(15, 5);
    private static AS400ZonedDecimal m_Zoned_15_5 = new AS400ZonedDecimal(15, 5);
    private long correlationID_ = 0L;
    protected transient AS400Text m_Text_1 = null;
    protected transient AS400Text m_Text_10 = null;
    protected transient AS400ByteArray m_Byte_1 = null;
    protected transient AS400ByteArray m_Byte_2 = null;
    protected transient AS400ByteArray m_Byte_3 = null;
    protected transient AS400ByteArray m_Byte_4 = null;
    private AS400 m_as400;
    private int m_as400Vrm = -1;
    private transient PcmlSpecificationException m_PcmlSpecificationException = null;
    private transient boolean m_bSerializingWithData = false;
    private transient long m_DeserializationTs = 0L;
    private transient PcmlProgram m_pcmlProgram;
    private transient Object correlationIDLock_ = new Object();
    private static final String XMLNS_STRING = " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n       xsi:noNamespaceSchemaLocation=";
    private static final char[] SPECIAL_LT = new char[]{'&', 'l', 't', ';'};
    private static final char[] SPECIAL_GT = new char[]{'&', 'g', 't', ';'};
    private static final char[] SPECIAL_APOS = new char[]{'&', 'a', 'p', 'o', 's', ';'};
    private static final char[] SPECIAL_QUOT = new char[]{'&', 'q', 'u', 'o', 't', ';'};
    private static final char[] SPECIAL_AMP = new char[]{'&', 'a', 'm', 'p', ';'};

    PcmlDocument(PcmlAttributeList attrs, String docName) {
        this.setNodeType(1);
        this.m_XmlAttrs = attrs;
        this.m_docName = docName;
        this.m_XsdName = "";
        this.m_Version = this.getAttributeValue("version");
    }

    @Override
    public Object clone() {
        PcmlDocument doc = (PcmlDocument)super.clone();
        doc.addToHashtable(doc);
        return doc;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.correlationIDLock_ = new Object();
        this.m_DeserializationTs = this.getCorrelationID();
        in.defaultReadObject();
        if (this.m_as400 == null) {
            this.m_as400Vrm = -1;
        }
        this.readObjectPostprocessing();
    }

    @Override
    AS400 getAs400() {
        return this.m_as400;
    }

    long getDeserializationTimestamp() {
        return this.m_DeserializationTs;
    }

    @Override
    String[] getAttributeList() {
        return PCMLATTRIBUTES;
    }

    boolean isSerializingWithData() {
        return this.m_bSerializingWithData;
    }

    void setSerializingWithData(boolean b) {
        this.m_bSerializingWithData = b;
    }

    @Override
    int getAs400VRM() throws PcmlException {
        if (this.m_as400Vrm == -1) {
            try {
                this.m_as400Vrm = this.getAs400().getVRM();
            }
            catch (AS400SecurityException e) {
                throw new PcmlException(e);
            }
            catch (UnknownHostException e) {
                throw new PcmlException(e);
            }
            catch (IOException e) {
                throw new PcmlException(e);
            }
        }
        return this.m_as400Vrm;
    }

    String getDocName() {
        return this.m_docName;
    }

    String getVersion() {
        return this.m_Version;
    }

    synchronized void setAs400(AS400 sys) {
        this.m_as400 = sys;
        this.m_as400Vrm = -1;
        this.m_Text_1 = null;
        this.m_Text_10 = null;
    }

    protected AS400DataType getConverter(int dataType, int dataLength, int dataPrecision, int ccsid, String dateFormat, String dateSeparator, String timeFormat, String timeSeparator) throws PcmlException {
        switch (dataType) {
            case 1: {
                if (ccsid != this.m_as400.getCcsid()) {
                    return new AS400Text(dataLength, ccsid, this.m_as400);
                }
                switch (dataLength) {
                    case 1: {
                        if (this.m_Text_1 == null) {
                            this.m_Text_1 = new AS400Text(dataLength, ccsid, this.m_as400);
                        }
                        return this.m_Text_1;
                    }
                    case 10: {
                        if (this.m_Text_10 == null) {
                            this.m_Text_10 = new AS400Text(dataLength, ccsid, this.m_as400);
                        }
                        return this.m_Text_10;
                    }
                }
                return new AS400Text(dataLength, ccsid, this.m_as400);
            }
            case 2: {
                if (dataLength == 2) {
                    if (dataPrecision == 16) {
                        return m_UBin2;
                    }
                    return m_Bin2;
                }
                if (dataLength == 4) {
                    if (dataPrecision == 32) {
                        return m_UBin4;
                    }
                    return m_Bin4;
                }
                if (dataPrecision == 64) {
                    return m_UBin8;
                }
                return m_Bin8;
            }
            case 3: {
                if (dataLength == 15 && dataPrecision == 5) {
                    return m_Packed_15_5;
                }
                return new AS400PackedDecimal(dataLength, dataPrecision);
            }
            case 4: {
                if (dataLength == 15 && dataPrecision == 5) {
                    return m_Zoned_15_5;
                }
                return new AS400ZonedDecimal(dataLength, dataPrecision);
            }
            case 5: {
                if (dataLength == 4) {
                    return m_Float4;
                }
                return m_Float8;
            }
            case 6: {
                switch (dataLength) {
                    case 1: {
                        if (this.m_Byte_1 == null) {
                            this.m_Byte_1 = new AS400ByteArray(dataLength);
                        }
                        return this.m_Byte_1;
                    }
                    case 2: {
                        if (this.m_Byte_2 == null) {
                            this.m_Byte_2 = new AS400ByteArray(dataLength);
                        }
                        return this.m_Byte_2;
                    }
                    case 3: {
                        if (this.m_Byte_3 == null) {
                            this.m_Byte_3 = new AS400ByteArray(dataLength);
                        }
                        return this.m_Byte_3;
                    }
                    case 4: {
                        if (this.m_Byte_4 == null) {
                            this.m_Byte_4 = new AS400ByteArray(dataLength);
                        }
                        return this.m_Byte_4;
                    }
                }
                return new AS400ByteArray(dataLength);
            }
            case 8: {
                int format = AS400Date.toFormat(dateFormat);
                if (dateSeparator == null) {
                    return new AS400Date(this.getTimeZone(), format);
                }
                return new AS400Date(this.getTimeZone(), format, PcmlDocument.separatorAsChar(dateSeparator));
            }
            case 9: {
                int format = AS400Time.toFormat(timeFormat);
                if (timeSeparator == null) {
                    return new AS400Time(this.getTimeZone(), format);
                }
                return new AS400Time(this.getTimeZone(), format, PcmlDocument.separatorAsChar(timeSeparator));
            }
            case 10: {
                return new AS400Timestamp(this.getTimeZone());
            }
        }
        throw new PcmlException("BAD_DATA_TYPE", new Object[]{dataType, "*"});
    }

    synchronized boolean callProgram(String name) throws AS400SecurityException, ObjectDoesNotExistException, InterruptedException, ErrorCompletingRequestException, IOException, PcmlException {
        this.m_pcmlProgram = this.getProgramNode(name);
        return this.m_pcmlProgram.callProgram(this.m_as400);
    }

    synchronized int getErrno(String name) throws PcmlException {
        return this.getProgramNode(name).getErrno();
    }

    synchronized int getIntReturnValue(String name) throws PcmlException {
        return this.getProgramNode(name).getIntReturnValue();
    }

    synchronized int getIntValue(String name) throws PcmlException {
        return this.getIntValue(name, new PcmlDimensions());
    }

    synchronized int getIntValue(String name, PcmlDimensions indices) throws PcmlException {
        Object value = this.getValue(name, indices);
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        throw new PcmlException("STRING_OR_NUMBER", new Object[]{value.getClass().getName(), name});
    }

    synchronized String getStringValue(String name, int type) throws PcmlException {
        return this.getStringValue(name, new PcmlDimensions(), type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getCorrelationID() {
        Object object = this.correlationIDLock_;
        synchronized (object) {
            return ++this.correlationID_;
        }
    }

    synchronized String getStringValue(String name, PcmlDimensions indices, int type) throws PcmlException {
        return this.getDataNode(name).getStringValue(indices, type);
    }

    synchronized int getOutputsize(String name) throws PcmlException {
        return this.getOutputsize(name, new PcmlDimensions());
    }

    synchronized int getOutputsize(String name, PcmlDimensions indices) throws PcmlException {
        PcmlDocNode node = (PcmlDocNode)this.getElement(name);
        if (node != null && node instanceof PcmlData) {
            return ((PcmlData)node).getOutputsize(indices);
        }
        if (node != null && node instanceof PcmlStruct) {
            return ((PcmlStruct)node).getOutputsize(indices);
        }
        return 0;
    }

    synchronized AS400Message[] getMessageList(String name) throws PcmlException {
        return this.getProgramNode(name).getMessageList();
    }

    synchronized int getMessageOption(String name) throws PcmlException {
        return this.getProgramNode(name).getMessageOption();
    }

    synchronized ProgramCall getProgramCall() {
        return this.m_pcmlProgram == null ? null : this.m_pcmlProgram.getProgramCall();
    }

    synchronized Object getValue(String name) throws PcmlException {
        return this.getValue(name, new PcmlDimensions());
    }

    synchronized Object getValue(String name, PcmlDimensions indices) throws PcmlException {
        return this.getDataNode(name).getValue(indices);
    }

    synchronized boolean isArray(String name) throws PcmlException {
        return this.getDataNode(name).isArray();
    }

    synchronized boolean isInArray(String name) throws PcmlException {
        return this.getDataNode(name).isInArray();
    }

    synchronized void setValue(String name, Object value) throws PcmlException {
        this.setValue(name, value, new PcmlDimensions());
    }

    synchronized void setValue(String name, Object value, PcmlDimensions indices) throws PcmlException {
        this.getDataNode(name).setValue(value, indices);
    }

    synchronized void setStringValue(String name, String value, int type) throws PcmlException {
        this.setStringValue(name, value, new PcmlDimensions(), type);
    }

    synchronized void setStringValue(String name, String value, PcmlDimensions indices, int type) throws PcmlException {
        this.getDataNode(name).setStringValue(value, indices, type);
    }

    synchronized void setCharArrayValue(String name, char[] value, int type) throws PcmlException {
        this.setCharArrayValue(name, value, new PcmlDimensions(), type);
    }

    synchronized void setCharArrayValue(String name, char[] value, PcmlDimensions indices, int type) throws PcmlException {
        this.getDataNode(name).setCharArrayValue(value, indices, type);
    }

    void setThreadsafeOverride(String program, boolean threadsafe) throws PcmlException {
        this.getProgramNode(program).setThreadsafeOverride(threadsafe);
    }

    void setPath(String program, String path) throws PcmlException {
        this.getProgramNode(program).setPath(path);
    }

    boolean getThreadsafeOverride(String program) throws PcmlException {
        return this.getProgramNode(program).getThreadsafeOverride();
    }

    synchronized void setMessageOption(String program, int messageOption) throws PcmlException {
        this.getProgramNode(program).setMessageOption(messageOption);
    }

    void addToHashtable(PcmlDocNode newChild) {
        Enumeration children = newChild.getChildren();
        if (children == null) {
            return;
        }
        LinkedList<PcmlDocNode> queue = new LinkedList<PcmlDocNode>();
        queue.add(newChild);
        while (!queue.isEmpty()) {
            PcmlDocNode child = (PcmlDocNode)queue.getFirst();
            queue.removeFirst();
            children = child.getChildren();
            while (children.hasMoreElements()) {
                child = (PcmlDocNode)children.nextElement();
                String qName = child.getQualifiedName();
                if (!qName.equals("") && this.addElement(child) != null) {
                    this.addPcmlSpecificationError("MULTIPLE_DEFINE", new Object[]{qName});
                }
                queue.add(child);
            }
        }
    }

    private PcmlProgram getProgramNode(String name) throws PcmlException {
        PcmlNode node = this.getElement(name);
        if (node instanceof PcmlProgram) {
            return (PcmlProgram)node;
        }
        if (node == null) {
            throw new PcmlException("ELEMENT_NOT_FOUND", new Object[]{name, "<program>"});
        }
        throw new PcmlException("WRONG_ELEMENT_TYPE", new Object[]{name, "<program>"});
    }

    private PcmlData getDataNode(String name) throws PcmlException {
        PcmlNode node = this.getElement(name);
        if (node instanceof PcmlData) {
            return (PcmlData)node;
        }
        if (node == null) {
            throw new PcmlException("ELEMENT_NOT_FOUND", new Object[]{name, "<data>"});
        }
        throw new PcmlException("WRONG_ELEMENT_TYPE", new Object[]{name, "<data>"});
    }

    PcmlSpecificationException getPcmlSpecificationException() {
        return this.m_PcmlSpecificationException;
    }

    void addPcmlSpecificationError(String key, Object[] args) {
        if (this.m_PcmlSpecificationException == null) {
            this.m_PcmlSpecificationException = new PcmlSpecificationException(SystemResourceFinder.format("FAILED_TO_VALIDATE", new Object[]{this.m_docName}));
        }
        this.m_PcmlSpecificationException.addMessage(SystemResourceFinder.format(key, args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void generateXPCML(String pgmName, OutputStream outStream) throws IOException, XmlException {
        PrintWriter xmlFile = new PrintWriter(outStream);
        int num_dim = 0;
        int cur_dim = 0;
        int[] dimArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        PcmlDimensions dims = new PcmlDimensions(dimArray);
        try {
            xmlFile.println("<?xml version=\"1.0\" ?>");
            xmlFile.print("<xpcml version=\"6.0\"");
            xmlFile.print(XMLNS_STRING);
            if (!"".equals(this.getXsdName())) {
                xmlFile.println("'" + this.getXsdName() + "' >");
            } else {
                xmlFile.println("'xpcml.xsd' >");
            }
            xmlFile.println();
            if (pgmName == null) {
                this.generateXPCML(this, this, xmlFile, "", num_dim, cur_dim, dims);
            } else {
                this.generateXPCML(this, this.getProgramNode(pgmName), xmlFile, "", num_dim, cur_dim, dims);
            }
            xmlFile.println("</xpcml>");
            if (xmlFile.checkError()) {
                Trace.log(2, "Error when writing PCML to OutputStream.");
            }
        }
        finally {
            xmlFile.close();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void generateXPCML(PcmlDocument pcmlDocNode, PcmlDocNode node, PrintWriter writer, String indent, int num_dimensions, int current_dimension, PcmlDimensions dimensions) throws IOException, XmlException {
        block276: {
            block273: {
                block275: {
                    block274: {
                        block272: {
                            block271: {
                                lastTag = "";
                                tagDone = false;
                                dim = new PcmlDimensions();
                                dim.add(0);
                                if (node.getNodeType() == 2 || node.getNodeType() == 1) {
                                    for (i = 0; i < dimensions.size(); ++i) {
                                        dimensions.set(i, 0);
                                    }
                                    current_dimension = 0;
                                    num_dimensions = 0;
                                }
                                if (node.getCountReps() == -10) {
                                    nodeType = node.getNodeType();
                                    tempInt = nodeType == 4 && ((PcmlData)node).getXPCMLCount(dim) != 0 ? ((PcmlData)node).getXPCMLCount(dim) : (nodeType == 3 && ((PcmlStruct)node).getXPCMLCount(dim) != 0 ? ((PcmlStruct)node).getXPCMLCount(dim) : 1);
                                    node.setCountReps(tempInt);
                                    dimensions.set(current_dimension, 0);
                                }
                                if (node.getNodeType() != 4) break block271;
                                dataType = ((PcmlData)node).getDataType();
                                switch (dataType) {
                                    case 1: {
                                        if (((PcmlData)node).getXPCMLCount(dim) <= 0) ** GOTO lbl32
                                        if (dimensions.at(current_dimension) == 0) {
                                            if (node.getCondensedName() != "") {
                                                writer.print(indent);
                                                writer.print("<" + node.getCondensedName());
                                                lastTag = "arrayOfStringParm";
                                                break;
                                            }
                                            writer.print(indent);
                                            writer.print("<arrayOfStringParm");
                                            lastTag = "arrayOfStringParm";
                                            break;
                                        }
                                        break block272;
lbl32:
                                        // 1 sources

                                        if (node.getCondensedName() != "") {
                                            writer.print(indent);
                                            writer.print("<" + node.getCondensedName());
                                            lastTag = node.getCondensedName();
                                            break;
                                        }
                                        writer.print(indent);
                                        writer.print("<stringParm");
                                        lastTag = "stringParm";
                                        break;
                                    }
                                    case 7: {
                                        if (((PcmlData)node).getXPCMLCount(dim) <= 0) ** GOTO lbl54
                                        if (dimensions.at(current_dimension) == 0) {
                                            if (node.getCondensedName() != "") {
                                                writer.print(indent);
                                                writer.print("<" + node.getCondensedName());
                                                lastTag = "arrayOfStructParm";
                                                break;
                                            }
                                            writer.print(indent);
                                            writer.print("<arrayOfStructParm");
                                            lastTag = "arrayOfStructParm";
                                            break;
                                        }
                                        break block272;
lbl54:
                                        // 1 sources

                                        if (node.getCondensedName() != "") {
                                            writer.print(indent);
                                            writer.print("<" + node.getCondensedName());
                                            lastTag = node.getCondensedName();
                                            break;
                                        }
                                        writer.print(indent);
                                        writer.print("<structParm");
                                        lastTag = "structParm";
                                        break;
                                    }
                                    case 6: {
                                        if (((PcmlData)node).getXPCMLCount(dim) <= 0) ** GOTO lbl76
                                        if (dimensions.at(current_dimension) == 0) {
                                            if (node.getCondensedName() != "") {
                                                writer.print(indent);
                                                writer.print("<" + node.getCondensedName());
                                                lastTag = "arrayOfHexBinaryParm";
                                                break;
                                            }
                                            writer.print(indent);
                                            writer.print("<arrayOfHexBinaryParm");
                                            lastTag = "arrayOfHexBinaryParm";
                                            break;
                                        }
                                        break block272;
lbl76:
                                        // 1 sources

                                        if (node.getCondensedName() != "") {
                                            writer.print(indent);
                                            writer.print("<" + node.getCondensedName());
                                            lastTag = node.getCondensedName();
                                            break;
                                        }
                                        writer.print(indent);
                                        writer.print("<hexBinaryParm");
                                        lastTag = "hexBinaryParm";
                                        break;
                                    }
                                    case 2: {
                                        if (!node.getAttributeValue("length").equals("4")) ** GOTO lbl130
                                        if (node.getAttributeValue("precision") == null || !node.getAttributeValue("precision").equals("32")) ** GOTO lbl109
                                        if (((PcmlData)node).getXPCMLCount(dim) <= 0) ** GOTO lbl100
                                        if (dimensions.at(current_dimension) == 0) {
                                            if (node.getCondensedName() != "") {
                                                writer.print(indent);
                                                writer.print("<" + node.getCondensedName());
                                                lastTag = "arrayOfUnsignedIntParm";
                                                break;
                                            }
                                            writer.print(indent);
                                            writer.print("<arrayOfUnsignedIntParm");
                                            lastTag = "arrayOfUnsignedIntParm";
                                            break;
                                        }
                                        break block272;
lbl100:
                                        // 1 sources

                                        if (node.getCondensedName() != "") {
                                            writer.print(indent);
                                            writer.print("<" + node.getCondensedName());
                                            lastTag = node.getCondensedName();
                                            break;
                                        }
                                        writer.print(indent);
                                        writer.print("<unsignedIntParm");
                                        lastTag = "unsignedIntParm";
                                        break;
lbl109:
                                        // 1 sources

                                        if (((PcmlData)node).getXPCMLCount(dim) <= 0) ** GOTO lbl121
                                        if (dimensions.at(current_dimension) == 0) {
                                            if (node.getCondensedName() != "") {
                                                writer.print(indent);
                                                writer.print("<" + node.getCondensedName());
                                                lastTag = "arrayOfIntParm";
                                                break;
                                            }
                                            writer.print(indent);
                                            writer.print("<arrayOfIntParm");
                                            lastTag = "arrayOfIntParm";
                                            break;
                                        }
                                        break block272;
lbl121:
                                        // 1 sources

                                        if (node.getCondensedName() != "") {
                                            writer.print(indent);
                                            writer.print("<" + node.getCondensedName());
                                            lastTag = node.getCondensedName();
                                            break;
                                        }
                                        writer.print(indent);
                                        writer.print("<intParm");
                                        lastTag = "intParm";
                                        break;
lbl130:
                                        // 1 sources

                                        if (!node.getAttributeValue("length").equals("2")) ** GOTO lbl174
                                        if (node.getAttributeValue("precision") == null || !node.getAttributeValue("precision").equals("16")) ** GOTO lbl153
                                        if (((PcmlData)node).getXPCMLCount(dim) <= 0) ** GOTO lbl144
                                        if (dimensions.at(current_dimension) == 0) {
                                            if (node.getCondensedName() != "") {
                                                writer.print(indent);
                                                writer.print("<" + node.getCondensedName());
                                                lastTag = "arrayOfUnsignedShortParm";
                                                break;
                                            }
                                            writer.print(indent);
                                            writer.print("<arrayOfUnsignedShortParm");
                                            lastTag = "arrayOfUnsignedShortParm";
                                            break;
                                        }
                                        break block272;
lbl144:
                                        // 1 sources

                                        if (node.getCondensedName() != "") {
                                            writer.print(indent);
                                            writer.print("<" + node.getCondensedName());
                                            lastTag = node.getCondensedName();
                                            break;
                                        }
                                        writer.print(indent);
                                        writer.print("<unsignedShortParm");
                                        lastTag = "unsignedShortParm";
                                        break;
lbl153:
                                        // 1 sources

                                        if (((PcmlData)node).getXPCMLCount(dim) <= 0) ** GOTO lbl165
                                        if (dimensions.at(current_dimension) == 0) {
                                            if (node.getCondensedName() != "") {
                                                writer.print(indent);
                                                writer.print("<" + node.getCondensedName());
                                                lastTag = "arrayOfShortParm";
                                                break;
                                            }
                                            writer.print(indent);
                                            writer.print("<arrayOfShortParm");
                                            lastTag = "arrayOfShortParm";
                                            break;
                                        }
                                        break block272;
lbl165:
                                        // 1 sources

                                        if (node.getCondensedName() != "") {
                                            writer.print(indent);
                                            writer.print("<" + node.getCondensedName());
                                            lastTag = node.getCondensedName();
                                            break;
                                        }
                                        writer.print(indent);
                                        writer.print("<shortParm");
                                        lastTag = "shortParm";
                                        break;
lbl174:
                                        // 1 sources

                                        if (!node.getAttributeValue("length").equals("8")) break block272;
                                        if (node.getAttributeValue("precision") == null || !node.getAttributeValue("precision").equals("64")) ** GOTO lbl197
                                        if (((PcmlData)node).getXPCMLCount(dim) <= 0) ** GOTO lbl188
                                        if (dimensions.at(current_dimension) == 0) {
                                            if (node.getCondensedName() != "") {
                                                writer.print(indent);
                                                writer.print("<" + node.getCondensedName());
                                                lastTag = "arrayOfUnsignedLongParm";
                                                break;
                                            }
                                            writer.print(indent);
                                            writer.print("<arrayOfUnsignedLongParm");
                                            lastTag = "arrayOfUnsignedLongParm";
                                            break;
                                        }
                                        break block272;
lbl188:
                                        // 1 sources

                                        if (node.getCondensedName() != "") {
                                            writer.print(indent);
                                            writer.print("<" + node.getCondensedName());
                                            lastTag = node.getCondensedName();
                                            break;
                                        }
                                        writer.print(indent);
                                        writer.print("<unsignedLongParm");
                                        lastTag = "unsignedLongParm";
                                        break;
lbl197:
                                        // 1 sources

                                        if (((PcmlData)node).getXPCMLCount(dim) <= 0) ** GOTO lbl209
                                        if (dimensions.at(current_dimension) == 0) {
                                            if (node.getCondensedName() != "") {
                                                writer.print(indent);
                                                writer.print("<" + node.getCondensedName());
                                                lastTag = "arrayOfLongParm";
                                                break;
                                            }
                                            writer.print(indent);
                                            writer.print("<arrayOfLongParm");
                                            lastTag = "arrayOfLongParm";
                                            break;
                                        }
                                        break block272;
lbl209:
                                        // 1 sources

                                        if (node.getCondensedName() != "") {
                                            writer.print(indent);
                                            writer.print("<" + node.getCondensedName());
                                            lastTag = node.getCondensedName();
                                            break;
                                        }
                                        writer.print(indent);
                                        writer.print("<longParm");
                                        lastTag = "longParm";
                                        break;
                                    }
                                    case 5: {
                                        if (!node.getAttributeValue("length").equals("4")) ** GOTO lbl241
                                        if (((PcmlData)node).getXPCMLCount(dim) <= 0) ** GOTO lbl232
                                        if (dimensions.at(current_dimension) == 0) {
                                            if (node.getCondensedName() != "") {
                                                writer.print(indent);
                                                writer.print("<" + node.getCondensedName());
                                                lastTag = "arrayOfFloatParm";
                                                break;
                                            }
                                            writer.print(indent);
                                            writer.print("<arrayOfFloatParm");
                                            lastTag = "arrayOfFloatParm";
                                            break;
                                        }
                                        break block272;
lbl232:
                                        // 1 sources

                                        if (node.getCondensedName() != "") {
                                            writer.print(indent);
                                            writer.print("<" + node.getCondensedName());
                                            lastTag = node.getCondensedName();
                                            break;
                                        }
                                        writer.print(indent);
                                        writer.print("<floatParm");
                                        lastTag = "floatParm";
                                        break;
lbl241:
                                        // 1 sources

                                        if (!node.getAttributeValue("length").equals("8")) break block272;
                                        if (((PcmlData)node).getXPCMLCount(dim) <= 0) ** GOTO lbl254
                                        if (dimensions.at(current_dimension) == 0) {
                                            if (node.getCondensedName() != "") {
                                                writer.print(indent);
                                                writer.print("<" + node.getCondensedName());
                                                lastTag = "arrayOfDoubleParm";
                                                break;
                                            }
                                            writer.print(indent);
                                            writer.print("<arrayOfDoubleParm");
                                            lastTag = "arrayOfDoubleParm";
                                            break;
                                        }
                                        break block272;
lbl254:
                                        // 1 sources

                                        if (node.getCondensedName() != "") {
                                            writer.print(indent);
                                            writer.print("<" + node.getCondensedName());
                                            lastTag = node.getCondensedName();
                                            break;
                                        }
                                        writer.print(indent);
                                        writer.print("<doubleParm");
                                        lastTag = "doubleParm";
                                        break;
                                    }
                                    case 4: {
                                        if (((PcmlData)node).getXPCMLCount(dim) <= 0) ** GOTO lbl276
                                        if (dimensions.at(current_dimension) == 0) {
                                            if (node.getCondensedName() != "") {
                                                writer.print(indent);
                                                writer.print("<" + node.getCondensedName());
                                                lastTag = "arrayOfZonedDecimalParm";
                                                break;
                                            }
                                            writer.print(indent);
                                            writer.print("<arrayOfZonedDecimalParm");
                                            lastTag = "arrayOfZonedDecimalParm";
                                            break;
                                        }
                                        break block272;
lbl276:
                                        // 1 sources

                                        if (node.getCondensedName() != "") {
                                            writer.print(indent);
                                            writer.print("<" + node.getCondensedName());
                                            lastTag = node.getCondensedName();
                                            break;
                                        }
                                        writer.print(indent);
                                        writer.print("<zonedDecimalParm");
                                        lastTag = "zonedDecimalParm";
                                        break;
                                    }
                                    case 3: {
                                        if (((PcmlData)node).getXPCMLCount(dim) <= 0) ** GOTO lbl298
                                        if (dimensions.at(current_dimension) == 0) {
                                            if (node.getCondensedName() != "") {
                                                writer.print(indent);
                                                writer.print("<" + node.getCondensedName());
                                                lastTag = "arrayOfPackedDecimalParm";
                                                break;
                                            }
                                            writer.print(indent);
                                            writer.print("<arrayOfPackedDecimalParm");
                                            lastTag = "arrayOfPackedDecimalParm";
                                            break;
                                        }
                                        break block272;
lbl298:
                                        // 1 sources

                                        if (node.getCondensedName() != "") {
                                            writer.print(indent);
                                            writer.print("<" + node.getCondensedName());
                                            lastTag = node.getCondensedName();
                                            break;
                                        }
                                        writer.print(indent);
                                        writer.print("<packedDecimalParm");
                                        lastTag = "packedDecimalParm";
                                        break;
                                    }
                                    case 8: {
                                        if (((PcmlData)node).getXPCMLCount(dim) <= 0) ** GOTO lbl320
                                        if (dimensions.at(current_dimension) == 0) {
                                            if (node.getCondensedName() != "") {
                                                writer.print(indent);
                                                writer.print("<" + node.getCondensedName());
                                                lastTag = "arrayOfDateParm";
                                                break;
                                            }
                                            writer.print(indent);
                                            writer.print("<arrayOfDateParm");
                                            lastTag = "arrayOfDateParm";
                                            break;
                                        }
                                        break block272;
lbl320:
                                        // 1 sources

                                        if (node.getCondensedName() != "") {
                                            writer.print(indent);
                                            writer.print("<" + node.getCondensedName());
                                            lastTag = node.getCondensedName();
                                            break;
                                        }
                                        writer.print(indent);
                                        writer.print("<dateParm");
                                        lastTag = "dateParm";
                                        break;
                                    }
                                    case 9: {
                                        if (((PcmlData)node).getXPCMLCount(dim) <= 0) ** GOTO lbl342
                                        if (dimensions.at(current_dimension) == 0) {
                                            if (node.getCondensedName() != "") {
                                                writer.print(indent);
                                                writer.print("<" + node.getCondensedName());
                                                lastTag = "arrayOfTimeParm";
                                                break;
                                            }
                                            writer.print(indent);
                                            writer.print("<arrayOfTimeParm");
                                            lastTag = "arrayOfTimeParm";
                                            break;
                                        }
                                        break block272;
lbl342:
                                        // 1 sources

                                        if (node.getCondensedName() != "") {
                                            writer.print(indent);
                                            writer.print("<" + node.getCondensedName());
                                            lastTag = node.getCondensedName();
                                            break;
                                        }
                                        writer.print(indent);
                                        writer.print("<timeParm");
                                        lastTag = "timeParm";
                                        break;
                                    }
                                    case 10: {
                                        if (((PcmlData)node).getXPCMLCount(dim) <= 0) ** GOTO lbl364
                                        if (dimensions.at(current_dimension) == 0) {
                                            if (node.getCondensedName() != "") {
                                                writer.print(indent);
                                                writer.print("<" + node.getCondensedName());
                                                lastTag = "arrayOfTimestampParm";
                                                break;
                                            }
                                            writer.print(indent);
                                            writer.print("<arrayOfTimestampParm");
                                            lastTag = "arrayOfTimestampParm";
                                            break;
                                        }
                                        break block272;
lbl364:
                                        // 1 sources

                                        if (node.getCondensedName() != "") {
                                            writer.print(indent);
                                            writer.print("<" + node.getCondensedName());
                                            lastTag = node.getCondensedName();
                                            break;
                                        }
                                        writer.print(indent);
                                        writer.print("<timestampParm");
                                        lastTag = "timestampParm";
                                        break;
                                    }
                                    default: {
                                        throw new PcmlException("BAD_DATA_TYPE", new Object[]{dataType, "*"});
                                    }
                                }
                                break block272;
                            }
                            if (node.getNodeType() == 3) {
                                if (((PcmlStruct)node).getXPCMLCount(dim) > 0) {
                                    if (dimensions.at(current_dimension) == 0) {
                                        if (node.getCondensedName() != "") {
                                            writer.print(indent);
                                            writer.print("<" + node.getCondensedName());
                                            lastTag = "arrayOfStruct";
                                        } else {
                                            writer.print(indent);
                                            writer.print("<arrayOfStruct");
                                            lastTag = "arrayOfStruct";
                                        }
                                    }
                                } else if (node.getCondensedName() != "") {
                                    writer.print(indent);
                                    writer.print("<" + node.getCondensedName());
                                    lastTag = node.getCondensedName();
                                } else {
                                    writer.print(indent);
                                    writer.print("<struct");
                                    lastTag = "struct";
                                }
                            } else if (node.getNodeType() == 2) {
                                writer.println();
                                writer.print(indent + "<program");
                                lastTag = "program";
                            } else if (node.getNodeType() == 1) {
                                // empty if block
                            }
                        }
                        attrs = node.getAttributeList();
                        if (!(node.getCondensedName() != "" && !node.getIsExtendedType() || node.getNodeType() == 4 && dimensions.at(current_dimension) > 0 || node.getNodeType() == 3 && dimensions.at(current_dimension) > 0)) {
                            for (i = 0; i < attrs.length; ++i) {
                                if (node.getAttributeValue(attrs[i]) == null) continue;
                                if (attrs[i].equals("usage")) {
                                    if (node.getAttributeValue(attrs[i]).equals("input")) {
                                        writer.print(" passDirection=\"in\"");
                                        continue;
                                    }
                                    if (node.getAttributeValue(attrs[i]).equals("output")) {
                                        writer.print(" passDirection=\"out\"");
                                        continue;
                                    }
                                    if (!node.getAttributeValue(attrs[i]).equals("inputoutput")) continue;
                                    writer.print(" passDirection=\"inout\"");
                                    continue;
                                }
                                if (attrs[i].equals("passby")) {
                                    writer.print(" passMode=\"" + node.getAttributeValue(attrs[i]) + "\"");
                                    continue;
                                }
                                if (attrs[i].equals("type") || attrs[i].equals("length") && node.getAttributeValue("type") != null && (node.getAttributeValue("type").equals("int") || node.getAttributeValue("type").equals("float"))) continue;
                                if (attrs[i].equals("length") && node.getAttributeValue("type") != null && node.getAttributeValue("type").equals("byte")) {
                                    writer.print(" totalBytes=\"" + node.getAttributeValue(attrs[i]) + "\"");
                                    continue;
                                }
                                if (attrs[i].equals("length") && node.getAttributeValue("type") != null && (node.getAttributeValue("type").equals("zoned") || node.getAttributeValue("type").equals("packed"))) {
                                    writer.print(" totalDigits=\"" + node.getAttributeValue(attrs[i]) + "\"");
                                    continue;
                                }
                                if (attrs[i].equals("precision") && node.getAttributeValue("type") != null && (node.getAttributeValue("type").equals("zoned") || node.getAttributeValue("type").equals("packed"))) {
                                    writer.print(" fractionDigits=\"" + node.getAttributeValue(attrs[i]) + "\"");
                                    continue;
                                }
                                if (attrs[i].equals("version") || attrs[i].equals("init") || attrs[i].equals("precision")) continue;
                                if (attrs[i].equals("offsetfrom")) {
                                    writer.print(" offsetFrom=\"" + node.getAttributeValue(attrs[i]) + "\"");
                                    continue;
                                }
                                if (attrs[i].equals("outputsize")) {
                                    writer.print(" outputSize=\"" + node.getAttributeValue(attrs[i]) + "\"");
                                    continue;
                                }
                                if (attrs[i].equals("bidistringtype")) {
                                    writer.print(" bidiStringType=\"" + node.getAttributeValue(attrs[i]) + "\"");
                                    continue;
                                }
                                if (attrs[i].equals("chartype")) {
                                    writer.print(" bytesPerChar=\"" + node.getAttributeValue(attrs[i]) + "\"");
                                    continue;
                                }
                                if (attrs[i].equals("parseorder")) {
                                    writer.print(" parseOrder=\"" + node.getAttributeValue(attrs[i]) + "\"");
                                    continue;
                                }
                                if (attrs[i].equals("entrypoint")) {
                                    writer.print(" entryPoint=\"" + node.getAttributeValue(attrs[i]) + "\"");
                                    continue;
                                }
                                if (attrs[i].equals("threadsafe")) {
                                    writer.print(" threadSafe=\"" + node.getAttributeValue(attrs[i]) + "\"");
                                    continue;
                                }
                                if (attrs[i].equals("returnvalue")) {
                                    writer.print(" returnValue=\"" + node.getAttributeValue(attrs[i]) + "\"");
                                    continue;
                                }
                                if (attrs[i].equals("dateformat") && node.getAttributeValue("type") != null && node.getAttributeValue("type").equals("date")) {
                                    writer.print(" dateFormat=\"" + node.getAttributeValue(attrs[i]) + "\"");
                                    continue;
                                }
                                if (attrs[i].equals("dateseparator") && node.getAttributeValue("type") != null && node.getAttributeValue("type").equals("date")) {
                                    writer.print(" dateSeparator=\"" + node.getAttributeValue(attrs[i]) + "\"");
                                    continue;
                                }
                                if (attrs[i].equals("timeformat") && node.getAttributeValue("type") != null && node.getAttributeValue("type").equals("time")) {
                                    writer.print(" timeFormat=\"" + node.getAttributeValue(attrs[i]) + "\"");
                                    continue;
                                }
                                if (attrs[i].equals("timeseparator") && node.getAttributeValue("type") != null && node.getAttributeValue("type").equals("time")) {
                                    writer.print(" timeSeparator=\"" + node.getAttributeValue(attrs[i]) + "\"");
                                    continue;
                                }
                                writer.print(" " + attrs[i] + "=\"" + node.getAttributeValue(attrs[i]) + "\"");
                            }
                        }
                        if (node.getCountReps() != 0) {
                            node.setCountReps(node.getCountReps() - 1);
                        }
                        if (!node.hasChildren()) break block273;
                        if (node.getNodeType() != 1 && dimensions.at(current_dimension) == 0) {
                            writer.println(">");
                        }
                        if (node.getNodeType() == 4 && ((PcmlData)node).getDataType() == 7 && ((PcmlData)node).getXPCMLCount(dim) > 0) {
                            if (dimensions.at(current_dimension) > 0) {
                                writer.println(indent + "  <struct_i index=\"" + dimensions.at(current_dimension) + "\">");
                            } else {
                                writer.println(indent + "  <struct_i index=\"" + dimensions.at(current_dimension) + "\">");
                            }
                            lastTag = "struct_i";
                        }
                        if (node.getNodeType() == 3 && ((PcmlStruct)node).getXPCMLCount(dim) > 0) {
                            if (dimensions.at(current_dimension) > 0) {
                                writer.println(indent + "  <struct_i index=\"" + dimensions.at(current_dimension) + "\">");
                            } else {
                                writer.println(indent + "  <struct_i index=\"" + dimensions.at(current_dimension) + "\">");
                            }
                            lastTag = "struct_i";
                        }
                        if (node.getNodeType() == 2) {
                            writer.println(indent + "<parameterList>");
                        }
                        children = node.getChildren();
                        while (children.hasMoreElements()) {
                            child = (PcmlDocNode)children.nextElement();
                            if (child.getNodeType() == 2) {
                                for (i = 0; i < dimensions.size(); ++i) {
                                    dimensions.set(i, 0);
                                }
                                current_dimension = 0;
                                num_dimensions = 0;
                            }
                            if (child.getNodeType() == 3 && child.getParent().getName().trim().length() == 0) {
                                for (i = 0; i < dimensions.size(); ++i) {
                                    dimensions.set(i, 0);
                                }
                                current_dimension = 0;
                                num_dimensions = 0;
                            }
                            if (child.getChildNbr() == 0 && (node.getNodeType() == 4 && ((PcmlData)node).getXPCMLCount(dim) > 0 || node.getNodeType() == 3 && ((PcmlStruct)node).getXPCMLCount(dim) > 0)) {
                                ++current_dimension;
                                if (++num_dimensions > 9) {
                                    dimensions.add(0);
                                }
                            }
                            this.generateXPCML(pcmlDocNode, child, writer, indent + "    ", num_dimensions, current_dimension, dimensions);
                        }
                        if (node.getNodeType() == 2) {
                            writer.println(indent + "</parameterList>");
                        }
                        if (node.getNodeType() != 4) break block274;
                        dataType = ((PcmlData)node).getDataType();
                        writer.print(indent);
                        switch (dataType) {
                            case 1: {
                                if (((PcmlData)node).getXPCMLCount(dim) <= 0) {
                                    if (node.getCondensedName() != "") {
                                        writer.print("</" + node.getCondensedName() + ">");
                                        break;
                                    }
                                    writer.print("</stringParm>");
                                    break;
                                }
                                writer.println("  </i>");
                                if (node.getCountReps() == 0) {
                                    if (node.getCondensedName() != "") {
                                        writer.print("</" + node.getCondensedName() + ">");
                                        break;
                                    }
                                    writer.println("</arrayOfStringParm>");
                                    break;
                                }
                                break block275;
                            }
                            case 7: {
                                if (((PcmlData)node).getXPCMLCount(dim) <= 0) {
                                    if (node.getCondensedName() != "") {
                                        writer.print("</" + node.getCondensedName() + ">");
                                        break;
                                    }
                                    writer.println("</structParm>");
                                    break;
                                }
                                writer.println("  </struct_i>");
                                if (node.getCountReps() == 0) {
                                    if (node.getCondensedName() != "") {
                                        writer.print(indent + "</" + node.getCondensedName() + ">");
                                        break;
                                    }
                                    writer.println(indent + "</arrayOfStructParm>");
                                    break;
                                }
                                break block275;
                            }
                            case 6: {
                                if (((PcmlData)node).getXPCMLCount(dim) <= 0) {
                                    if (node.getCondensedName() != "") {
                                        writer.print("</" + node.getCondensedName() + ">");
                                        break;
                                    }
                                    writer.print("</hexBinaryParm>");
                                    break;
                                }
                                writer.println("  </i>");
                                if (node.getCountReps() == 0) {
                                    if (node.getCondensedName() != "") {
                                        writer.print("</" + node.getCondensedName() + ">");
                                        break;
                                    }
                                    writer.println("</arrayOfHexBinaryParm>");
                                    break;
                                }
                                break block275;
                            }
                            case 2: {
                                if (node.getAttributeValue("length").equals("4") && node.getAttributeValue("precision") != null && node.getAttributeValue("precision").equals("32")) {
                                    if (((PcmlData)node).getXPCMLCount(dim) <= 0) {
                                        if (node.getCondensedName() != "") {
                                            writer.print("</" + node.getCondensedName() + ">");
                                            break;
                                        }
                                        writer.print("</unsignedIntParm>");
                                        break;
                                    }
                                    writer.println("  </i>");
                                    if (node.getCountReps() == 0) {
                                        if (node.getCondensedName() != "") {
                                            writer.print("</" + node.getCondensedName() + ">");
                                            break;
                                        }
                                        writer.println("</arrayOfUnsignedIntParm>");
                                        break;
                                    }
                                } else if (node.getAttributeValue("length").equals("4")) {
                                    if (((PcmlData)node).getXPCMLCount(dim) <= 0) {
                                        if (node.getCondensedName() != "") {
                                            writer.print("</" + node.getCondensedName() + ">");
                                            break;
                                        }
                                        writer.print("</intParm>");
                                        break;
                                    }
                                    writer.println("  </i>");
                                    if (node.getCountReps() == 0) {
                                        if (node.getCondensedName() != "") {
                                            writer.print("</" + node.getCondensedName() + ">");
                                            break;
                                        }
                                        writer.println("</arrayOfIntParm>");
                                        break;
                                    }
                                } else if (node.getAttributeValue("length").equals("2") && node.getAttributeValue("precision") != null && node.getAttributeValue("precision").equals("16")) {
                                    if (((PcmlData)node).getXPCMLCount(dim) <= 0) {
                                        if (node.getCondensedName() != "") {
                                            writer.print("</" + node.getCondensedName() + ">");
                                            break;
                                        }
                                        writer.print("</unsignedShortParm>");
                                        break;
                                    }
                                    writer.println("  </i>");
                                    if (node.getCountReps() == 0) {
                                        if (node.getCondensedName() != "") {
                                            writer.print("</" + node.getCondensedName() + ">");
                                            break;
                                        }
                                        writer.println("</arrayOfUnsignedShortParm>");
                                        break;
                                    }
                                } else if (node.getAttributeValue("length").equals("2")) {
                                    if (((PcmlData)node).getXPCMLCount(dim) <= 0) {
                                        if (node.getCondensedName() != "") {
                                            writer.print("</" + node.getCondensedName() + ">");
                                            break;
                                        }
                                        writer.print("</shortParm>");
                                        break;
                                    }
                                    writer.println("  </i>");
                                    if (node.getCountReps() == 0) {
                                        if (node.getCondensedName() != "") {
                                            writer.print("</" + node.getCondensedName() + ">");
                                            break;
                                        }
                                        writer.println("</arrayOfShortParm>");
                                        break;
                                    }
                                } else if (node.getAttributeValue("length").equals("8")) {
                                    if (((PcmlData)node).getXPCMLCount(dim) <= 0) {
                                        if (node.getCondensedName() != "") {
                                            writer.print("</" + node.getCondensedName() + ">");
                                            break;
                                        }
                                        writer.print("</longParm>");
                                        break;
                                    }
                                    writer.println("  </i>");
                                    if (node.getCountReps() == 0) {
                                        if (node.getCondensedName() != "") {
                                            writer.print("</" + node.getCondensedName() + ">");
                                            break;
                                        }
                                        writer.println("</arrayOfLongParm>");
                                        break;
                                    }
                                }
                                break block275;
                            }
                            case 5: {
                                if (node.getAttributeValue("length").equals("4")) {
                                    if (((PcmlData)node).getXPCMLCount(dim) <= 0) {
                                        if (node.getCondensedName() != "") {
                                            writer.print("</" + node.getCondensedName() + ">");
                                            break;
                                        }
                                        writer.print("</floatParm>");
                                        break;
                                    }
                                    writer.println("  </i>");
                                    if (node.getCountReps() == 0) {
                                        if (node.getCondensedName() != "") {
                                            writer.print("</" + node.getCondensedName() + ">");
                                            break;
                                        }
                                        writer.println("</arrayOfFloatParm>");
                                        break;
                                    }
                                } else if (node.getAttributeValue("length").equals("8")) {
                                    if (((PcmlData)node).getXPCMLCount(dim) <= 0) {
                                        if (node.getCondensedName() != "") {
                                            writer.print("</" + node.getCondensedName() + ">");
                                            break;
                                        }
                                        writer.print("</doubleParm>");
                                        break;
                                    }
                                    writer.println("  </i>");
                                    if (node.getCountReps() == 0) {
                                        if (node.getCondensedName() != "") {
                                            writer.print("</" + node.getCondensedName() + ">");
                                            break;
                                        }
                                        writer.println("</arrayOfDoubleParm>");
                                        break;
                                    }
                                }
                                break block275;
                            }
                            case 4: {
                                if (((PcmlData)node).getXPCMLCount(dim) <= 0) {
                                    if (node.getCondensedName() != "") {
                                        writer.print("</" + node.getCondensedName() + ">");
                                        break;
                                    }
                                    writer.print("</zonedDecimalParm>");
                                    break;
                                }
                                writer.println("  </i>");
                                if (node.getCountReps() == 0) {
                                    if (node.getCondensedName() != "") {
                                        writer.print("</" + node.getCondensedName() + ">");
                                        break;
                                    }
                                    writer.println("</arrayOfZonedDecimalParm>");
                                    break;
                                }
                                break block275;
                            }
                            case 3: {
                                if (((PcmlData)node).getXPCMLCount(dim) <= 0) {
                                    if (node.getCondensedName() != "") {
                                        writer.print("</" + node.getCondensedName() + ">");
                                        break;
                                    }
                                    writer.print("</packedDecimalParm>");
                                    break;
                                }
                                writer.println("  </i>");
                                if (node.getCountReps() == 0) {
                                    if (node.getCondensedName() != "") {
                                        writer.print("</" + node.getCondensedName() + ">");
                                        break;
                                    }
                                    writer.println("</arrayOfPackedDecimalParm>");
                                    break;
                                }
                                break block275;
                            }
                            case 8: {
                                if (((PcmlData)node).getXPCMLCount(dim) <= 0) {
                                    if (node.getCondensedName() != "") {
                                        writer.print("</" + node.getCondensedName() + ">");
                                        break;
                                    }
                                    writer.print("</dateParm>");
                                    break;
                                }
                                writer.println("  </i>");
                                if (node.getCountReps() == 0) {
                                    if (node.getCondensedName() != "") {
                                        writer.print("</" + node.getCondensedName() + ">");
                                        break;
                                    }
                                    writer.println("</arrayOfDateParm>");
                                    break;
                                }
                                break block275;
                            }
                            case 9: {
                                if (((PcmlData)node).getXPCMLCount(dim) <= 0) {
                                    if (node.getCondensedName() != "") {
                                        writer.print("</" + node.getCondensedName() + ">");
                                        break;
                                    }
                                    writer.print("</timeParm>");
                                    break;
                                }
                                writer.println("  </i>");
                                if (node.getCountReps() == 0) {
                                    if (node.getCondensedName() != "") {
                                        writer.print("</" + node.getCondensedName() + ">");
                                        break;
                                    }
                                    writer.println("</arrayOfTimeParm>");
                                    break;
                                }
                                break block275;
                            }
                            case 10: {
                                if (((PcmlData)node).getXPCMLCount(dim) <= 0) {
                                    if (node.getCondensedName() != "") {
                                        writer.print("</" + node.getCondensedName() + ">");
                                        break;
                                    }
                                    writer.print("</timestampParm>");
                                    break;
                                }
                                writer.println("  </i>");
                                if (node.getCountReps() == 0) {
                                    if (node.getCondensedName() != "") {
                                        writer.print("</" + node.getCondensedName() + ">");
                                        break;
                                    }
                                    writer.println("</arrayOfTimestampParm>");
                                    break;
                                }
                                break block275;
                            }
                            default: {
                                throw new PcmlException("BAD_DATA_TYPE", new Object[]{dataType, "*"});
                            }
                        }
                        break block275;
                    }
                    if (node.getNodeType() == 3) {
                        writer.print(indent);
                        if (((PcmlStruct)node).getXPCMLCount(dim) <= 0) {
                            if (node.getCondensedName() != "") {
                                writer.print("</" + node.getCondensedName() + ">");
                            } else {
                                writer.println("</struct>");
                            }
                        } else {
                            writer.println("  </struct_i>");
                            if (node.getCountReps() == 0) {
                                if (node.getCondensedName() != "") {
                                    writer.print(indent + "</" + node.getCondensedName() + ">");
                                } else {
                                    writer.println(indent + "</arrayOfStruct>");
                                }
                            }
                        }
                    } else if (node.getNodeType() != 1) {
                        writer.println(indent + "</" + node.getTagName() + ">");
                    }
                }
                if (node.getNodeType() == 2) {
                    writer.println();
                }
                if (node.getNodeType() == 4 && ((PcmlData)node).getXPCMLCount(dim) > 0 || node.getNodeType() == 3 && ((PcmlStruct)node).getXPCMLCount(dim) > 0) {
                    --current_dimension;
                    --num_dimensions;
                }
                if (node.getCountReps() > 0) {
                    countVal = 0;
                    if (node.getNodeType() == 4 && ((PcmlData)node).getXPCMLCount(dim) != 0) {
                        countVal = ((PcmlData)node).getXPCMLCount(dim);
                    }
                    if (node.getNodeType() == 3 && ((PcmlStruct)node).getXPCMLCount(dim) != 0) {
                        countVal = ((PcmlStruct)node).getXPCMLCount(dim);
                    }
                    if (node.getNodeType() != 4 && node.getNodeType() != 3) {
                        countVal = 0;
                    }
                    dimensions.set(current_dimension, countVal - node.getCountReps());
                    this.generateXPCML(pcmlDocNode, node, writer, indent, num_dimensions, current_dimension, dimensions);
                } else {
                    node.setCountReps(-10);
                }
                break block276;
            }
            if (node.getNodeType() == 4 && !node.getAttributeValue("type").equals("struct")) {
                strVal = "";
                indices = new int[]{node.getCountReps()};
                if (node.getQualifiedName().trim().equals("")) {
                    strVal = "";
                } else {
                    try {
                        if (node.getAttributeValue("type").equals("byte")) {
                            length = ((PcmlData)node).getLength(dimensions);
                            byteVal = new byte[length];
                            byteVal = (byte[])pcmlDocNode.getValue(node.getQualifiedName(), dimensions);
                            if (byteVal != null) {
                                strVal = BinaryConverter.bytesToString(byteVal);
                            }
                        } else {
                            strVal = "";
                            objVal = pcmlDocNode.getValue(node.getQualifiedName(), dimensions);
                            if (objVal != null) {
                                if (objVal instanceof Date) {
                                    strVal = AS400Date.toXsdString(objVal, this.getTimeZone());
                                } else if (objVal instanceof Time) {
                                    strVal = AS400Time.toXsdString(objVal, this.getTimeZone());
                                } else if (objVal instanceof Timestamp) {
                                    strVal = AS400Timestamp.toXsdString(objVal, this.getTimeZone());
                                } else {
                                    strVal = objVal.toString();
                                    strVal = PcmlDocument.escapeSpecialCharaceters(strVal);
                                }
                            }
                        }
                    }
                    catch (PcmlException e) {
                        Trace.log(7, "No value for node: " + node.getQualifiedName());
                    }
                    catch (IllegalArgumentException e) {
                        Trace.log(7, "Bad count value for node: " + node.getQualifiedName());
                    }
                }
                if (((PcmlData)node).getXPCMLCount(dim) > 0) {
                    if (lastTag.equals("arrayOfStringParm") || lastTag.equals("arrayOfIntParm") || lastTag.equals("arrayOfLongParm") || lastTag.equals("arrayOfUnsignedLongParm") || lastTag.equals("arrayOfUnsignedIntParm") || lastTag.equals("arrayOfShortParm") || lastTag.equals("arrayOfUnsignedShortParm") || lastTag.equals("arrayOfFloatParm") || lastTag.equals("arrayOfDoubleParm") || lastTag.equals("arrayOfZonedDecimalParm") || lastTag.equals("arrayOfPackedDecimalParm") || lastTag.equals("arrayOfHexBinaryParm") || lastTag.equals("arrayOfDateParm") || lastTag.equals("arrayOfTimeParm") || lastTag.equals("arrayOfTimestampParm")) {
                        writer.println(">");
                    }
                    if (dimensions.at(current_dimension) > 0) {
                        writer.print(indent + "  <i index=\"" + dimensions.at(current_dimension) + "\">" + strVal);
                    } else {
                        writer.print(indent + "  <i index=\"" + dimensions.at(current_dimension) + "\">" + strVal);
                    }
                } else {
                    writer.print(">" + strVal);
                }
                if (((PcmlData)node).getXPCMLCount(dim) > 0) {
                    writer.println("</i>");
                    tagDone = true;
                } else {
                    writer.println("</" + lastTag + ">");
                    tagDone = true;
                }
            }
            if (!tagDone) {
                writer.println("/>");
            }
            if (node.getCountReps() > 0) {
                countVal = node.getNodeType() == 4 && ((PcmlData)node).getXPCMLCount(dim) != 0 ? ((PcmlData)node).getXPCMLCount(dim) : (node.getNodeType() == 3 && ((PcmlStruct)node).getXPCMLCount(dim) != 0 ? ((PcmlStruct)node).getXPCMLCount(dim) : 0);
                countV = countVal - node.getCountReps();
                dimensions.set(current_dimension, countVal - node.getCountReps());
                this.generateXPCML(pcmlDocNode, node, writer, indent, num_dimensions, current_dimension, dimensions);
            } else {
                if (((PcmlData)node).getXPCMLCount(dim) > 0) {
                    dataType = ((PcmlData)node).getDataType();
                    writer.print(indent);
                    switch (dataType) {
                        case 1: {
                            if (node.getCondensedName() != "") {
                                writer.println("</" + node.getCondensedName() + ">");
                                break;
                            }
                            writer.println("</arrayOfStringParm>");
                            break;
                        }
                        case 2: {
                            if (node.getAttributeValue("length").equals("4") && node.getAttributeValue("precision") != null && node.getAttributeValue("precision").equals("32")) {
                                if (node.getCondensedName() != "") {
                                    writer.println("</" + node.getCondensedName() + ">");
                                    break;
                                }
                                writer.println("</arrayOfUnsignedIntParm>");
                                break;
                            }
                            if (node.getAttributeValue("length").equals("4")) {
                                if (node.getCondensedName() != "") {
                                    writer.println("</" + node.getCondensedName() + ">");
                                    break;
                                }
                                writer.println("</arrayOfIntParm>");
                                break;
                            }
                            if (node.getAttributeValue("length").equals("2") && node.getAttributeValue("precision") != null && node.getAttributeValue("precision").equals("16")) {
                                if (node.getCondensedName() != "") {
                                    writer.println("</" + node.getCondensedName() + ">");
                                    break;
                                }
                                writer.println("</arrayOfUnsignedShortParm>");
                                break;
                            }
                            if (node.getAttributeValue("length").equals("2")) {
                                if (node.getCondensedName() != "") {
                                    writer.println("</" + node.getCondensedName() + ">");
                                    break;
                                }
                                writer.println("</arrayOfShortParm>");
                                break;
                            }
                            if (!node.getAttributeValue("length").equals("8")) break;
                            if (node.getCondensedName() != "") {
                                writer.println("</" + node.getCondensedName() + ">");
                                break;
                            }
                            writer.println("</arrayOfLongParm>");
                            break;
                        }
                        case 5: {
                            if (node.getAttributeValue("length").equals("8")) {
                                if (node.getCondensedName() != "") {
                                    writer.println("</" + node.getCondensedName() + ">");
                                    break;
                                }
                                writer.println("</arrayOfDoubleParm>");
                                break;
                            }
                            if (!node.getAttributeValue("length").equals("4")) break;
                            if (node.getCondensedName() != "") {
                                writer.println("</" + node.getCondensedName() + ">");
                                break;
                            }
                            writer.println("</arrayOfFloatParm>");
                            break;
                        }
                        case 4: {
                            if (node.getCondensedName() != "") {
                                writer.println("</" + node.getCondensedName() + ">");
                                break;
                            }
                            writer.println("</arrayOfZonedDecimalParm>");
                            break;
                        }
                        case 3: {
                            if (node.getCondensedName() != "") {
                                writer.println("</" + node.getCondensedName() + ">");
                                break;
                            }
                            writer.println("</arrayOfPackedDecimalParm>");
                            break;
                        }
                        case 6: {
                            if (node.getCondensedName() != "") {
                                writer.println("</" + node.getCondensedName() + ">");
                                break;
                            }
                            writer.println("</arrayOfHexBinaryParm>");
                            break;
                        }
                        case 8: {
                            if (node.getCondensedName() != "") {
                                writer.println("</" + node.getCondensedName() + ">");
                                break;
                            }
                            writer.println("</arrayOfDateParm>");
                            break;
                        }
                        case 9: {
                            if (node.getCondensedName() != "") {
                                writer.println("</" + node.getCondensedName() + ">");
                                break;
                            }
                            writer.println("</arrayOfTimeParm>");
                            break;
                        }
                        case 10: {
                            if (node.getCondensedName() != "") {
                                writer.println("</" + node.getCondensedName() + ">");
                                break;
                            }
                            writer.println("</arrayOfTimestampParm>");
                            break;
                        }
                    }
                }
                node.setCountReps(-10);
            }
        }
        writer.flush();
    }

    void setXsdName(String xsdName) {
        this.m_XsdName = xsdName;
    }

    String getXsdName() {
        return this.m_XsdName;
    }

    void copyValues(PcmlDocNode root, PcmlDocNode node) throws IOException, XmlException {
        int num_dim = 0;
        int cur_dim = 0;
        int[] dims = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        PcmlDimensions dimensions = new PcmlDimensions(dims);
        String[] struct = new String[30];
        String[] structR = new String[30];
        int count = 0;
        this.copyValues(root, node, num_dim, cur_dim, dimensions, struct, structR, count);
    }

    void copyValues(PcmlDocNode root, PcmlDocNode node, int num_dimensions, int current_dimension, PcmlDimensions dimensions, String[] struct, String[] structR, int count) throws IOException, XmlException {
        PcmlDimensions dim = new PcmlDimensions();
        dim.add(0);
        if (count < 0) {
            count = 0;
        }
        if (node.getNodeType() == 2 || node.getNodeType() == 1) {
            int i;
            for (i = 0; i < dimensions.size(); ++i) {
                dimensions.set(i, 0);
            }
            current_dimension = 0;
            num_dimensions = 0;
            for (i = 0; i < 10; ++i) {
                struct[i] = "";
                structR[i] = "";
            }
            count = 0;
        }
        if (node.getNodeType() == 4 && node.getAttributeValue("type").equals("struct")) {
            PcmlDocNode parent = (PcmlDocNode)node.getParent();
            count = parent.getNodeType() == 4 && parent.getAttributeValue("type").equals("struct") ? ++count : 0;
            structR[count] = node.getName();
            struct[count] = node.getAttributeValue("struct");
        }
        if (node.getCountReps() == -10) {
            int nodeType = node.getNodeType();
            int tempInt = nodeType == 4 && ((PcmlData)node).getXPCMLCount(dim) != 0 ? ((PcmlData)node).getXPCMLCount(dim) : (nodeType == 3 && ((PcmlStruct)node).getXPCMLCount(dim) != 0 ? ((PcmlStruct)node).getXPCMLCount(dim) : 1);
            node.setCountReps(tempInt);
            dimensions.set(current_dimension, 0);
        }
        if (node.getCountReps() != 0) {
            node.setCountReps(node.getCountReps() - 1);
        }
        if (node.hasChildren()) {
            Enumeration children = node.getChildren();
            while (children.hasMoreElements()) {
                int i;
                PcmlDocNode child = (PcmlDocNode)children.nextElement();
                if (child.getNodeType() == 2) {
                    for (i = 0; i < dimensions.size(); ++i) {
                        dimensions.set(i, 0);
                    }
                    current_dimension = 0;
                    num_dimensions = 0;
                    for (i = 0; i < 30; ++i) {
                        struct[i] = "";
                        structR[i] = "";
                    }
                    count = 0;
                }
                if (child.getNodeType() == 3 && child.getParent().getName().trim().length() == 0) {
                    for (i = 0; i < dimensions.size(); ++i) {
                        dimensions.set(i, 0);
                    }
                    current_dimension = 0;
                    num_dimensions = 0;
                    for (i = 0; i < 30; ++i) {
                        struct[i] = "";
                        structR[i] = "";
                    }
                    count = 0;
                }
                if (child.getChildNbr() == 0 && (node.getNodeType() == 4 && ((PcmlData)node).getXPCMLCount(dim) > 0 || node.getNodeType() == 3 && ((PcmlStruct)node).getXPCMLCount(dim) > 0)) {
                    ++current_dimension;
                    if (++num_dimensions > 9) {
                        dimensions.add(0);
                    }
                }
                this.copyValues(root, child, num_dimensions, current_dimension, dimensions, struct, structR, count);
            }
            if (node.getNodeType() == 4 && ((PcmlData)node).getXPCMLCount(dim) > 0 || node.getNodeType() == 3 && ((PcmlStruct)node).getXPCMLCount(dim) > 0) {
                --current_dimension;
                --num_dimensions;
                --count;
            }
            if (node.getCountReps() > 0) {
                Integer countVal = 0;
                if (node.getNodeType() == 4 && ((PcmlData)node).getXPCMLCount(dim) != 0) {
                    countVal = ((PcmlData)node).getXPCMLCount(dim);
                }
                if (node.getNodeType() == 3 && ((PcmlStruct)node).getXPCMLCount(dim) != 0) {
                    countVal = ((PcmlStruct)node).getXPCMLCount(dim);
                }
                if (node.getNodeType() != 4 && node.getNodeType() != 3) {
                    countVal = 0;
                }
                dimensions.set(current_dimension, countVal - node.getCountReps());
                this.copyValues(root, node, num_dimensions, current_dimension, dimensions, struct, structR, count);
            } else {
                node.setCountReps(-10);
            }
        } else if (node.getNodeType() == 4 && !node.getAttributeValue("type").equals("struct")) {
            block39: {
                String strVal = "";
                String tempVal = "";
                int[] indices = new int[]{node.getCountReps()};
                if (node.getQualifiedName().trim().equals("")) {
                    Object objVal = null;
                } else {
                    try {
                        Object objVal = null;
                        if (node.getUsage() == 3 || (objVal = ((PcmlData)node).getValue(dimensions)) != null || (((PcmlDocNode)node.getParent()).getNodeType() != 4 || !((PcmlDocNode)node.getParent()).getAttributeValue("type").equals("struct")) && ((PcmlDocNode)node.getParent()).getNodeType() != 3) break block39;
                        boolean augmented = false;
                        for (PcmlDocNode parent = (PcmlDocNode)node.getParent(); parent != null && parent.getNodeType() != 2 && !augmented; parent = (PcmlDocNode)parent.getParent()) {
                            if (parent.getNodeType() != 4 || !parent.getAttributeValue("type").equals("struct")) continue;
                            augmented = true;
                        }
                        if (!augmented) break block39;
                        String[] nodeName = new String[count + 1];
                        for (int i = 0; i <= count; ++i) {
                            nodeName[i] = "";
                        }
                        boolean found = false;
                        for (int i = 0; i <= count && !found; ++i) {
                            nodeName[i] = struct[i];
                            for (int j = i + 1; j <= count; ++j) {
                                nodeName[i] = nodeName[i] + "." + structR[j];
                            }
                            String fullName = node.getQualifiedName();
                            String restOfName = fullName.substring(fullName.indexOf(structR[count]) + structR[count].length() + 1);
                            nodeName[i] = nodeName[i] + "." + restOfName;
                            String nodeToGet = nodeName[i];
                            PcmlDocRoot rootOfTree = root.getRootNode();
                            PcmlData nodeToCopy = null;
                            try {
                                nodeToCopy = (PcmlData)rootOfTree.getElement(nodeToGet);
                            }
                            catch (NullPointerException e) {
                                nodeToCopy = null;
                            }
                            if (nodeToCopy == null) continue;
                            int copyDim = nodeToCopy.getNbrOfDimensions();
                            int[] copy_dim = new int[copyDim];
                            for (int j = 0; j < copyDim; ++j) {
                                copy_dim[j] = dimensions.at(((PcmlData)node).getNbrOfDimensions() - copyDim + j);
                            }
                            PcmlDimensions copy_dimensions = new PcmlDimensions(copy_dim);
                            objVal = nodeToCopy.getValue(copy_dimensions);
                            if (objVal == null) continue;
                            ((PcmlData)node).setValue(objVal, dimensions);
                            found = true;
                        }
                    }
                    catch (PcmlException e) {
                        Trace.log(7, "No value for node: " + node.getQualifiedName());
                    }
                    catch (IllegalArgumentException e) {
                        Trace.log(7, "Bad count value for node: " + node.getQualifiedName());
                    }
                }
            }
            if (node.getCountReps() > 0) {
                int countVal = node.getNodeType() == 4 && ((PcmlData)node).getXPCMLCount(dim) != 0 ? ((PcmlData)node).getXPCMLCount(dim) : (node.getNodeType() == 3 && ((PcmlStruct)node).getXPCMLCount(dim) != 0 ? ((PcmlStruct)node).getXPCMLCount(dim) : 0);
                dimensions.set(current_dimension, countVal - node.getCountReps());
                this.copyValues(root, node, num_dimensions, current_dimension, dimensions, struct, structR, count);
            } else {
                node.setCountReps(-10);
            }
        }
    }

    public TimeZone getTimeZone() {
        return AS400.getDefaultTimeZone(this.getAs400());
    }

    private static boolean compareCharArrays(char[] array1, int offset1, char[] array2, int offset2, int length) {
        if (array1.length - offset1 < length || array2.length - offset2 < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (array1[offset1 + i] == array2[offset2 + i]) continue;
            return false;
        }
        return true;
    }

    public static String escapeSpecialCharaceters(String input) {
        StringBuffer output = new StringBuffer();
        if (null == input || input.length() == 0) {
            return input;
        }
        char[] data = input.toCharArray();
        block7: for (int i = 0; i < data.length; ++i) {
            switch (data[i]) {
                case '<': {
                    output.append("&lt;");
                    continue block7;
                }
                case '>': {
                    output.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    output.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    output.append("&quot;");
                    continue block7;
                }
                case '&': {
                    if (PcmlDocument.compareCharArrays(data, i, SPECIAL_AMP, 0, SPECIAL_AMP.length)) {
                        output.append("&amp;");
                        i += SPECIAL_AMP.length - 1;
                        continue block7;
                    }
                    if (PcmlDocument.compareCharArrays(data, i, SPECIAL_LT, 0, SPECIAL_LT.length)) {
                        output.append("&lt;");
                        i += SPECIAL_GT.length - 1;
                        continue block7;
                    }
                    if (PcmlDocument.compareCharArrays(data, i, SPECIAL_GT, 0, SPECIAL_GT.length)) {
                        output.append("&gt;");
                        i += SPECIAL_GT.length - 1;
                        continue block7;
                    }
                    if (PcmlDocument.compareCharArrays(data, i, SPECIAL_APOS, 0, SPECIAL_APOS.length)) {
                        output.append("&apos;");
                        i += SPECIAL_APOS.length - 1;
                        continue block7;
                    }
                    if (PcmlDocument.compareCharArrays(data, i, SPECIAL_QUOT, 0, SPECIAL_QUOT.length)) {
                        output.append("&quot;");
                        i += SPECIAL_GT.length - 1;
                        continue block7;
                    }
                    output.append("&amp;");
                    continue block7;
                }
                default: {
                    output.append(data[i]);
                }
            }
        }
        return output.toString();
    }
}

