/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPAttributeIDList;
import com.ibm.as400.access.NPCPID;
import com.ibm.as400.access.NPCPIDWriter;
import com.ibm.as400.access.NPCPSelWrtJ;
import com.ibm.as400.access.NPDataStream;
import com.ibm.as400.access.NPSystem;
import com.ibm.as400.access.OutputQueueImpl;
import com.ibm.as400.access.OutputQueueImplRemote;
import com.ibm.as400.access.PrintObjectImpl;
import com.ibm.as400.access.PrintObjectImplRemote;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.PrinterImplRemote;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.WriterJobImpl;
import java.io.IOException;

class WriterJobImplRemote
extends PrintObjectImplRemote
implements WriterJobImpl {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final NPCPAttributeIDList attrsToRetrieve_ = new NPCPAttributeIDList();
    private static boolean fAttrIDsToRtvBuilt_ = false;

    WriterJobImplRemote() {
    }

    private synchronized void buildAttrIDsToRtv() {
        if (!fAttrIDsToRtvBuilt_) {
            attrsToRetrieve_.addAttrID(121);
            attrsToRetrieve_.addAttrID(122);
            attrsToRetrieve_.addAttrID(123);
            attrsToRetrieve_.addAttrID(124);
            fAttrIDsToRtvBuilt_ = true;
        }
    }

    @Override
    public void end(String endType) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        NPDataStream sendDS = new NPDataStream(2);
        NPDataStream returnDS = new NPDataStream(2);
        NPSystem npSystem = NPSystem.getSystem(this.getSystem());
        NPCPAttribute cpCPFMessage = new NPCPAttribute();
        sendDS.setAction(9);
        sendDS.addCodePoint(this.getIDCodePoint());
        if (endType != null) {
            NPCPAttribute cpAttr = new NPCPAttribute();
            cpAttr.setAttrValue(144, endType);
            sendDS.addCodePoint(cpAttr);
        }
        returnDS.addCodePoint(cpCPFMessage);
        npSystem.makeRequest(sendDS, returnDS);
    }

    @Override
    NPCPAttributeIDList getAttrIDsToRetrieve() {
        if (!fAttrIDsToRtvBuilt_) {
            this.buildAttrIDsToRtv();
        }
        return attrsToRetrieve_;
    }

    @Override
    NPCPAttributeIDList getAttrIDsToRetrieve(int attrToRtv) {
        if (!fAttrIDsToRtvBuilt_) {
            attrsToRetrieve_.addAttrID(attrToRtv);
        }
        return attrsToRetrieve_;
    }

    public String getName() {
        NPCPID IDCodePoint = this.getIDCodePoint();
        if (IDCodePoint == null) {
            return "";
        }
        return IDCodePoint.getStringValue(121);
    }

    @Override
    public NPCPIDWriter start(AS400Impl system, PrintObjectImpl printer, PrintParameterList options, OutputQueueImpl outputQueue) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        NPDataStream sendDS = new NPDataStream(2);
        NPDataStream returnDS = new NPDataStream(2);
        NPCPAttribute cpCPFMessage = new NPCPAttribute();
        NPCPIDWriter cpWriterID = new NPCPIDWriter();
        NPSystem npSystem = NPSystem.getSystem((AS400ImplRemote)system);
        sendDS.setAction(8);
        sendDS.addCodePoint(((PrinterImplRemote)printer).getIDCodePoint());
        if (outputQueue != null) {
            sendDS.addCodePoint(((OutputQueueImplRemote)outputQueue).getIDCodePoint());
        }
        if (options != null) {
            sendDS.addCodePoint(options.getAttrCodePoint());
        }
        returnDS.addCodePoint(cpCPFMessage);
        returnDS.addCodePoint(cpWriterID);
        int rc = npSystem.makeRequest(sendDS, returnDS);
        if (rc != 0) {
            Trace.log(2, "Bad RC starting writer from server.  RC = " + rc);
            throw new ErrorCompletingRequestException(1, " Network Print Server RC = " + rc);
        }
        return cpWriterID;
    }

    @Override
    void updateAttrs(NPCPAttributeIDList attrIDs) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        NPDataStream req = new NPDataStream(2);
        NPDataStream reply = new NPDataStream(2);
        NPSystem npSystem = NPSystem.getSystem(this.getSystem());
        NPCPSelWrtJ writerSelection = new NPCPSelWrtJ();
        String strWriter = this.getName();
        writerSelection.setWriter(strWriter);
        NPCPAttribute cpAttrs = new NPCPAttribute();
        NPCPIDWriter cpWriterID = new NPCPIDWriter();
        req.setAction(22);
        req.addCodePoint(writerSelection);
        req.addCodePoint(attrIDs);
        reply.addCodePoint(cpAttrs);
        reply.addCodePoint(cpWriterID);
        int rc = npSystem.makeRequest(req, reply);
        switch (rc) {
            case 0: {
                if (this.attrs != null) {
                    this.attrs.addUpdateAttributes(cpAttrs);
                    break;
                }
                this.attrs = cpAttrs;
                break;
            }
            case 20: {
                Trace.log(2, "Writer Job " + strWriter + " not active");
                throw new ErrorCompletingRequestException(13, strWriter);
            }
            default: {
                Trace.log(2, "NetPrint DataStream RC = " + rc);
                throw new ErrorCompletingRequestException(1);
            }
        }
    }
}

