/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.files.ContentSyncSettingArg;
import com.dropbox.core.v2.files.SyncSettingArg;
import com.dropbox.core.v2.team.TeamFolderIdArg;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class TeamFolderUpdateSyncSettingsArg
extends TeamFolderIdArg {
    @Nullable
    protected final SyncSettingArg syncSetting;
    @Nullable
    protected final List<ContentSyncSettingArg> contentSyncSettings;

    public TeamFolderUpdateSyncSettingsArg(@Nonnull String teamFolderId, @Nullable SyncSettingArg syncSetting, @Nullable List<ContentSyncSettingArg> contentSyncSettings) {
        super(teamFolderId);
        this.syncSetting = syncSetting;
        if (contentSyncSettings != null) {
            for (ContentSyncSettingArg x : contentSyncSettings) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'contentSyncSettings' is null");
            }
        }
        this.contentSyncSettings = contentSyncSettings;
    }

    public TeamFolderUpdateSyncSettingsArg(@Nonnull String teamFolderId) {
        this(teamFolderId, null, null);
    }

    @Override
    @Nonnull
    public String getTeamFolderId() {
        return this.teamFolderId;
    }

    @Nullable
    public SyncSettingArg getSyncSetting() {
        return this.syncSetting;
    }

    @Nullable
    public List<ContentSyncSettingArg> getContentSyncSettings() {
        return this.contentSyncSettings;
    }

    public static Builder newBuilder(String teamFolderId) {
        return new Builder(teamFolderId);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.syncSetting, this.contentSyncSettings});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            TeamFolderUpdateSyncSettingsArg other = (TeamFolderUpdateSyncSettingsArg)obj;
            return (this.teamFolderId == other.teamFolderId || this.teamFolderId.equals(other.teamFolderId)) && (this.syncSetting == other.syncSetting || this.syncSetting != null && this.syncSetting.equals((Object)other.syncSetting)) && (this.contentSyncSettings == other.contentSyncSettings || this.contentSyncSettings != null && this.contentSyncSettings.equals(other.contentSyncSettings));
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<TeamFolderUpdateSyncSettingsArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(TeamFolderUpdateSyncSettingsArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("team_folder_id");
            StoneSerializers.string().serialize(value.teamFolderId, g);
            if (value.syncSetting != null) {
                g.writeFieldName("sync_setting");
                StoneSerializers.nullable(SyncSettingArg.Serializer.INSTANCE).serialize(value.syncSetting, g);
            }
            if (value.contentSyncSettings != null) {
                g.writeFieldName("content_sync_settings");
                StoneSerializers.nullable(StoneSerializers.list(ContentSyncSettingArg.Serializer.INSTANCE)).serialize(value.contentSyncSettings, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public TeamFolderUpdateSyncSettingsArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            List<ContentSyncSettingArg> f_contentSyncSettings;
            SyncSettingArg f_syncSetting;
            String f_teamFolderId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_teamFolderId = null;
                f_syncSetting = null;
                f_contentSyncSettings = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("team_folder_id".equals(field)) {
                        f_teamFolderId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("sync_setting".equals(field)) {
                        f_syncSetting = StoneSerializers.nullable(SyncSettingArg.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("content_sync_settings".equals(field)) {
                        f_contentSyncSettings = StoneSerializers.nullable(StoneSerializers.list(ContentSyncSettingArg.Serializer.INSTANCE)).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_teamFolderId == null) {
                    throw new JsonParseException(p, "Required field \"team_folder_id\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            TeamFolderUpdateSyncSettingsArg value = new TeamFolderUpdateSyncSettingsArg(f_teamFolderId, f_syncSetting, f_contentSyncSettings);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final String teamFolderId;
        protected SyncSettingArg syncSetting;
        protected List<ContentSyncSettingArg> contentSyncSettings;

        protected Builder(String teamFolderId) {
            if (teamFolderId == null) {
                throw new IllegalArgumentException("Required value for 'teamFolderId' is null");
            }
            if (!Pattern.matches("[-_0-9a-zA-Z:]+", teamFolderId)) {
                throw new IllegalArgumentException("String 'teamFolderId' does not match pattern");
            }
            this.teamFolderId = teamFolderId;
            this.syncSetting = null;
            this.contentSyncSettings = null;
        }

        public Builder withSyncSetting(SyncSettingArg syncSetting) {
            this.syncSetting = syncSetting;
            return this;
        }

        public Builder withContentSyncSettings(List<ContentSyncSettingArg> contentSyncSettings) {
            if (contentSyncSettings != null) {
                for (ContentSyncSettingArg x : contentSyncSettings) {
                    if (x != null) continue;
                    throw new IllegalArgumentException("An item in list 'contentSyncSettings' is null");
                }
            }
            this.contentSyncSettings = contentSyncSettings;
            return this;
        }

        public TeamFolderUpdateSyncSettingsArg build() {
            return new TeamFolderUpdateSyncSettingsArg(this.teamFolderId, this.syncSetting, this.contentSyncSettings);
        }
    }
}

