/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.WrappingProxy;

@Internal
public class FSDataOutputStreamWrapper
extends FSDataOutputStream
implements WrappingProxy<FSDataOutputStream> {
    protected final FSDataOutputStream outputStream;

    public FSDataOutputStreamWrapper(FSDataOutputStream outputStream) {
        this.outputStream = Preconditions.checkNotNull(outputStream);
    }

    @Override
    public long getPos() throws IOException {
        return this.outputStream.getPos();
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void sync() throws IOException {
        this.outputStream.sync();
    }

    @Override
    public void write(int b) throws IOException {
        this.outputStream.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.outputStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.outputStream.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }

    @Override
    public FSDataOutputStream getWrappedDelegate() {
        return this.outputStream;
    }
}

