/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import java.time.LocalDate;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

@Internal
public final class LocalDateSerializer
extends TypeSerializerSingleton<LocalDate> {
    private static final long serialVersionUID = 1L;
    public static final LocalDateSerializer INSTANCE = new LocalDateSerializer();
    private static final LocalDate EPOCH = LocalDate.ofEpochDay(0L);

    @Override
    public boolean isImmutableType() {
        return true;
    }

    @Override
    public LocalDate createInstance() {
        return EPOCH;
    }

    @Override
    public LocalDate copy(LocalDate from) {
        return from;
    }

    @Override
    public LocalDate copy(LocalDate from, LocalDate reuse) {
        return from;
    }

    @Override
    public int getLength() {
        return 6;
    }

    @Override
    public void serialize(LocalDate record, DataOutputView target) throws IOException {
        if (record == null) {
            target.writeInt(Integer.MIN_VALUE);
            target.writeShort(Short.MIN_VALUE);
        } else {
            target.writeInt(record.getYear());
            target.writeByte(record.getMonthValue());
            target.writeByte(record.getDayOfMonth());
        }
    }

    @Override
    public LocalDate deserialize(DataInputView source) throws IOException {
        int year = source.readInt();
        if (year == Integer.MIN_VALUE) {
            source.readShort();
            return null;
        }
        return LocalDate.of(year, source.readByte(), (int)source.readByte());
    }

    @Override
    public LocalDate deserialize(LocalDate reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.writeInt(source.readInt());
        target.writeShort(source.readShort());
    }

    @Override
    public TypeSerializerSnapshot<LocalDate> snapshotConfiguration() {
        return new LocalDateSerializerSnapshot();
    }

    public static final class LocalDateSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<LocalDate> {
        public LocalDateSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

