/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.PathUtils;
import org.apache.cassandra.io.util.RebufferingInputStream;

public class FileInputStreamPlus
extends RebufferingInputStream {
    final FileChannel channel;

    public FileInputStreamPlus(String file) throws NoSuchFileException {
        this(new File(file));
    }

    public FileInputStreamPlus(File file) throws NoSuchFileException {
        this(file.newReadChannel());
    }

    public FileInputStreamPlus(Path path) throws NoSuchFileException {
        this(PathUtils.newReadChannel(path));
    }

    public FileInputStreamPlus(Path path, int bufferSize) throws NoSuchFileException {
        this(PathUtils.newReadChannel(path), bufferSize);
    }

    private FileInputStreamPlus(FileChannel channel) {
        this(channel, 16384);
    }

    private FileInputStreamPlus(FileChannel channel, int bufferSize) {
        super(ByteBuffer.allocateDirect(bufferSize));
        this.channel = channel;
        this.buffer.limit(0);
    }

    @Override
    protected void reBuffer() throws IOException {
        this.buffer.clear();
        this.channel.read(this.buffer);
        this.buffer.flip();
    }

    public FileChannel getChannel() {
        return this.channel;
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            try {
                FileUtils.clean(this.buffer);
            }
            finally {
                this.channel.close();
            }
        }
    }
}

