/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.Clustering;
import com.google.cloud.bigquery.CsvOptions;
import com.google.cloud.bigquery.DatastoreBackupOptions;
import com.google.cloud.bigquery.EncryptionConfiguration;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TimePartitioning;
import java.util.List;

public interface LoadConfiguration {
    public TableId getDestinationTable();

    public EncryptionConfiguration getDestinationEncryptionConfiguration();

    public JobInfo.CreateDisposition getCreateDisposition();

    public JobInfo.WriteDisposition getWriteDisposition();

    public String getNullMarker();

    public CsvOptions getCsvOptions();

    public Integer getMaxBadRecords();

    public Schema getSchema();

    public String getFormat();

    public Boolean ignoreUnknownValues();

    public DatastoreBackupOptions getDatastoreBackupOptions();

    public List<JobInfo.SchemaUpdateOption> getSchemaUpdateOptions();

    public Boolean getAutodetect();

    public TimePartitioning getTimePartitioning();

    public Clustering getClustering();

    public Boolean getUseAvroLogicalTypes();

    public List<String> getDecimalTargetTypes();

    public Builder toBuilder();

    public static interface Builder {
        public Builder setDestinationTable(TableId var1);

        public Builder setDestinationEncryptionConfiguration(EncryptionConfiguration var1);

        public Builder setCreateDisposition(JobInfo.CreateDisposition var1);

        public Builder setWriteDisposition(JobInfo.WriteDisposition var1);

        public Builder setFormatOptions(FormatOptions var1);

        public Builder setNullMarker(String var1);

        public Builder setMaxBadRecords(Integer var1);

        public Builder setSchema(Schema var1);

        public Builder setIgnoreUnknownValues(Boolean var1);

        public Builder setSchemaUpdateOptions(List<JobInfo.SchemaUpdateOption> var1);

        public Builder setAutodetect(Boolean var1);

        public Builder setTimePartitioning(TimePartitioning var1);

        public Builder setClustering(Clustering var1);

        public Builder setUseAvroLogicalTypes(Boolean var1);

        public Builder setDecimalTargetTypes(List<String> var1);

        public LoadConfiguration build();
    }
}

