/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.encryption;

import org.apache.hop.core.Const;
import org.apache.hop.core.HopClientEnvironment;
import org.apache.hop.core.encryption.ITwoWayPasswordEncoder;
import org.apache.hop.core.encryption.TwoWayPasswordEncoderPluginType;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.util.Utils;
import org.eclipse.jetty.util.security.Password;

public class Encr {
    private static ITwoWayPasswordEncoder encoder;
    public static final String PASSWORD_ENCRYPTED_PREFIX = "Encrypted ";

    public static void init(String encoderPluginId) throws HopException {
        if (Utils.isEmpty(encoderPluginId)) {
            throw new HopException("Unable to initialize the two way password encoder: No encoder plugin type specified.");
        }
        PluginRegistry registry = PluginRegistry.getInstance();
        IPlugin plugin = registry.findPluginWithId(TwoWayPasswordEncoderPluginType.class, encoderPluginId);
        if (plugin == null) {
            throw new HopException("Unable to find plugin with ID '" + encoderPluginId + "'");
        }
        encoder = (ITwoWayPasswordEncoder)registry.loadClass(plugin);
        encoder.init();
    }

    public static final String encryptPassword(String password) {
        return encoder.encode(password, false);
    }

    public static final String decryptPassword(String encrypted) {
        return encoder.decode(encrypted);
    }

    public static final String encryptPasswordIfNotUsingVariables(String password) {
        return encoder.encode(password, true);
    }

    public static final String decryptPasswordOptionallyEncrypted(String password) {
        return encoder.decode(password, true);
    }

    public static ITwoWayPasswordEncoder getEncoder() {
        return encoder;
    }

    public static void main(String[] args) throws HopException {
        HopClientEnvironment.init();
        if (args.length != 2) {
            Encr.printOptions();
            System.exit(9);
        }
        String option = args[0];
        String password = args[1];
        if (Const.trim(option).substring(1).equalsIgnoreCase("hop")) {
            try {
                String obfuscated = Encr.encryptPasswordIfNotUsingVariables(password);
                System.out.println(obfuscated);
                System.exit(0);
            }
            catch (Exception ex) {
                System.err.println("Error encrypting password");
                ex.printStackTrace();
                System.exit(2);
            }
        } else if (Const.trim(option).substring(1).equalsIgnoreCase("server")) {
            String obfuscated = Password.obfuscate((String)password);
            System.out.println(obfuscated);
            System.exit(0);
        } else {
            System.err.println("Unknown option '" + option + "'\n");
            Encr.printOptions();
            System.exit(1);
        }
    }

    private static void printOptions() {
        System.err.println("encr usage:\n");
        System.err.println("  encr <-hop|-server> <password>");
        System.err.println("  Options:");
        System.err.println("    -hop: generate an obfuscated password to include in Hop XML files");
        System.err.println("    -server : generate an obfuscated password to include in the hop-server password file 'pwd/hop.pwd'");
        System.err.println("\nThis command line tool obfuscates a plain text password for use in XML and password files.");
        System.err.println("Make sure to also copy the 'Encrypted ' prefix to indicate the obfuscated nature of the password.");
        System.err.println("Hop will then be able to make the distinction between regular plain text passwords and obfuscated ones.");
        System.err.println();
    }
}

