/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.core.common.BetaConstraints;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.TupleSets;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.JoinNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.rule.ContextEntry;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.FastIterator;

public class PhreakJoinNode {
    public void doNode(JoinNode joinNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, TupleSets<LeftTuple> srcLeftTuples, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples) {
        TupleSets<RightTuple> srcRightTuples = bm.getStagedRightTuples().takeAll();
        if (srcRightTuples.getDeleteFirst() != null) {
            this.doRightDeletes(bm, srcRightTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcLeftTuples.getDeleteFirst() != null) {
            this.doLeftDeletes(bm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcRightTuples.getUpdateFirst() != null) {
            RuleNetworkEvaluator.doUpdatesReorderRightMemory(bm, srcRightTuples);
        }
        if (srcLeftTuples.getUpdateFirst() != null) {
            RuleNetworkEvaluator.doUpdatesReorderLeftMemory(bm, srcLeftTuples);
        }
        if (srcRightTuples.getUpdateFirst() != null) {
            this.doRightUpdates(joinNode, sink, bm, wm, srcRightTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcLeftTuples.getUpdateFirst() != null) {
            this.doLeftUpdates(joinNode, sink, bm, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcRightTuples.getInsertFirst() != null) {
            this.doRightInserts(joinNode, sink, bm, wm, srcRightTuples, trgLeftTuples);
        }
        if (srcLeftTuples.getInsertFirst() != null) {
            this.doLeftInserts(joinNode, sink, bm, wm, srcLeftTuples, trgLeftTuples);
        }
        srcRightTuples.resetAll();
        srcLeftTuples.resetAll();
    }

    public void doLeftInserts(JoinNode joinNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, TupleSets<LeftTuple> srcLeftTuples, TupleSets<LeftTuple> trgLeftTuples) {
        TupleMemory ltm = bm.getLeftTupleMemory();
        TupleMemory rtm = bm.getRightTupleMemory();
        ContextEntry[] contextEntry = bm.getContext();
        BetaConstraints constraints = joinNode.getRawConstraints();
        LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
        while (leftTuple != null) {
            LeftTuple next = (LeftTuple)leftTuple.getStagedNext();
            boolean useLeftMemory = RuleNetworkEvaluator.useLeftMemory(joinNode, leftTuple);
            if (useLeftMemory) {
                ltm.add(leftTuple);
            }
            FastIterator it = joinNode.getRightIterator(rtm);
            constraints.updateFromTuple(contextEntry, wm, leftTuple);
            RightTuple rightTuple = joinNode.getFirstRightTuple(leftTuple, rtm, null, it);
            while (rightTuple != null) {
                if (constraints.isAllowedCachedLeft(contextEntry, rightTuple.getFactHandle())) {
                    PhreakJoinNode.insertChildLeftTuple(trgLeftTuples, leftTuple, rightTuple, null, null, sink, useLeftMemory);
                }
                rightTuple = (RightTuple)it.next(rightTuple);
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
        constraints.resetTuple(contextEntry);
    }

    public void doRightInserts(JoinNode joinNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, TupleSets<RightTuple> srcRightTuples, TupleSets<LeftTuple> trgLeftTuples) {
        TupleMemory ltm = bm.getLeftTupleMemory();
        TupleMemory rtm = bm.getRightTupleMemory();
        ContextEntry[] contextEntry = bm.getContext();
        BetaConstraints constraints = joinNode.getRawConstraints();
        if (srcRightTuples.getInsertSize() > 32 && rtm instanceof AbstractHashTable) {
            ((AbstractHashTable)((Object)rtm)).ensureCapacity(srcRightTuples.getInsertSize());
        }
        RightTuple rightTuple = srcRightTuples.getInsertFirst();
        while (rightTuple != null) {
            RightTuple next = (RightTuple)rightTuple.getStagedNext();
            rtm.add(rightTuple);
            if (ltm != null && ltm.size() > 0) {
                FastIterator it = joinNode.getLeftIterator(ltm);
                constraints.updateFromFactHandle(contextEntry, wm, rightTuple.getFactHandleForEvaluation());
                LeftTuple leftTuple = joinNode.getFirstLeftTuple(rightTuple, ltm, it);
                while (leftTuple != null) {
                    if (leftTuple.getStagedType() != 2 && constraints.isAllowedCachedRight(contextEntry, leftTuple)) {
                        PhreakJoinNode.insertChildLeftTuple(trgLeftTuples, leftTuple, rightTuple, null, null, sink, true);
                    }
                    leftTuple = (LeftTuple)it.next(leftTuple);
                }
            }
            rightTuple.clearStaged();
            rightTuple = next;
        }
        constraints.resetFactHandle(contextEntry);
    }

    public void doLeftUpdates(JoinNode joinNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, TupleSets<LeftTuple> srcLeftTuples, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples) {
        TupleMemory rtm = bm.getRightTupleMemory();
        ContextEntry[] contextEntry = bm.getContext();
        BetaConstraints constraints = joinNode.getRawConstraints();
        LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            LeftTuple next = (LeftTuple)leftTuple.getStagedNext();
            constraints.updateFromTuple(contextEntry, wm, leftTuple);
            FastIterator it = joinNode.getRightIterator(rtm);
            RightTuple rightTuple = joinNode.getFirstRightTuple(leftTuple, rtm, null, it);
            if (rtm.isIndexed() && !it.isFullIterator()) {
                LeftTuple childLeftTuple = leftTuple.getFirstChild();
                while (childLeftTuple != null) {
                    LeftTuple nextChild = (LeftTuple)childLeftTuple.getHandleNext();
                    if (rightTuple == null || rightTuple.getMemory() != childLeftTuple.getRightParent().getMemory()) {
                        RuleNetworkEvaluator.unlinkAndDeleteChildLeftTuple(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                    }
                    childLeftTuple = nextChild;
                }
            }
            if (rightTuple != null) {
                this.doLeftUpdatesProcessChildren(leftTuple.getFirstChild(), leftTuple, rightTuple, stagedLeftTuples, contextEntry, constraints, sink, it, trgLeftTuples);
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
        constraints.resetTuple(contextEntry);
    }

    public LeftTuple doLeftUpdatesProcessChildren(LeftTuple childLeftTuple, LeftTuple leftTuple, RightTuple rightTuple, TupleSets<LeftTuple> stagedLeftTuples, ContextEntry[] contextEntry, BetaConstraints constraints, LeftTupleSink sink, FastIterator it, TupleSets<LeftTuple> trgLeftTuples) {
        if (childLeftTuple == null) {
            while (rightTuple != null) {
                if (constraints.isAllowedCachedLeft(contextEntry, rightTuple.getFactHandle())) {
                    PhreakJoinNode.insertChildLeftTuple(trgLeftTuples, leftTuple, rightTuple, null, null, sink, true);
                }
                rightTuple = (RightTuple)it.next(rightTuple);
            }
        } else {
            while (rightTuple != null) {
                if (constraints.isAllowedCachedLeft(contextEntry, rightTuple.getFactHandle())) {
                    if (childLeftTuple == null || childLeftTuple.getRightParent() != rightTuple) {
                        PhreakJoinNode.insertChildLeftTuple(trgLeftTuples, leftTuple, rightTuple, childLeftTuple, null, sink, true);
                    } else {
                        childLeftTuple.setPropagationContext(rightTuple.getPropagationContext());
                        PhreakJoinNode.updateChildLeftTuple(childLeftTuple, stagedLeftTuples, trgLeftTuples);
                        LeftTuple nextChildLeftTuple = (LeftTuple)childLeftTuple.getHandleNext();
                        childLeftTuple.reAddRight();
                        childLeftTuple = nextChildLeftTuple;
                    }
                } else if (childLeftTuple != null && childLeftTuple.getRightParent() == rightTuple) {
                    LeftTuple nextChild = (LeftTuple)childLeftTuple.getHandleNext();
                    RuleNetworkEvaluator.unlinkAndDeleteChildLeftTuple(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                    childLeftTuple = nextChild;
                }
                rightTuple = (RightTuple)it.next(rightTuple);
            }
        }
        return childLeftTuple;
    }

    public void doRightUpdates(JoinNode joinNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, TupleSets<RightTuple> srcRightTuples, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples) {
        TupleMemory ltm = bm.getLeftTupleMemory();
        ContextEntry[] contextEntry = bm.getContext();
        BetaConstraints constraints = joinNode.getRawConstraints();
        RightTuple rightTuple = srcRightTuples.getUpdateFirst();
        while (rightTuple != null) {
            RightTuple next = (RightTuple)rightTuple.getStagedNext();
            if (ltm != null && ltm.size() > 0) {
                FastIterator it = joinNode.getLeftIterator(ltm);
                LeftTuple leftTuple = joinNode.getFirstLeftTuple(rightTuple, ltm, it);
                constraints.updateFromFactHandle(contextEntry, wm, rightTuple.getFactHandleForEvaluation());
                LeftTuple childLeftTuple = rightTuple.getFirstChild();
                if (childLeftTuple != null && ltm.isIndexed() && !it.isFullIterator() && (leftTuple == null || leftTuple.getMemory() != childLeftTuple.getLeftParent().getMemory())) {
                    while (childLeftTuple != null) {
                        childLeftTuple.setPropagationContext(rightTuple.getPropagationContext());
                        LeftTuple nextChild = childLeftTuple.getRightParentNext();
                        RuleNetworkEvaluator.unlinkAndDeleteChildLeftTuple(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                        childLeftTuple = nextChild;
                    }
                }
                if (leftTuple != null) {
                    this.doRightUpdatesProcessChildren(childLeftTuple, leftTuple, rightTuple, stagedLeftTuples, contextEntry, constraints, sink, it, trgLeftTuples);
                }
            }
            rightTuple.clearStaged();
            rightTuple = next;
        }
        constraints.resetFactHandle(contextEntry);
    }

    public LeftTuple doRightUpdatesProcessChildren(LeftTuple childLeftTuple, LeftTuple leftTuple, RightTuple rightTuple, TupleSets<LeftTuple> stagedLeftTuples, ContextEntry[] contextEntry, BetaConstraints constraints, LeftTupleSink sink, FastIterator it, TupleSets<LeftTuple> trgLeftTuples) {
        if (childLeftTuple == null) {
            while (leftTuple != null) {
                if (leftTuple.getStagedType() != 2 && constraints.isAllowedCachedRight(contextEntry, leftTuple)) {
                    PhreakJoinNode.insertChildLeftTuple(trgLeftTuples, leftTuple, rightTuple, null, null, sink, true);
                }
                leftTuple = (LeftTuple)it.next(leftTuple);
            }
        } else {
            while (leftTuple != null) {
                if (leftTuple.getStagedType() != 2) {
                    if (constraints.isAllowedCachedRight(contextEntry, leftTuple)) {
                        if (childLeftTuple == null || childLeftTuple.getLeftParent() != leftTuple) {
                            PhreakJoinNode.insertChildLeftTuple(trgLeftTuples, leftTuple, rightTuple, null, childLeftTuple, sink, true);
                        } else {
                            childLeftTuple.setPropagationContext(rightTuple.getPropagationContext());
                            PhreakJoinNode.updateChildLeftTuple(childLeftTuple, stagedLeftTuples, trgLeftTuples);
                            LeftTuple nextChildLeftTuple = childLeftTuple.getRightParentNext();
                            childLeftTuple.reAddLeft();
                            childLeftTuple = nextChildLeftTuple;
                        }
                    } else if (childLeftTuple != null && childLeftTuple.getLeftParent() == leftTuple) {
                        childLeftTuple.setPropagationContext(rightTuple.getPropagationContext());
                        LeftTuple nextChild = childLeftTuple.getRightParentNext();
                        RuleNetworkEvaluator.unlinkAndDeleteChildLeftTuple(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                        childLeftTuple = nextChild;
                    }
                }
                leftTuple = (LeftTuple)it.next(leftTuple);
            }
        }
        return childLeftTuple;
    }

    public void doLeftDeletes(BetaMemory bm, TupleSets<LeftTuple> srcLeftTuples, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples) {
        TupleMemory ltm = bm.getLeftTupleMemory();
        LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
        while (leftTuple != null) {
            LeftTuple next = (LeftTuple)leftTuple.getStagedNext();
            if (leftTuple.getMemory() != null) {
                ltm.remove(leftTuple);
            }
            if (leftTuple.getFirstChild() != null) {
                LeftTuple childLeftTuple = leftTuple.getFirstChild();
                while (childLeftTuple != null) {
                    LeftTuple nextChild = (LeftTuple)childLeftTuple.getHandleNext();
                    RuleNetworkEvaluator.unlinkAndDeleteChildLeftTuple(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                    childLeftTuple = nextChild;
                }
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public void doRightDeletes(BetaMemory bm, TupleSets<RightTuple> srcRightTuples, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples) {
        TupleMemory rtm = bm.getRightTupleMemory();
        RightTuple rightTuple = srcRightTuples.getDeleteFirst();
        while (rightTuple != null) {
            RightTuple next = (RightTuple)rightTuple.getStagedNext();
            if (rightTuple.getMemory() != null) {
                rtm.remove(rightTuple);
            }
            if (rightTuple.getFirstChild() != null) {
                LeftTuple childLeftTuple = rightTuple.getFirstChild();
                childLeftTuple.setPropagationContext(rightTuple.getPropagationContext());
                while (childLeftTuple != null) {
                    LeftTuple nextChild = childLeftTuple.getRightParentNext();
                    RuleNetworkEvaluator.unlinkAndDeleteChildLeftTuple(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                    childLeftTuple = nextChild;
                }
            }
            rightTuple.clearStaged();
            rightTuple = next;
        }
    }

    public static void updateChildLeftTuple(LeftTuple childLeftTuple, TupleSets<LeftTuple> stagedLeftTuples, TupleSets<LeftTuple> trgLeftTuples) {
        if (!childLeftTuple.isStagedOnRight()) {
            switch (childLeftTuple.getStagedType()) {
                case 1: {
                    stagedLeftTuples.removeInsert(childLeftTuple);
                    trgLeftTuples.addInsert(childLeftTuple);
                    break;
                }
                case 2: {
                    stagedLeftTuples.removeUpdate(childLeftTuple);
                    trgLeftTuples.addUpdate(childLeftTuple);
                    break;
                }
                default: {
                    trgLeftTuples.addUpdate(childLeftTuple);
                }
            }
        }
    }

    private static void insertChildLeftTuple(TupleSets<LeftTuple> trgLeftTuples, LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        if (!leftTuple.isExpired() && !rightTuple.isExpired()) {
            trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled));
        }
    }
}

