/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.plan.MergeTaskProperties;
import org.apache.hadoop.mapred.JobContext;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.mr.hive.HiveIcebergOutputCommitter;

public class IcebergMergeTaskProperties
implements MergeTaskProperties {
    private final Properties properties;

    IcebergMergeTaskProperties(Properties properties) {
        this.properties = properties;
    }

    public Path getTmpLocation() {
        String location = this.properties.getProperty("location");
        return new Path(location + "/data/");
    }

    public Properties getSplitProperties() throws IOException {
        List<JobContext> jobContextList = HiveIcebergOutputCommitter.getJobContexts(this.properties);
        if (jobContextList.isEmpty()) {
            return null;
        }
        List<ContentFile<?>> contentFiles = HiveIcebergOutputCommitter.getOutputContentFiles(jobContextList);
        Properties pathToContentFile = new Properties();
        contentFiles.forEach(contentFile -> pathToContentFile.put(new Path(contentFile.location()), contentFile));
        return pathToContentFile;
    }
}

