/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.iceberg.org.apache.orc.impl.filter.leaf;

import java.util.Arrays;
import java.util.List;
import org.apache.hive.iceberg.org.apache.orc.impl.filter.LeafFilter;
import org.apache.hive.iceberg.org.apache.orc.storage.ql.exec.vector.ColumnVector;
import org.apache.hive.iceberg.org.apache.orc.storage.ql.exec.vector.LongColumnVector;

class LongFilters {
    private LongFilters() {
    }

    static class LongLessThanEquals
    extends LeafFilter {
        private final long aValue;

        LongLessThanEquals(String colName, Object aValue, boolean negated) {
            super(colName, negated);
            this.aValue = (Long)aValue;
        }

        @Override
        protected boolean allow(ColumnVector v, int rowIdx) {
            return ((LongColumnVector)v).vector[rowIdx] <= this.aValue;
        }
    }

    static class LongLessThan
    extends LeafFilter {
        private final long aValue;

        LongLessThan(String colName, Object aValue, boolean negated) {
            super(colName, negated);
            this.aValue = (Long)aValue;
        }

        @Override
        protected boolean allow(ColumnVector v, int rowIdx) {
            return ((LongColumnVector)v).vector[rowIdx] < this.aValue;
        }
    }

    static class LongIn
    extends LeafFilter {
        private final long[] inValues;

        LongIn(String colName, List<Object> values, boolean negated) {
            super(colName, negated);
            this.inValues = new long[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                this.inValues[i] = (Long)values.get(i);
            }
            Arrays.sort(this.inValues);
        }

        @Override
        protected boolean allow(ColumnVector v, int rowIdx) {
            return Arrays.binarySearch(this.inValues, ((LongColumnVector)v).vector[rowIdx]) >= 0;
        }
    }

    static class LongEquals
    extends LeafFilter {
        private final long aValue;

        LongEquals(String colName, Object aValue, boolean negated) {
            super(colName, negated);
            this.aValue = (Long)aValue;
        }

        @Override
        protected boolean allow(ColumnVector v, int rowIdx) {
            return ((LongColumnVector)v).vector[rowIdx] == this.aValue;
        }
    }

    static class LongBetween
    extends LeafFilter {
        private final long low;
        private final long high;

        LongBetween(String colName, Object low, Object high, boolean negated) {
            super(colName, negated);
            this.low = (Long)low;
            this.high = (Long)high;
        }

        @Override
        protected boolean allow(ColumnVector v, int rowIdx) {
            return ((LongColumnVector)v).vector[rowIdx] >= this.low && ((LongColumnVector)v).vector[rowIdx] <= this.high;
        }
    }
}

