/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDFArrayBase;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;

@Description(name="array_remove", value="_FUNC_(array, element) - Removes all occurrences of element from array.", extended="Example:\n  > SELECT _FUNC_(array(1, 2, 3,4,2), 2) FROM src;\n  [1,3,4]")
public class GenericUDFArrayRemove
extends AbstractGenericUDFArrayBase {
    private static final String FUNC_NAME = "ARRAY_REMOVE";
    private static final int VALUE_IDX = 1;

    public GenericUDFArrayRemove() {
        super(FUNC_NAME, 2, 2, ObjectInspector.Category.LIST);
    }

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        ObjectInspector valueOI;
        ObjectInspector defaultOI = super.initialize(arguments);
        ObjectInspector arrayElementOI = this.arrayOI.getListElementObjectInspector();
        if (!ObjectInspectorUtils.compareTypes((ObjectInspector)arrayElementOI, (ObjectInspector)(valueOI = arguments[1]))) {
            throw new UDFArgumentTypeException(1, String.format("%s type element is expected at function array_remove(array<%s>,%s), but %s is found", arrayElementOI.getTypeName(), arrayElementOI.getTypeName(), arrayElementOI.getTypeName(), valueOI.getTypeName()));
        }
        return defaultOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object array = arguments[0].get();
        Object value = arguments[1].get();
        if (this.arrayOI.getListLength(array) == 0) {
            return Collections.emptyList();
        }
        if (this.arrayOI.getListLength(array) < 0 || value == null) {
            return null;
        }
        ArrayList<Object> resultArray = new ArrayList<Object>(((ListObjectInspector)this.argumentOIs[0]).getList(array));
        resultArray.removeIf(value::equals);
        return resultArray.stream().map(o -> this.converter.convert(o)).collect(Collectors.toList());
    }
}

