/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedUDAFs;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFMinDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFMinDecimal64;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFMinDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFMinIntervalDayTime;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFMinLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFMinString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFMinTimestamp;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFMax;
import org.apache.hadoop.hive.serde2.objectinspector.FullMapEqualComparer;
import org.apache.hadoop.hive.serde2.objectinspector.MapEqualComparer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="min", value="_FUNC_(expr) - Returns the minimum value of expr")
public class GenericUDAFMin
extends AbstractGenericUDAFResolver {
    static final Logger LOG = LoggerFactory.getLogger((String)GenericUDAFMin.class.getName());

    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length != 1) {
            throw new UDFArgumentTypeException(parameters.length - 1, "Exactly one argument is expected.");
        }
        ObjectInspector oi = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)parameters[0]);
        if (!ObjectInspectorUtils.compareSupported((ObjectInspector)oi)) {
            throw new UDFArgumentTypeException(parameters.length - 1, "Cannot support comparison of map<> type or complex type containing map<>.");
        }
        return new GenericUDAFMinEvaluator();
    }

    @UDFType(distinctLike=true)
    @VectorizedUDAFs(value={VectorUDAFMinLong.class, VectorUDAFMinDouble.class, VectorUDAFMinDecimal.class, VectorUDAFMinDecimal64.class, VectorUDAFMinTimestamp.class, VectorUDAFMinIntervalDayTime.class, VectorUDAFMinString.class})
    public static class GenericUDAFMinEvaluator
    extends GenericUDAFEvaluator {
        private transient ObjectInspector inputOI;
        private transient ObjectInspector outputOI;
        boolean warned = false;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            assert (parameters.length == 1);
            super.init(m, parameters);
            this.inputOI = parameters[0];
            this.outputOI = ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.inputOI, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
            return this.outputOI;
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            MinAgg result = new MinAgg();
            return result;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            MinAgg myagg = (MinAgg)agg;
            myagg.o = null;
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            assert (parameters.length == 1);
            this.merge(agg, parameters[0]);
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            return this.terminate(agg);
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial != null) {
                MinAgg myagg = (MinAgg)agg;
                int r = ObjectInspectorUtils.compare((Object)myagg.o, (ObjectInspector)this.outputOI, (Object)partial, (ObjectInspector)this.inputOI, (MapEqualComparer)new FullMapEqualComparer(), (ObjectInspectorUtils.NullValueOption)ObjectInspectorUtils.NullValueOption.MAXVALUE);
                if (myagg.o == null || r > 0) {
                    myagg.o = ObjectInspectorUtils.copyToStandardObject((Object)partial, (ObjectInspector)this.inputOI, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
                }
            }
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            MinAgg myagg = (MinAgg)agg;
            return myagg.o;
        }

        @Override
        public GenericUDAFEvaluator getWindowingEvaluator(WindowFrameDef wFrmDef) {
            return new MinStreamingFixedWindow(this, wFrmDef);
        }

        @GenericUDAFEvaluator.AggregationType(estimable=true)
        static class MinAgg
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            Object o;

            MinAgg() {
            }

            @Override
            public int estimate() {
                return 8;
            }
        }
    }

    static class MinStreamingFixedWindow
    extends GenericUDAFMax.MaxStreamingFixedWindow {
        public MinStreamingFixedWindow(GenericUDAFEvaluator wrappedEval, WindowFrameDef wFrmDef) {
            super(wrappedEval, wFrmDef);
        }

        @Override
        protected ObjectInspector inputOI() {
            return ((GenericUDAFMinEvaluator)this.wrappedEval).inputOI;
        }

        @Override
        protected ObjectInspector outputOI() {
            return ((GenericUDAFMinEvaluator)this.wrappedEval).outputOI;
        }

        @Override
        protected boolean removeLast(Object in, Object last) {
            return this.isLess(in, last);
        }

        private boolean isLess(Object in, Object last) {
            if (in == null) {
                return false;
            }
            if (last == null) {
                return true;
            }
            return ObjectInspectorUtils.compare((Object)in, (ObjectInspector)this.inputOI(), (Object)last, (ObjectInspector)this.outputOI()) < 0;
        }
    }
}

