/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncLog10DoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncLog10LongToDouble;
import org.apache.hadoop.hive.ql.udf.UDFMath;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;

@Description(name="log10", value="_FUNC_(x) - Returns the logarithm of x with base 10", extended="Example:\n  > SELECT _FUNC_(10) FROM src LIMIT 1;\n  1")
@VectorizedExpressions(value={FuncLog10LongToDouble.class, FuncLog10DoubleToDouble.class})
public class UDFLog10
extends UDFMath {
    private final DoubleWritable result = new DoubleWritable();

    @Override
    protected DoubleWritable doEvaluate(DoubleWritable a) {
        if (a.get() <= 0.0) {
            return null;
        }
        this.result.set(StrictMath.log10(a.get()));
        return this.result;
    }
}

