/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor.handler;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnOpenException;
import org.apache.hadoop.hive.metastore.api.UnlockRequest;
import org.apache.hadoop.hive.metastore.metrics.Metrics;
import org.apache.hadoop.hive.metastore.metrics.PerfLogger;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.txn.compactor.CleanupRequest;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorUtil;
import org.apache.hadoop.hive.ql.txn.compactor.FSRemover;
import org.apache.hadoop.hive.ql.txn.compactor.MetadataCache;
import org.apache.hadoop.hive.ql.txn.compactor.handler.TaskHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CompactionCleaner
extends TaskHandler {
    private static final Logger LOG = LoggerFactory.getLogger((String)CompactionCleaner.class.getName());

    public CompactionCleaner(HiveConf conf, TxnStore txnHandler, MetadataCache metadataCache, boolean metricsEnabled, FSRemover fsRemover) {
        super(conf, txnHandler, metadataCache, metricsEnabled, fsRemover);
    }

    @Override
    public List<Runnable> getTasks(HiveConf conf) throws MetaException {
        long retentionTime;
        long minOpenTxnId = this.txnHandler.findMinOpenTxnIdForCleaner();
        List readyToClean = this.txnHandler.findReadyToClean(minOpenTxnId, retentionTime = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_DELAYED_CLEANUP_ENABLED) ? HiveConf.getTimeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_CLEANER_RETENTION_TIME, (TimeUnit)TimeUnit.MILLISECONDS) : 0L);
        if (!readyToClean.isEmpty()) {
            long minTxnIdSeenOpen = Math.min(minOpenTxnId, this.txnHandler.findMinTxnIdSeenOpen());
            return readyToClean.stream().map(ci -> CompactorUtil.ThrowingRunnable.unchecked(() -> this.clean((CompactionInfo)ci, minTxnIdSeenOpen, this.metricsEnabled))).toList();
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clean(CompactionInfo ci, long minOpenTxn, boolean metricsEnabled) throws MetaException {
        LOG.info("Starting cleaning for {}, based on min open {}", (Object)ci, (Object)(ci.minOpenWriteId > 0L ? "writeId: " + ci.minOpenWriteId : "txnId: " + minOpenTxn));
        PerfLogger perfLogger = PerfLogger.getPerfLogger((boolean)false);
        String cleanerMetric = "compaction_cleaner_cycle_" + (!Objects.isNull(ci.type) ? ci.type.toString().toLowerCase() : null);
        try {
            if (metricsEnabled) {
                perfLogger.perfLogBegin(CompactionCleaner.class.getName(), cleanerMetric);
            }
            String location = ci.getProperty("location");
            Table t = null;
            Partition p = null;
            if (Objects.isNull(location)) {
                t = this.resolveTable(ci);
                if (Objects.isNull(t)) {
                    LOG.info("Unable to find table {}, assuming it was dropped. {}", (Object)ci.getFullTableName(), (Object)CompactionCleaner.idWatermark(ci));
                    this.txnHandler.markCleaned(ci);
                    return;
                }
                if (MetaStoreUtils.isNoCleanUpSet((Map)t.getParameters())) {
                    LOG.info("Skipping table {} clean up, as NO_CLEANUP set to true", (Object)ci.getFullTableName());
                    this.txnHandler.markRefused(ci);
                    return;
                }
                if (!Objects.isNull(ci.partName)) {
                    p = this.resolvePartition(ci.dbname, ci.tableName, ci.partName);
                    if (Objects.isNull(p)) {
                        LOG.info("Unable to find partition {}, assuming it was dropped. {}", (Object)ci.getFullPartitionName(), (Object)CompactionCleaner.idWatermark(ci));
                        this.txnHandler.markCleaned(ci);
                        return;
                    }
                    if (MetaStoreUtils.isNoCleanUpSet((Map)p.getParameters())) {
                        LOG.info("Skipping partition {} clean up, as NO_CLEANUP set to true", (Object)ci.getFullPartitionName());
                        this.txnHandler.markRefused(ci);
                        return;
                    }
                }
            }
            this.txnHandler.markCleanerStart(ci);
            if (!Objects.isNull(t) || !Objects.isNull(ci.partName)) {
                boolean dropPartition;
                String path = Objects.isNull(location) ? CompactorUtil.resolveStorageDescriptor(t, p).getLocation() : location;
                boolean bl = dropPartition = !Objects.isNull(ci.partName) && Objects.isNull(p);
                if (dropPartition && Objects.isNull(this.resolvePartition(ci.dbname, ci.tableName, ci.partName))) {
                    this.cleanUsingLocation(ci, path, true);
                } else {
                    long cleanerWaterMark = ci.minOpenWriteId > 0L ? ci.nextTxnId + 1L : minOpenTxn;
                    this.cleanUsingAcidDir(ci, t, path, cleanerWaterMark);
                }
            } else {
                this.cleanUsingLocation(ci, location, false);
            }
        }
        catch (Exception e) {
            LOG.error("Caught exception when cleaning, unable to complete cleaning of {} due to {}", (Object)ci, (Object)e.getMessage());
            if (metricsEnabled) {
                Metrics.getOrCreateCounter((String)"compaction_cleaner_failure_counter").inc();
            }
            this.handleCleanerAttemptFailure(ci, e.getMessage());
        }
        finally {
            if (metricsEnabled) {
                perfLogger.perfLogEnd(CompactionCleaner.class.getName(), cleanerMetric);
            }
        }
    }

    private void cleanUsingLocation(CompactionInfo ci, String path, boolean requiresLock) throws MetaException {
        List<Path> deleted;
        if (requiresLock) {
            LockRequest lockRequest = this.createLockRequest(ci);
            LockResponse res = null;
            try {
                res = this.txnHandler.lock(lockRequest);
                deleted = this.fsRemover.clean(this.getCleaningRequestBasedOnLocation(ci, path));
            }
            catch (NoSuchTxnException | TxnAbortedException e) {
                LOG.error("Error while trying to acquire exclusive write lock: {}", (Object)e.getMessage());
                throw new MetaException(e.getMessage());
            }
            finally {
                if (res != null) {
                    try {
                        this.txnHandler.unlock(new UnlockRequest(res.getLockid()));
                    }
                    catch (NoSuchLockException | TxnOpenException e) {
                        LOG.error("Error while trying to release exclusive write lock: {}", (Object)e.getMessage());
                    }
                }
            }
        }
        deleted = this.fsRemover.clean(this.getCleaningRequestBasedOnLocation(ci, path));
        if (!deleted.isEmpty()) {
            this.txnHandler.markCleaned(ci);
        } else {
            this.txnHandler.clearCleanerStart(ci);
        }
    }

    private void cleanUsingAcidDir(CompactionInfo ci, Table table, String location, long minOpenTxn) throws Exception {
        ValidTxnList validTxnList = TxnUtils.createValidTxnListForCleaner((GetOpenTxnsResponse)this.getOpenTxns(), (long)minOpenTxn, (boolean)false);
        this.getConf().set("hive.txn.valid.txns", validTxnList.writeToString());
        ValidReaderWriteIdList validWriteIdList = this.getValidCleanerWriteIdList(ci, validTxnList);
        LOG.debug("Cleaning based on writeIdList: {}", (Object)validWriteIdList);
        boolean success = this.cleanAndVerifyObsoleteDirectories(ci, location, validWriteIdList, table);
        if (success || CompactorUtil.isDynPartAbort(table, ci.partName)) {
            this.txnHandler.markCleaned(ci);
        } else {
            this.txnHandler.clearCleanerStart(ci);
            LOG.warn("Leaving queue entry {} in ready for cleaning state.", (Object)ci);
        }
    }

    private LockRequest createLockRequest(CompactionInfo ci) {
        return CompactorUtil.createLockRequest(this.getConf(), ci, 0L, LockType.EXCL_WRITE, DataOperationType.DELETE);
    }

    private static String idWatermark(CompactionInfo ci) {
        return " id=" + ci.id;
    }

    @Override
    protected ValidReaderWriteIdList getValidCleanerWriteIdList(CompactionInfo ci, ValidTxnList validTxnList) throws Exception {
        ValidReaderWriteIdList validWriteIdList = super.getValidCleanerWriteIdList(ci, validTxnList);
        if (ci.highestWriteId < validWriteIdList.getHighWatermark()) {
            validWriteIdList.setHighWatermark(ci.highestWriteId);
        }
        return validWriteIdList;
    }

    private CleanupRequest getCleaningRequestBasedOnLocation(CompactionInfo ci, String location) {
        String strIfPurge = ci.getProperty("ifPurge");
        boolean ifPurge = strIfPurge != null || Boolean.parseBoolean(ci.getProperty("ifPurge"));
        Path obsoletePath = new Path(location);
        return new CleanupRequest.CleanupRequestBuilder().setLocation(location).setDbName(ci.dbname).setFullPartitionName(ci.getFullPartitionName()).setRunAs(ci.runAs).setPurge(ifPurge).setObsoleteDirs(Collections.singletonList(obsoletePath)).build();
    }
}

