/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.session;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionStateUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SessionStateUtil.class);
    private static final String COMMIT_INFO_PREFIX = "COMMIT_INFO.";
    private static final String CONFLICT_DETECTION_FILTER = "conflictDetectionFilter.";
    public static final String DEFAULT_TABLE_LOCATION = "defaultLocation";
    public static final String MISSING_COLUMNS = "missingColumns";
    public static final String COLUMN_DEFAULTS = "columnDefaults";

    private SessionStateUtil() {
    }

    public static Optional<Object> getResource(Configuration conf, String key) {
        return SessionStateUtil.getQueryState(conf).map(queryState -> queryState.getResource(key));
    }

    public static Optional<String> getProperty(Configuration conf, String key) {
        return SessionStateUtil.getResource(conf, key).filter(String.class::isInstance).map(String.class::cast);
    }

    public static void addResource(Configuration conf, String key, Object resource) {
        SessionStateUtil.getQueryState(conf).ifPresent(queryState -> queryState.addResource(key, resource));
    }

    public static void addResourceOrThrow(Configuration conf, String key, Object resource) {
        SessionStateUtil.getQueryState(conf).orElseThrow(() -> new IllegalStateException("Query state is missing; failed to add resource for " + key)).addResource(key, resource);
    }

    public static Optional<Map<String, CommitInfo>> getCommitInfo(Configuration conf, String tableName) {
        return SessionStateUtil.getResource(conf, COMMIT_INFO_PREFIX + tableName).map(obj -> (Map)obj);
    }

    public static void addCommitInfo(Configuration conf, String tableName, String jobId, int taskNum, Map<String, String> additionalProps) {
        CommitInfo commitInfo = new CommitInfo().withJobID(jobId).withTaskNum(taskNum).withProps(additionalProps);
        SessionStateUtil.getCommitInfo(conf, tableName).ifPresentOrElse(commitInfoMap -> commitInfoMap.put(jobId, commitInfo), () -> {
            HashMap newCommitInfoMap = Maps.newHashMap();
            newCommitInfoMap.put(jobId, commitInfo);
            SessionStateUtil.addResource(conf, COMMIT_INFO_PREFIX + tableName, newCommitInfoMap);
        });
    }

    public static Optional<ExprNodeGenericFuncDesc> getConflictDetectionFilter(Configuration conf, Object tableName) {
        return SessionStateUtil.getResource(conf, CONFLICT_DETECTION_FILTER + String.valueOf(tableName)).map(ExprNodeGenericFuncDesc.class::cast);
    }

    public static void setConflictDetectionFilter(Configuration conf, String tableName, ExprNodeDesc filterExpr) {
        String key = CONFLICT_DETECTION_FILTER + tableName;
        SessionStateUtil.getConflictDetectionFilter(conf, tableName).ifPresentOrElse(prevFilterExpr -> {
            if (!prevFilterExpr.isSame(filterExpr)) {
                ExprNodeDesc disjunction = null;
                try {
                    disjunction = ExprNodeDescUtils.disjunction(prevFilterExpr, filterExpr);
                }
                catch (UDFArgumentException e) {
                    LOG.warn("Unable to create conflict detection filter, proceeding without it: ", (Throwable)e);
                }
                SessionStateUtil.addResource(conf, key, disjunction);
            }
        }, () -> SessionStateUtil.addResource(conf, key, filterExpr));
    }

    public static Optional<QueryState> getQueryState(Configuration conf) {
        return Optional.ofNullable(SessionState.get()).map(ss -> ss.getQueryState(HiveConf.getQueryId((Configuration)conf)));
    }

    public static class CommitInfo {
        String jobIdStr;
        int taskNum;
        Map<String, String> props;

        public CommitInfo withJobID(String jobIdStr) {
            this.jobIdStr = jobIdStr;
            return this;
        }

        public CommitInfo withTaskNum(int taskNum) {
            this.taskNum = taskNum;
            return this;
        }

        public CommitInfo withProps(Map<String, String> props) {
            this.props = props;
            return this;
        }

        public String getJobIdStr() {
            return this.jobIdStr;
        }

        public int getTaskNum() {
            return this.taskNum;
        }

        public Map<String, String> getProps() {
            return this.props;
        }
    }
}

