/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.filtercontext;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthorizableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthzInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableFilterContext
extends HiveMetaStoreAuthorizableEvent {
    private static final Logger LOG = LoggerFactory.getLogger(TableFilterContext.class);
    List<Table> tables = null;
    List<String> tableNames = null;
    String catName = null;
    String dbName = null;

    public TableFilterContext(List<Table> tables) {
        super(null);
        this.tables = tables;
        this.getAuthzContext();
    }

    public TableFilterContext(String catName, String dbName, List<String> tableNames) {
        super(null);
        this.catName = catName;
        this.dbName = dbName;
        this.tableNames = tableNames;
    }

    public static TableFilterContext createFromTableMetas(String dbName, List<TableMeta> tableMetas) {
        ArrayList<Table> tables = new ArrayList<Table>();
        for (TableMeta tableMeta : tableMetas) {
            Table table = new Table();
            table.setCatName(tableMeta.getCatName());
            table.setDbName(dbName);
            table.setTableName(tableMeta.getTableName());
            if (tableMeta.isSetOwnerName()) {
                table.setOwner(tableMeta.getOwnerName());
            }
            if (tableMeta.isSetOwnerType()) {
                table.setOwnerType(tableMeta.getOwnerType());
            }
            tables.add(table);
        }
        return new TableFilterContext(tables);
    }

    @Override
    public HiveMetaStoreAuthzInfo getAuthzContext() {
        HiveMetaStoreAuthzInfo ret = new HiveMetaStoreAuthzInfo(this.preEventContext, HiveOperationType.QUERY, this.getInputHObjs(), this.getOutputHObjs(), null);
        return ret;
    }

    private List<HivePrivilegeObject> getInputHObjs() {
        LOG.debug("==> TableFilterContext.getOutputHObjs()");
        ArrayList<HivePrivilegeObject> ret = new ArrayList<HivePrivilegeObject>();
        if (this.tables != null) {
            for (Table table : this.tables) {
                ret.add(this.getHivePrivilegeObject(table));
            }
        } else {
            for (String tableName : this.tableNames) {
                HivePrivilegeObject.HivePrivilegeObjectType type = HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW;
                HivePrivilegeObject hivePrivilegeObject = new HivePrivilegeObject(type, this.catName, this.dbName, tableName);
                ret.add(hivePrivilegeObject);
            }
        }
        LOG.debug("<== TableFilterContext.getOutputHObjs(): ret=" + String.valueOf(ret));
        return ret;
    }

    private List<HivePrivilegeObject> getOutputHObjs() {
        return Collections.emptyList();
    }

    public List<Table> getTables() {
        return this.tables;
    }
}

