/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.DatabaseName;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.metastore.HMSHandlerContext;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;

@InterfaceStability.Evolving
@InterfaceAudience.LimitedPrivate(value={"Apache Argus (incubating)"})
public class HivePrivilegeObject
implements Comparable<HivePrivilegeObject> {
    private final HivePrivilegeObjectType type;
    private final String catName;
    private final String dbname;
    private final String objectName;
    private final List<String> commandParams;
    private final List<String> partKeys;
    private final List<String> columns;
    private final HivePrivObjectActionType actionType;
    private final String className;
    private final String ownerName;
    private final PrincipalType ownerType;
    private List<String> cellValueTransformers;
    private String rowFilterExpression;

    @Override
    public int compareTo(HivePrivilegeObject o) {
        int compare = this.type.compareTo(o.type);
        if (compare == 0) {
            int n = this.catName != null ? (o.catName != null ? this.catName.compareTo(o.catName) : 1) : (compare = o.catName != null ? -1 : 0);
        }
        if (compare == 0) {
            int n = this.dbname != null ? (o.dbname != null ? this.dbname.compareTo(o.dbname) : 1) : (compare = o.dbname != null ? -1 : 0);
        }
        if (compare == 0) {
            int n = this.objectName != null ? (o.objectName != null ? this.objectName.compareTo(o.objectName) : 1) : (compare = o.objectName != null ? -1 : 0);
        }
        if (compare == 0) {
            int n = this.partKeys != null ? (o.partKeys != null ? this.compare(this.partKeys, o.partKeys) : 1) : (compare = o.partKeys != null ? -1 : 0);
        }
        if (compare == 0) {
            int n = this.columns != null ? (o.columns != null ? this.compare(this.columns, o.columns) : 1) : (compare = o.columns != null ? -1 : 0);
        }
        if (compare == 0) {
            int n = this.className != null ? (o.className != null ? this.className.compareTo(o.className) : 1) : (compare = o.className != null ? -1 : 0);
        }
        if (compare == 0) {
            int n = this.ownerName != null ? (o.ownerName != null ? this.ownerName.compareTo(o.ownerName) : 1) : (compare = o.ownerName != null ? -1 : 0);
        }
        if (compare == 0) {
            compare = this.ownerType != null ? (o.ownerType != null ? this.ownerType.compareTo((Enum)o.ownerType) : 1) : (o.ownerType != null ? -1 : 0);
        }
        return compare;
    }

    private int compare(Collection<String> o1, Collection<String> o2) {
        Iterator<String> it1 = o1.iterator();
        Iterator<String> it2 = o2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            String s1 = it1.next();
            String s2 = it2.next();
            int compare = s1 != null ? (s2 != null ? s1.compareTo(s2) : 1) : (s2 != null ? -1 : 0);
            if (compare == 0) continue;
            return compare;
        }
        return o1.size() > o2.size() ? 1 : (o1.size() < o2.size() ? -1 : 0);
    }

    public static Configuration getConf() {
        return HMSHandlerContext.getConfiguration().orElse(new Configuration());
    }

    @Deprecated
    public HivePrivilegeObject(HivePrivilegeObjectType type, String dbname, String objectName) {
        this(type, dbname, objectName, HivePrivObjectActionType.OTHER);
    }

    @Deprecated
    public HivePrivilegeObject(HivePrivilegeObjectType type, String dbname, String objectName, HivePrivObjectActionType actionType) {
        this(type, dbname, objectName, null, null, actionType, null, null);
    }

    @Deprecated
    public HivePrivilegeObject(HivePrivilegeObjectType type, String dbname, String objectName, List<String> partKeys, String column) {
        this(type, dbname, objectName, partKeys, column == null ? null : Arrays.asList(column), HivePrivObjectActionType.OTHER, null, null);
    }

    public HivePrivilegeObject(HivePrivilegeObjectType type, String objectName) {
        this(type, null, null, objectName);
    }

    public HivePrivilegeObject(HivePrivilegeObjectType type, String catName, String dbname, String objectName) {
        this(type, catName, dbname, objectName, null, null);
    }

    public HivePrivilegeObject(HivePrivilegeObjectType type, String catName, String dbname, String objectName, List<String> partKeys, List<String> columns) {
        this(type, catName, dbname, objectName, partKeys, columns, HivePrivObjectActionType.OTHER, null);
    }

    public HivePrivilegeObject(HivePrivilegeObjectType type, String catName, String dbname, String objectName, List<String> partKeys, List<String> columns, HivePrivObjectActionType actionType, List<String> commandParams) {
        this(type, catName, dbname, objectName, partKeys, columns, actionType, commandParams, null, null, null);
    }

    public static HivePrivilegeObject createHivePrivilegeObject(List<String> cmdParams) {
        return new HivePrivilegeObject(HivePrivilegeObjectType.COMMAND_PARAMS, null, null, null, null, null, null, cmdParams);
    }

    @Deprecated
    public HivePrivilegeObject(HivePrivilegeObjectType type, String dbname, String objectName, List<String> partKeys, List<String> columns, List<String> commandParams) {
        this(type, dbname, objectName, partKeys, columns, HivePrivObjectActionType.OTHER, commandParams, null);
    }

    @Deprecated
    public HivePrivilegeObject(String dbname, String objectName, List<String> columns) {
        this(HivePrivilegeObjectType.TABLE_OR_VIEW, null, dbname, objectName, null, columns);
    }

    @Deprecated
    public HivePrivilegeObject(String dbname, String objectName, List<String> columns, String ownerName, PrincipalType ownerType) {
        this(HivePrivilegeObjectType.TABLE_OR_VIEW, dbname, objectName, null, columns, HivePrivObjectActionType.OTHER, null, null, ownerName, ownerType);
    }

    @Deprecated
    public HivePrivilegeObject(HivePrivilegeObjectType type, String dbname, String objectName, List<String> partKeys, List<String> columns, HivePrivObjectActionType actionType, List<String> commandParams, String className) {
        this(type, dbname, objectName, partKeys, columns, actionType, commandParams, className, null, null);
    }

    @Deprecated
    public HivePrivilegeObject(HivePrivilegeObjectType type, String dbname, String objectName, List<String> partKeys, List<String> columns, HivePrivObjectActionType actionType, List<String> commandParams, String className, String ownerName, PrincipalType ownerType) {
        this(type, null, dbname, objectName, partKeys, columns, actionType, commandParams, className, ownerName, ownerType);
    }

    public HivePrivilegeObject(HivePrivilegeObjectType type, String catName, String dbname, String objectName, List<String> partKeys, List<String> columns, HivePrivObjectActionType actionType, List<String> commandParams, String className, String ownerName, PrincipalType ownerType) {
        this.type = type;
        this.catName = catName == null ? MetaStoreUtils.getDefaultCatalog((Configuration)HivePrivilegeObject.getConf()) : catName;
        this.dbname = dbname;
        this.objectName = objectName;
        this.partKeys = partKeys;
        this.columns = columns;
        this.actionType = actionType;
        this.commandParams = commandParams;
        this.className = className;
        this.ownerName = ownerName;
        this.ownerType = ownerType;
    }

    public static HivePrivilegeObject forScheduledQuery(String owner, String clusterNamespace, String scheduleName) {
        return new HivePrivilegeObject(HivePrivilegeObjectType.SCHEDULED_QUERY, null, clusterNamespace, scheduleName, null, null, null, null, null, owner, null);
    }

    public HivePrivilegeObjectType getType() {
        return this.type;
    }

    public String getCatName() {
        return this.catName;
    }

    public String getDbname() {
        return this.dbname;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public HivePrivObjectActionType getActionType() {
        return this.actionType;
    }

    public List<String> getCommandParams() {
        return this.commandParams;
    }

    public List<String> getPartKeys() {
        return this.partKeys;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public String getClassName() {
        return this.className;
    }

    public String toString() {
        Object name = null;
        switch (this.type.ordinal()) {
            case 1: {
                name = this.dbname;
                break;
            }
            case 2: 
            case 3: {
                name = this.getDbObjectName();
                if (this.partKeys == null) break;
                name = (String)name + this.partKeys.toString();
                break;
            }
            case 8: {
                name = this.getDbObjectName();
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 12: {
                name = this.objectName;
                break;
            }
            case 7: {
                name = this.commandParams.toString();
                break;
            }
            case 10: {
                name = this.objectName;
                break;
            }
            case 9: {
                name = this.objectName;
            }
        }
        Object actionTypeStr = "";
        if (this.actionType != null) {
            switch (this.actionType.ordinal()) {
                case 1: 
                case 2: {
                    actionTypeStr = ", action=" + String.valueOf((Object)this.actionType);
                }
            }
        }
        return "Object [type=" + String.valueOf((Object)this.type) + ", name=" + (String)name + (String)actionTypeStr + "]";
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public PrincipalType getOwnerType() {
        return this.ownerType;
    }

    private String getDbObjectName() {
        return DatabaseName.getQualified((String)this.catName, (String)this.dbname) + "." + this.objectName;
    }

    public List<String> getCellValueTransformers() {
        return this.cellValueTransformers;
    }

    public void setCellValueTransformers(List<String> cellValueTransformers) {
        this.cellValueTransformers = cellValueTransformers;
    }

    public String getRowFilterExpression() {
        return this.rowFilterExpression;
    }

    public void setRowFilterExpression(String rowFilterExpression) {
        this.rowFilterExpression = rowFilterExpression;
    }

    public static enum HivePrivilegeObjectType {
        GLOBAL,
        DATABASE,
        TABLE_OR_VIEW,
        PARTITION,
        COLUMN,
        LOCAL_URI,
        DFS_URI,
        COMMAND_PARAMS,
        FUNCTION,
        DATACONNECTOR,
        SERVICE_NAME,
        SCHEDULED_QUERY,
        STORAGEHANDLER_URI;

    }

    public static enum HivePrivObjectActionType {
        OTHER,
        INSERT,
        INSERT_OVERWRITE,
        UPDATE,
        DELETE;

    }
}

