/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan.mapper;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.optimizer.signature.OpTreeSignature;
import org.apache.hadoop.hive.ql.optimizer.signature.RelTreeSignature;
import org.apache.hadoop.hive.ql.plan.mapper.PersistedRuntimeStats;
import org.apache.hadoop.hive.ql.plan.mapper.StatsSource;
import org.apache.hadoop.hive.ql.stats.OperatorStats;

public class CachingStatsSource
implements StatsSource {
    private final Cache<Object, OperatorStats> cache;

    public CachingStatsSource(int cacheSize) {
        this.cache = CacheBuilder.newBuilder().maximumSize((long)cacheSize).build();
    }

    @Override
    public Optional<OperatorStats> lookup(OpTreeSignature treeSig) {
        return Optional.ofNullable((OperatorStats)this.cache.getIfPresent((Object)treeSig));
    }

    @Override
    public Optional<OperatorStats> lookup(RelTreeSignature treeSig) {
        return Optional.ofNullable((OperatorStats)this.cache.getIfPresent((Object)treeSig));
    }

    @Override
    public boolean canProvideStatsFor(Class<?> clazz) {
        return this.cache.size() > 0L && Operator.class.isAssignableFrom(clazz);
    }

    private void put(OpTreeSignature sig, OperatorStats opStat) {
        this.cache.put((Object)sig, (Object)opStat);
    }

    @Override
    public void load(List<PersistedRuntimeStats> statMap) {
        for (PersistedRuntimeStats entry : statMap) {
            if (entry.rSig != null) {
                this.cache.put((Object)entry.rSig, (Object)entry.stat);
            }
            if (entry.sig == null) continue;
            this.cache.put((Object)entry.sig, (Object)entry.stat);
        }
    }
}

