/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Column Stats Update Work", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class ColumnStatsUpdateWork
implements Serializable,
DDLDesc.DDLDescWithWriteId {
    private static final long serialVersionUID = 1L;
    private final String partName;
    private final Map<String, String> mapProp;
    private final String dbName;
    private final String tableName;
    private final String colName;
    private final String colType;
    private final ColumnStatistics colStats;
    private long writeId;
    private boolean isReplication;
    private String dumpDirectory;
    private transient ReplicationMetricCollector metricCollector;

    public ColumnStatsUpdateWork(String partName, Map<String, String> mapProp, String dbName, String tableName, String colName, String colType) {
        this.partName = partName;
        this.mapProp = mapProp;
        this.dbName = dbName;
        this.tableName = tableName;
        this.colName = colName;
        this.colType = colType;
        this.colStats = null;
    }

    public ColumnStatsUpdateWork(ColumnStatistics colStats) {
        this.colStats = colStats;
        this.partName = null;
        this.mapProp = null;
        this.dbName = null;
        this.tableName = null;
        this.colName = null;
        this.colType = null;
    }

    public ColumnStatsUpdateWork(ColumnStatistics colStats, String dumpRoot, ReplicationMetricCollector metricCollector, boolean isReplication) {
        this.colStats = colStats;
        this.partName = null;
        this.mapProp = null;
        this.dbName = null;
        this.tableName = null;
        this.colName = null;
        this.colType = null;
        this.dumpDirectory = dumpRoot;
        this.metricCollector = metricCollector;
        this.isReplication = true;
    }

    public String toString() {
        return null;
    }

    public String getDumpDirectory() {
        return this.dumpDirectory;
    }

    public boolean isReplication() {
        return this.isReplication;
    }

    public String getPartName() {
        return this.partName;
    }

    public Map<String, String> getMapProp() {
        return this.mapProp;
    }

    public String dbName() {
        return this.dbName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColName() {
        return this.colName;
    }

    public String getColType() {
        return this.colType;
    }

    public ColumnStatistics getColStats() {
        return this.colStats;
    }

    public ReplicationMetricCollector getMetricCollector() {
        return this.metricCollector;
    }

    @Override
    public void setWriteId(long writeId) {
        this.writeId = writeId;
    }

    public long getWriteId() {
        return this.writeId;
    }

    @Override
    public String getFullTableName() {
        return this.dbName + "." + this.tableName;
    }

    @Override
    public boolean mayNeedWriteId() {
        return true;
    }
}

