/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.optimizer.physical.GenMRSkewJoinProcessor;
import org.apache.hadoop.hive.ql.optimizer.physical.SkewJoinResolver;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.JoinDesc;

public final class SkewJoinProcFactory {
    public static SemanticNodeProcessor getDefaultProc() {
        return new SkewJoinDefaultProcessor();
    }

    public static SemanticNodeProcessor getJoinProc() {
        return new SkewJoinJoinProcessor();
    }

    private SkewJoinProcFactory() {
    }

    public static class SkewJoinDefaultProcessor
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            return null;
        }
    }

    public static class SkewJoinJoinProcessor
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            SkewJoinResolver.SkewJoinProcCtx context = (SkewJoinResolver.SkewJoinProcCtx)ctx;
            JoinOperator op = (JoinOperator)nd;
            if (((JoinDesc)op.getConf()).isFixedAsSorted()) {
                return null;
            }
            ParseContext parseContext = context.getParseCtx();
            Task<?> currentTsk = context.getCurrentTask();
            GenMRSkewJoinProcessor.processSkewJoin(op, currentTsk, parseContext);
            return null;
        }
    }
}

