/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.ViewExpanders;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.metadata.RelColumnOrigin;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Util;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveLoptMultiJoin;
import org.checkerframework.checker.nullness.qual.Nullable;

public class HiveLoptSemiJoinOptimizer {
    private static final int THRESHOLD_SCORE = 10;
    private final RexBuilder rexBuilder;
    private final RelMetadataQuery mq;
    private RelNode[] chosenSemiJoins;
    private final Map<Integer, Map<Integer, LogicalJoin>> possibleSemiJoins = new HashMap<Integer, Map<Integer, LogicalJoin>>();
    private final Ordering<Integer> factorCostOrdering = Ordering.from((Comparator)new FactorCostComparator());

    public HiveLoptSemiJoinOptimizer(RelMetadataQuery mq, HiveLoptMultiJoin multiJoin, RexBuilder rexBuilder) {
        this.mq = mq;
        int nJoinFactors = multiJoin.getNumJoinFactors();
        this.chosenSemiJoins = new RelNode[nJoinFactors];
        for (int i = 0; i < nJoinFactors; ++i) {
            this.chosenSemiJoins[i] = multiJoin.getJoinFactor(i);
        }
        this.rexBuilder = rexBuilder;
    }

    public void makePossibleSemiJoins(HiveLoptMultiJoin multiJoin) {
        this.possibleSemiJoins.clear();
        if (multiJoin.getMultiJoinRel().isFullOuterJoin()) {
            return;
        }
        int nJoinFactors = multiJoin.getNumJoinFactors();
        for (int factIdx = 0; factIdx < nJoinFactors; ++factIdx) {
            HashMap<Integer, ArrayList<RexNode>> dimFilters = new HashMap<Integer, ArrayList<RexNode>>();
            HashMap<Integer, LogicalJoin> semiJoinMap = new HashMap<Integer, LogicalJoin>();
            for (RexNode joinFilter : multiJoin.getJoinFilters()) {
                int dimIdx = HiveLoptSemiJoinOptimizer.isSuitableFilter(multiJoin, joinFilter, factIdx);
                if (dimIdx == -1 || multiJoin.isNullGenerating(factIdx) || multiJoin.isNullGenerating(dimIdx)) continue;
                ArrayList<RexNode> currDimFilters = (ArrayList<RexNode>)dimFilters.get(dimIdx);
                if (currDimFilters == null) {
                    currDimFilters = new ArrayList<RexNode>();
                }
                currDimFilters.add(joinFilter);
                dimFilters.put(dimIdx, currDimFilters);
            }
            Set dimIdxes = dimFilters.keySet();
            for (Integer dimIdx : dimIdxes) {
                LogicalJoin semiJoin;
                List joinFilters = (List)dimFilters.get(dimIdx);
                if (joinFilters == null || (semiJoin = this.findSemiJoinIndexByCost(multiJoin, joinFilters, factIdx, dimIdx)) == null) continue;
                semiJoinMap.put(dimIdx, semiJoin);
                this.possibleSemiJoins.put(factIdx, semiJoinMap);
            }
        }
    }

    private static int isSuitableFilter(HiveLoptMultiJoin multiJoin, RexNode joinFilter, int factIdx) {
        switch (joinFilter.getKind()) {
            case EQUALS: {
                break;
            }
            default: {
                return -1;
            }
        }
        List operands = ((RexCall)joinFilter).getOperands();
        if (!(operands.get(0) instanceof RexInputRef) || !(operands.get(1) instanceof RexInputRef)) {
            return -1;
        }
        ImmutableBitSet joinRefs = multiJoin.getFactorsRefByJoinFilter(joinFilter);
        assert (joinRefs.cardinality() == 2);
        int factor1 = joinRefs.nextSetBit(0);
        int factor2 = joinRefs.nextSetBit(factor1 + 1);
        if (factor1 == factIdx) {
            return factor2;
        }
        if (factor2 == factIdx) {
            return factor1;
        }
        return -1;
    }

    private @Nullable LogicalJoin findSemiJoinIndexByCost(HiveLoptMultiJoin multiJoin, List<RexNode> joinFilters, int factIdx, int dimIdx) {
        ArrayList<Integer> actualLeftKeys;
        ArrayList rightKeys;
        RexNode semiJoinCondition = RexUtil.composeConjunction((RexBuilder)this.rexBuilder, joinFilters);
        int leftAdjustment = 0;
        for (int i = 0; i < factIdx; ++i) {
            leftAdjustment -= multiJoin.getNumFieldsInJoinFactor(i);
        }
        semiJoinCondition = this.adjustSemiJoinCondition(multiJoin, leftAdjustment, semiJoinCondition, factIdx, dimIdx);
        RelNode factRel = multiJoin.getJoinFactor(factIdx);
        RelNode dimRel = multiJoin.getJoinFactor(dimIdx);
        JoinInfo joinInfo = JoinInfo.of((RelNode)factRel, (RelNode)dimRel, (RexNode)semiJoinCondition);
        assert (joinInfo.leftKeys.size() > 0);
        ArrayList leftKeys = Lists.newArrayList((Iterable)joinInfo.leftKeys);
        LcsTable factTable = this.validateKeys(factRel, leftKeys, rightKeys = Lists.newArrayList((Iterable)joinInfo.rightKeys), actualLeftKeys = new ArrayList<Integer>());
        if (factTable == null) {
            return null;
        }
        ArrayList<Integer> bestKeyOrder = new ArrayList<Integer>();
        LcsTableScan tmpFactRel = (LcsTableScan)factTable.toRel(ViewExpanders.simpleContext((RelOptCluster)factRel.getCluster()));
        LcsIndexOptimizer indexOptimizer = new LcsIndexOptimizer(tmpFactRel);
        FemLocalIndex bestIndex = indexOptimizer.findSemiJoinIndexByCost(dimRel, actualLeftKeys, rightKeys, bestKeyOrder);
        if (bestIndex == null) {
            return null;
        }
        if (actualLeftKeys.size() == bestKeyOrder.size()) {
            ArrayList truncatedLeftKeys = leftKeys;
            ArrayList truncatedRightKeys = rightKeys;
        } else {
            ArrayList<Integer> truncatedLeftKeys = new ArrayList<Integer>();
            ArrayList<Integer> truncatedRightKeys = new ArrayList<Integer>();
            Iterator iterator = bestKeyOrder.iterator();
            while (iterator.hasNext()) {
                int key = (Integer)iterator.next();
                truncatedLeftKeys.add((Integer)leftKeys.get(key));
                truncatedRightKeys.add((Integer)rightKeys.get(key));
            }
            semiJoinCondition = this.removeExtraFilters(truncatedLeftKeys, multiJoin.getNumFieldsInJoinFactor(factIdx), semiJoinCondition);
        }
        return LogicalJoin.create((RelNode)factRel, (RelNode)dimRel, (List)ImmutableList.of(), (RexNode)Objects.requireNonNull(semiJoinCondition, "semiJoinCondition"), (Set)ImmutableSet.of(), (JoinRelType)JoinRelType.SEMI);
    }

    private RexNode adjustSemiJoinCondition(HiveLoptMultiJoin multiJoin, int leftAdjustment, RexNode semiJoinCondition, int leftIdx, int rightIdx) {
        int rightAdjustment = 0;
        for (int i = 0; i < rightIdx; ++i) {
            rightAdjustment -= multiJoin.getNumFieldsInJoinFactor(i);
        }
        int rightStart = -rightAdjustment;
        int numFieldsLeftIdx = multiJoin.getNumFieldsInJoinFactor(leftIdx);
        int numFieldsRightIdx = multiJoin.getNumFieldsInJoinFactor(rightIdx);
        if (leftAdjustment != 0 || (rightAdjustment += numFieldsLeftIdx) != 0) {
            int i;
            int[] adjustments = new int[multiJoin.getNumTotalFields()];
            if (leftAdjustment != 0) {
                for (i = -leftAdjustment; i < -leftAdjustment + numFieldsLeftIdx; ++i) {
                    adjustments[i] = leftAdjustment;
                }
            }
            if (rightAdjustment != 0) {
                for (i = rightStart; i < rightStart + numFieldsRightIdx; ++i) {
                    adjustments[i] = rightAdjustment;
                }
            }
            return (RexNode)semiJoinCondition.accept((RexVisitor)new RelOptUtil.RexInputConverter(this.rexBuilder, multiJoin.getMultiJoinFields(), adjustments));
        }
        return semiJoinCondition;
    }

    private @Nullable LcsTable validateKeys(RelNode factRel, List<Integer> leftKeys, List<Integer> rightKeys, List<Integer> actualLeftKeys) {
        int keyIdx = 0;
        RelOptTable theTable = null;
        ListIterator<Integer> keyIter = leftKeys.listIterator();
        while (keyIter.hasNext()) {
            boolean removeKey = false;
            RelColumnOrigin colOrigin = this.mq.getColumnOrigin(factRel, keyIter.next().intValue());
            if (colOrigin == null || !colOrigin.isDerived() || LucidDbSpecialOperators.isLcsRidColumnId(colOrigin.getOriginColumnOrdinal())) {
                removeKey = true;
            } else {
                RelOptTable table = colOrigin.getOriginTable();
                if (theTable == null) {
                    if (!(table instanceof LcsTable)) {
                        removeKey = true;
                    } else {
                        theTable = table;
                    }
                } else assert (table == theTable);
            }
            if (colOrigin != null && !removeKey) {
                actualLeftKeys.add(colOrigin.getOriginColumnOrdinal());
                ++keyIdx;
                continue;
            }
            keyIter.remove();
            rightKeys.remove(keyIdx);
        }
        if (actualLeftKeys.isEmpty()) {
            return null;
        }
        return (LcsTable)theTable;
    }

    private @Nullable RexNode removeExtraFilters(List<Integer> keys, int nFields, RexNode condition) {
        assert (condition instanceof RexCall);
        RexCall call = (RexCall)condition;
        if (condition.isA(SqlKind.AND)) {
            List operands = call.getOperands();
            RexNode left = this.removeExtraFilters(keys, nFields, (RexNode)operands.get(0));
            RexNode right = this.removeExtraFilters(keys, nFields, (RexNode)operands.get(1));
            if (left == null) {
                return right;
            }
            if (right == null) {
                return left;
            }
            return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{left, right});
        }
        assert (call.getOperator() == SqlStdOperatorTable.EQUALS);
        List operands = call.getOperands();
        assert (operands.get(0) instanceof RexInputRef);
        assert (operands.get(1) instanceof RexInputRef);
        int idx = ((RexInputRef)operands.get(0)).getIndex();
        if (idx < nFields ? !keys.contains(idx) : !keys.contains(idx = ((RexInputRef)operands.get(1)).getIndex())) {
            return null;
        }
        return condition;
    }

    public boolean chooseBestSemiJoin(HiveLoptMultiJoin multiJoin) {
        int nJoinFactors = multiJoin.getNumJoinFactors();
        ImmutableList sortedFactors = this.factorCostOrdering.immutableSortedCopy((Iterable)Util.range((int)nJoinFactors));
        for (int i = 0; i < nJoinFactors; ++i) {
            Integer factIdx = (Integer)sortedFactors.get(i);
            RelNode factRel = this.chosenSemiJoins[factIdx];
            Map<Integer, LogicalJoin> possibleDimensions = this.possibleSemiJoins.get(factIdx);
            if (possibleDimensions == null) continue;
            double bestScore = 0.0;
            int bestDimIdx = -1;
            Set<Integer> dimIdxes = possibleDimensions.keySet();
            for (Integer dimIdx : dimIdxes) {
                double score;
                LogicalJoin semiJoin = possibleDimensions.get(dimIdx);
                if (semiJoin == null || !((score = this.computeScore(factRel, this.chosenSemiJoins[dimIdx], semiJoin)) > 10.0) || !(score > bestScore)) continue;
                bestDimIdx = dimIdx;
                bestScore = score;
            }
            if (bestDimIdx == -1) continue;
            int bestDimIdxFinal = bestDimIdx;
            LogicalJoin semiJoin = Objects.requireNonNull(possibleDimensions.get(bestDimIdxFinal), () -> "possibleDimensions.get(" + bestDimIdxFinal + ") is null");
            LogicalJoin chosenSemiJoin = LogicalJoin.create((RelNode)factRel, (RelNode)this.chosenSemiJoins[bestDimIdx], (List)ImmutableList.of(), (RexNode)semiJoin.getCondition(), (Set)ImmutableSet.of(), (JoinRelType)JoinRelType.SEMI);
            this.chosenSemiJoins[factIdx.intValue()] = chosenSemiJoin;
            this.removeJoin(multiJoin, chosenSemiJoin, factIdx, bestDimIdx);
            this.removePossibleSemiJoin(possibleDimensions, factIdx, bestDimIdx);
            this.removePossibleSemiJoin(this.possibleSemiJoins.get(bestDimIdx), bestDimIdx, factIdx);
            return true;
        }
        return false;
    }

    private double computeScore(RelNode factRel, RelNode dimRel, LogicalJoin semiJoin) {
        ImmutableBitSet dimCols = ImmutableBitSet.of((ImmutableIntList)semiJoin.analyzeCondition().rightKeys);
        double selectivity = RelMdUtil.computeSemiJoinSelectivity((RelMetadataQuery)this.mq, (RelNode)factRel, (RelNode)dimRel, (Join)semiJoin);
        if (selectivity > 0.5) {
            return 0.0;
        }
        RelOptCost factCost = this.mq.getCumulativeCost(factRel);
        if (factCost == null) {
            return 0.0;
        }
        double savings = (1.0 - Math.sqrt(selectivity)) * Math.max(1.0, factCost.getRows());
        boolean uniq = RelMdUtil.areColumnsDefinitelyUniqueWhenNullsFiltered((RelMetadataQuery)this.mq, (RelNode)dimRel, (ImmutableBitSet)dimCols);
        if (uniq) {
            savings *= 2.0;
        }
        Double dimSortCost = this.mq.getRowCount(dimRel);
        Double dupRemCost = uniq ? 0.0 : dimSortCost;
        RelOptCost dimCost = this.mq.getCumulativeCost(dimRel);
        if (dimSortCost == null || dupRemCost == null || dimCost == null) {
            return 0.0;
        }
        double dimRows = dimCost.getRows();
        if (dimRows < 1.0) {
            dimRows = 1.0;
        }
        return savings / dimRows;
    }

    private void removeJoin(HiveLoptMultiJoin multiJoin, LogicalJoin semiJoin, int factIdx, int dimIdx) {
        int i;
        if (multiJoin.getJoinRemovalFactor(dimIdx) != null) {
            return;
        }
        ImmutableBitSet dimKeys = ImmutableBitSet.of((ImmutableIntList)semiJoin.analyzeCondition().rightKeys);
        RelNode dimRel = multiJoin.getJoinFactor(dimIdx);
        if (!RelMdUtil.areColumnsDefinitelyUniqueWhenNullsFiltered((RelMetadataQuery)this.mq, (RelNode)dimRel, (ImmutableBitSet)dimKeys)) {
            return;
        }
        ImmutableBitSet dimProjRefs = multiJoin.getProjFields(dimIdx);
        if (dimProjRefs == null) {
            int nDimFields = multiJoin.getNumFieldsInJoinFactor(dimIdx);
            dimProjRefs = ImmutableBitSet.range((int)0, (int)nDimFields);
        }
        if (!dimKeys.contains(dimProjRefs)) {
            return;
        }
        int[] dimJoinRefCounts = multiJoin.getJoinFieldRefCounts(dimIdx);
        for (i = 0; i < dimJoinRefCounts.length; ++i) {
            if (dimJoinRefCounts[i] <= 0 || dimKeys.get(i)) continue;
            return;
        }
        multiJoin.setJoinRemovalFactor(dimIdx, factIdx);
        multiJoin.setJoinRemovalSemiJoin(dimIdx, semiJoin);
        if (dimProjRefs.cardinality() != 0) {
            return;
        }
        for (i = 0; i < dimJoinRefCounts.length; ++i) {
            if (dimJoinRefCounts[i] > 1) {
                return;
            }
            if (dimJoinRefCounts[i] != 1 || dimKeys.get(i)) continue;
            return;
        }
        int[] factJoinRefCounts = multiJoin.getJoinFieldRefCounts(factIdx);
        for (Integer key : semiJoin.analyzeCondition().leftKeys) {
            int n = key;
            factJoinRefCounts[n] = factJoinRefCounts[n] - 1;
        }
    }

    private void removePossibleSemiJoin(@Nullable Map<Integer, LogicalJoin> possibleDimensions, Integer factIdx, Integer dimIdx) {
        if (possibleDimensions == null) {
            return;
        }
        possibleDimensions.remove(dimIdx);
        if (possibleDimensions.isEmpty()) {
            this.possibleSemiJoins.remove(factIdx);
        } else {
            this.possibleSemiJoins.put(factIdx, possibleDimensions);
        }
    }

    public RelNode getChosenSemiJoin(int factIdx) {
        return this.chosenSemiJoins[factIdx];
    }

    private class FactorCostComparator
    implements Comparator<Integer> {
        private FactorCostComparator() {
        }

        @Override
        public int compare(Integer rel1Idx, Integer rel2Idx) {
            RelOptCost c1 = HiveLoptSemiJoinOptimizer.this.mq.getCumulativeCost(HiveLoptSemiJoinOptimizer.this.chosenSemiJoins[rel1Idx]);
            RelOptCost c2 = HiveLoptSemiJoinOptimizer.this.mq.getCumulativeCost(HiveLoptSemiJoinOptimizer.this.chosenSemiJoins[rel2Idx]);
            if (c1 == null || c2 == null) {
                return -1;
            }
            return c1.isLt(c2) ? -1 : (c1.equals(c2) ? 0 : 1);
        }
    }

    private static abstract class LcsTable
    implements RelOptTable {
        private LcsTable() {
        }
    }

    private static class LcsTableScan {
        private LcsTableScan() {
        }
    }

    private static class LcsIndexOptimizer {
        LcsIndexOptimizer(LcsTableScan rel) {
        }

        public @Nullable FemLocalIndex findSemiJoinIndexByCost(RelNode dimRel, List<Integer> actualLeftKeys, List<Integer> rightKeys, List<Integer> bestKeyOrder) {
            return null;
        }
    }

    private static class FemLocalIndex {
        private FemLocalIndex() {
        }
    }

    private static class LucidDbSpecialOperators {
        private LucidDbSpecialOperators() {
        }

        public static boolean isLcsRidColumnId(int originColumnOrdinal) {
            return false;
        }
    }
}

