/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;
import org.checkerframework.checker.initialization.qual.UnderInitialization;

public class HiveLoptJoinTree {
    @NotOnlyInitialized
    private final BinaryTree factorTree;
    private final RelNode joinTree;
    private final boolean removableSelfJoin;

    public HiveLoptJoinTree(RelNode joinTree, int factorId) {
        this.joinTree = joinTree;
        this.factorTree = new Leaf(factorId, this);
        this.removableSelfJoin = false;
    }

    public HiveLoptJoinTree(RelNode joinTree, BinaryTree factorTree, boolean removableSelfJoin) {
        this.joinTree = joinTree;
        this.factorTree = factorTree;
        this.removableSelfJoin = removableSelfJoin;
    }

    public HiveLoptJoinTree(RelNode joinTree, BinaryTree leftFactorTree, BinaryTree rightFactorTree) {
        this(joinTree, leftFactorTree, rightFactorTree, false);
    }

    public HiveLoptJoinTree(RelNode joinTree, BinaryTree leftFactorTree, BinaryTree rightFactorTree, boolean removableSelfJoin) {
        this.factorTree = new Node(leftFactorTree, rightFactorTree, this);
        this.joinTree = joinTree;
        this.removableSelfJoin = removableSelfJoin;
    }

    public RelNode getJoinTree() {
        return this.joinTree;
    }

    public HiveLoptJoinTree getLeft() {
        Node node = (Node)this.factorTree;
        return new HiveLoptJoinTree(((Join)this.joinTree).getLeft(), node.getLeft(), node.getLeft().getParent().isRemovableSelfJoin());
    }

    public HiveLoptJoinTree getRight() {
        Node node = (Node)this.factorTree;
        return new HiveLoptJoinTree(((Join)this.joinTree).getRight(), node.getRight(), node.getRight().getParent().isRemovableSelfJoin());
    }

    public BinaryTree getFactorTree() {
        return this.factorTree;
    }

    public List<Integer> getTreeOrder() {
        ArrayList<Integer> treeOrder = new ArrayList<Integer>();
        this.getTreeOrder(treeOrder);
        return treeOrder;
    }

    public void getTreeOrder(List<Integer> treeOrder) {
        this.factorTree.getTreeOrder(treeOrder);
    }

    public boolean isRemovableSelfJoin() {
        return this.removableSelfJoin;
    }

    protected static class Leaf
    extends BinaryTree {
        private final int id;

        public Leaf(int rootId, @UnderInitialization HiveLoptJoinTree parent) {
            super(parent);
            this.id = rootId;
        }

        public int getId() {
            return this.id;
        }

        @Override
        public void getTreeOrder(List<Integer> treeOrder) {
            treeOrder.add(this.id);
        }
    }

    protected static abstract class BinaryTree {
        @NotOnlyInitialized
        private final HiveLoptJoinTree parent;

        protected BinaryTree(@UnderInitialization HiveLoptJoinTree parent) {
            this.parent = parent;
        }

        public HiveLoptJoinTree getParent() {
            return this.parent;
        }

        public abstract void getTreeOrder(List<Integer> var1);
    }

    protected static class Node
    extends BinaryTree {
        private final BinaryTree left;
        private final BinaryTree right;

        public Node(BinaryTree left, BinaryTree right, @UnderInitialization HiveLoptJoinTree parent) {
            super(parent);
            this.left = Objects.requireNonNull(left, "left");
            this.right = Objects.requireNonNull(right, "right");
        }

        public BinaryTree getLeft() {
            return this.left;
        }

        public BinaryTree getRight() {
            return this.right;
        }

        @Override
        public void getTreeOrder(List<Integer> treeOrder) {
            this.left.getTreeOrder(treeOrder);
            this.right.getTreeOrder(treeOrder);
        }
    }
}

