/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.TableFunctionScan;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableFunctionScan;

public class HiveFilterTableFunctionTransposeRule
extends RelOptRule {
    public static final HiveFilterTableFunctionTransposeRule INSTANCE = new HiveFilterTableFunctionTransposeRule(HiveRelFactories.HIVE_BUILDER);

    public HiveFilterTableFunctionTransposeRule(RelBuilderFactory relBuilderFactory) {
        super(HiveFilterTableFunctionTransposeRule.operand(HiveFilter.class, (RelOptRuleOperand)HiveFilterTableFunctionTransposeRule.operand(HiveTableFunctionScan.class, (RelOptRuleOperandChildren)HiveFilterTableFunctionTransposeRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relBuilderFactory, null);
    }

    public boolean matches(RelOptRuleCall call) {
        Filter filterRel = (Filter)call.rel(0);
        HiveTableFunctionScan tfs = (HiveTableFunctionScan)call.rel(1);
        RexNode condition = filterRel.getCondition();
        if (!HiveCalciteUtil.isDeterministic(condition)) {
            return false;
        }
        for (RexNode ce : RelOptUtil.conjunctions((RexNode)filterRel.getCondition())) {
            if (!this.canBePushed(HiveCalciteUtil.getInputRefs(ce), tfs)) continue;
            return true;
        }
        return false;
    }

    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        HiveTableFunctionScan tfs = (HiveTableFunctionScan)call.rel(1);
        RelBuilder builder = call.builder();
        ArrayList<RexNode> newPartKeyFilterConditions = new ArrayList<RexNode>();
        ArrayList<RexNode> unpushedFilterConditions = new ArrayList<RexNode>();
        for (RexNode ce : RelOptUtil.conjunctions((RexNode)filter.getCondition())) {
            if (this.canBePushed(HiveCalciteUtil.getInputRefs(ce), tfs)) {
                newPartKeyFilterConditions.add(ce);
                continue;
            }
            unpushedFilterConditions.add(ce);
        }
        RexNode filterCondToPushBelowProj = RexUtil.composeConjunction((RexBuilder)filter.getCluster().getRexBuilder(), newPartKeyFilterConditions, (boolean)true);
        builder.push(tfs.getInput(0)).filter(new RexNode[]{filterCondToPushBelowProj});
        RexNode unpushedFilCondAboveProj = unpushedFilterConditions.isEmpty() ? null : RexUtil.composeConjunction((RexBuilder)filter.getCluster().getRexBuilder(), unpushedFilterConditions, (boolean)true);
        TableFunctionScan tableFunctionScanNode = tfs.copy(tfs.getTraitSet(), (List<RelNode>)ImmutableList.of((Object)builder.build()), tfs.getCall(), tfs.getElementType(), tfs.getRowType(), tfs.getColumnMappings());
        builder.clear();
        builder.push((RelNode)tableFunctionScanNode);
        if (unpushedFilCondAboveProj != null) {
            builder.filter(new RexNode[]{unpushedFilCondAboveProj});
        }
        call.transformTo(builder.build());
    }

    private boolean canBePushed(Set<Integer> inputRefs, HiveTableFunctionScan tfs) {
        Set columnMappings = tfs.getColumnMappings();
        if (inputRefs.isEmpty()) {
            return true;
        }
        if (CollectionUtils.isEmpty((Collection)columnMappings)) {
            return false;
        }
        for (Integer inputRef : inputRefs) {
            if (tfs.containsInputRefMapping(inputRef)) continue;
            return false;
        }
        return true;
    }
}

