/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.esriJson;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.SpatialReference;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.hadoop.hive.ql.io.esriJson.EsriFeature;
import org.apache.hadoop.hive.ql.io.esriJson.EsriField;
import org.apache.hadoop.hive.ql.io.esriJson.EsriJsonFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EsriFeatureClass {
    public String displayFieldName;
    public Map<String, Object> fieldAliases;
    public Geometry.Type geometryType;
    public SpatialReference spatialReference;
    public EsriField[] fields;
    public EsriFeature[] features;

    public static EsriFeatureClass fromJson(InputStream jsonStream) throws JsonParseException, IOException {
        return EsriJsonFactory.FeatureClassFromJson(jsonStream);
    }

    public static EsriFeatureClass fromJson(JsonParser parser) throws JsonParseException, IOException {
        return EsriJsonFactory.FeatureClassFromJson(parser);
    }

    public String toJson() throws JsonGenerationException, JsonMappingException, IOException {
        return EsriJsonFactory.JsonFromFeatureClass(this);
    }
}

