/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import org.apache.hadoop.hive.common.format.datetime.HiveSqlDateTimeFormatter;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.TimestampToStringUnaryUDF;

public class CastTimestampToString
extends TimestampToStringUnaryUDF {
    private static final long serialVersionUID = 1L;
    private static final DateTimeFormatter PRINT_FORMATTER;

    public CastTimestampToString() {
    }

    public CastTimestampToString(int inputColumn, int outputColumnNum) {
        super(inputColumn, outputColumnNum);
    }

    protected void assign(BytesColumnVector outV, int i, byte[] bytes, int length) {
        outV.setVal(i, bytes, 0, length);
    }

    @Override
    protected void func(BytesColumnVector outV, TimestampColumnVector inV, int i) {
        byte[] temp = LocalDateTime.ofInstant(Instant.ofEpochMilli(inV.time[i]), ZoneOffset.UTC).withNano(inV.nanos[i]).format(PRINT_FORMATTER).getBytes();
        this.assign(outV, i, temp, temp.length);
    }

    void sqlFormat(BytesColumnVector outV, TimestampColumnVector inV, int i, HiveSqlDateTimeFormatter sqlFormatter) {
        String formattedString = sqlFormatter.format(org.apache.hadoop.hive.common.type.Timestamp.ofEpochMilli((long)inV.time[i], (int)inV.nanos[i]));
        if (formattedString == null) {
            outV.isNull[i] = true;
            outV.noNulls = false;
            return;
        }
        byte[] temp = formattedString.getBytes();
        this.assign(outV, i, temp, temp.length);
    }

    public static String getTimestampString(Timestamp ts) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(ts.getTime()), ZoneOffset.UTC).withNano(ts.getNanos()).format(PRINT_FORMATTER);
    }

    static {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        builder.append(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        builder.optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalEnd();
        PRINT_FORMATTER = builder.toFormatter();
    }
}

