/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.repl.ClearDanglingTxnWork;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClearDanglingTxnTask
extends Task<ClearDanglingTxnWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ClearDanglingTxnTask.class);

    @Override
    public int execute() {
        Map<String, String> replTxnEntries;
        HiveTxnManager txnManager = this.context.getHiveTxnManager();
        String replPolicy = ((ClearDanglingTxnWork)this.work).getTargetDbName().toLowerCase() + ".*";
        try {
            replTxnEntries = txnManager.getReplayedTxnsForPolicy(replPolicy);
        }
        catch (LockException e) {
            throw new ReplicationTxnException("Failed to get entries from repl_txn_map: " + e.getMessage(), (Throwable)((Object)e));
        }
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_REPL_CLEAR_DANGLING_TXNS_ON_TARGET)) {
            try {
                this.clearDanglingTxns(replTxnEntries, txnManager, replPolicy);
            }
            catch (IOException | LockException e) {
                throw new ReplicationTxnException("Failed to clear dangling transactions from repl_txn_map: " + ((Throwable)e).getMessage(), (Throwable)e);
            }
        }
        Path path = new Path(((ClearDanglingTxnWork)this.work).getDumpDirectory(), "_open_txns");
        try {
            FileSystem fs = path.getParent().getFileSystem((Configuration)this.conf);
            if (fs.exists(path)) {
                LOG.warn("hive.repl.clear.dangling.txns.on.target is set to false in Repl Load. Skipping clearing dangling transactions from repl_txn_map.");
            }
        }
        catch (IOException e) {
            throw new ReplicationTxnException("Failed to access filesystem for replication operation: " + e.getMessage(), e);
        }
        return 0;
    }

    private void clearDanglingTxns(Map<String, String> replTxnEntries, HiveTxnManager txnManager, String replPolicy) throws IOException, LockException {
        Path path = new Path(((ClearDanglingTxnWork)this.work).getDumpDirectory(), "_open_txns");
        FileSystem fs = path.getParent().getFileSystem((Configuration)this.conf);
        if (!fs.exists(path)) {
            LOG.warn("Path {} does not exist. Skipping clearing dangling transactions from repl_txn_map.", (Object)path);
            return;
        }
        Set<Long> openTxnIDsFromSource = EximUtil.readAsLong(fs, path, ",");
        Set sourceTxnIdsFromReplTxnMap = replTxnEntries.keySet().stream().map(Long::valueOf).collect(Collectors.toSet());
        sourceTxnIdsFromReplTxnMap.removeAll(openTxnIDsFromSource);
        Iterator iterator = sourceTxnIdsFromReplTxnMap.iterator();
        while (iterator.hasNext()) {
            long danglingTxn = (Long)iterator.next();
            LOG.info("Rolling back target transaction for source txn {} and policy {} ", (Object)danglingTxn, (Object)replPolicy);
            txnManager.replRollbackTxn(replPolicy, danglingTxn);
        }
    }

    @Override
    public StageType getType() {
        return StageType.CLEAR_DANGLING_TXNS;
    }

    public String getName() {
        return "CLEAR_DANGLING_TXNS";
    }

    @Override
    public boolean canExecuteInParallel() {
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public static class ReplicationTxnException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ReplicationTxnException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

