/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.mr;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.LogUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.MapRedStats;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskHandle;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.HadoopJobExecHook;
import org.apache.hadoop.hive.ql.exec.mr.JobDebugger;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.history.HiveHistory;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.plan.ReducerTimeStatsPerJob;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.ClientStatsPublisher;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hive.common.util.ShutdownHookManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopJobExecHelper {
    private static final Logger LOG = LoggerFactory.getLogger((String)HadoopJobExecHelper.class.getName());
    protected transient JobConf job;
    protected Task<?> task;
    protected transient int mapProgress = -1;
    protected transient int reduceProgress = -1;
    protected transient int lastMapProgress;
    protected transient int lastReduceProgress;
    public transient JobID jobId;
    private final SessionState.LogHelper console;
    private final HadoopJobExecHook callBackObj;
    private final String queryId;
    public static List<RunningJob> runningJobs = Collections.synchronizedList(new LinkedList());

    private void updateCounters(Counters ctrs, RunningJob rj) throws IOException {
        this.lastMapProgress = this.mapProgress;
        this.lastReduceProgress = this.reduceProgress;
        this.mapProgress = Math.round(rj.mapProgress() * 100.0f);
        this.mapProgress = this.mapProgress == 100 ? (int)Math.floor(rj.mapProgress() * 100.0f) : this.mapProgress;
        this.reduceProgress = Math.round(rj.reduceProgress() * 100.0f);
        this.reduceProgress = this.reduceProgress == 100 ? (int)Math.floor(rj.reduceProgress() * 100.0f) : this.reduceProgress;
        this.task.taskCounters.put("CNTR_NAME_" + this.task.getId() + "_MAP_PROGRESS", Long.valueOf(this.mapProgress));
        this.task.taskCounters.put("CNTR_NAME_" + this.task.getId() + "_REDUCE_PROGRESS", Long.valueOf(this.reduceProgress));
        if (SessionState.get() != null) {
            float progress = (rj.mapProgress() + rj.reduceProgress()) * 0.5f;
            SessionState.get().updateProgressedPercentage(progress);
        }
    }

    private static String getJobStartMsg(JobID jobId) {
        return "Starting Job = " + String.valueOf(jobId);
    }

    public static String getJobEndMsg(JobID jobId) {
        return "Ended Job = " + String.valueOf(jobId);
    }

    public boolean mapStarted() {
        return this.mapProgress > 0;
    }

    public boolean reduceStarted() {
        return this.reduceProgress > 0;
    }

    public boolean mapDone() {
        return this.mapProgress == 100;
    }

    public boolean reduceDone() {
        return this.reduceProgress == 100;
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public void setJobId(JobID jobId) {
        this.jobId = jobId;
    }

    public HadoopJobExecHelper(JobConf job, SessionState.LogHelper console, Task<?> task, HadoopJobExecHook hookCallBack) {
        this.queryId = HiveConf.getVar((Configuration)job, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_ID, (String)("unknown-" + System.currentTimeMillis()));
        this.job = job;
        this.console = console;
        this.task = task;
        this.callBackObj = hookCallBack;
        if (job != null) {
            HiveConf.setVar((Configuration)job, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE, (String)"mr");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void killRunningJobs() {
        List<RunningJob> list = runningJobs;
        synchronized (list) {
            for (RunningJob rj : runningJobs) {
                try {
                    System.err.println("killing job with: " + String.valueOf(rj.getID()));
                    rj.killJob();
                }
                catch (Exception e) {
                    LOG.warn("Failed to kill job", (Throwable)e);
                    System.err.println("Failed to kill job: " + String.valueOf(rj.getID()));
                }
            }
        }
    }

    public boolean checkFatalErrors(Counters ctrs, StringBuilder errMsg) {
        long upperLimit;
        if (ctrs == null) {
            return false;
        }
        Counters.Counter cntr = ctrs.findCounter(HiveConf.getVar((Configuration)this.job, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COUNTER_GROUP), "CREATED_FILES");
        long numFiles = cntr != null ? cntr.getValue() : 0L;
        if (numFiles > (upperLimit = HiveConf.getLongVar((Configuration)this.job, (HiveConf.ConfVars)HiveConf.ConfVars.MAX_CREATED_FILES))) {
            errMsg.append("total number of created files now is " + numFiles + ", which exceeds ").append(upperLimit);
            return true;
        }
        return this.callBackObj.checkFatalErrors(ctrs, errMsg);
    }

    private MapRedStats progress(ExecDriverTaskHandle th) throws IOException, LockException {
        boolean success;
        long newCpuMSec;
        Counters.Counter counterCpuMsec;
        Counters ctrs;
        JobClient jc = th.getJobClient();
        RunningJob rj = th.getRunningJob();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
        long reportTime = System.currentTimeMillis();
        long maxReportInterval = HiveConf.getTimeVar((Configuration)this.job, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_LOG_INCREMENTAL_PLAN_PROGRESS_INTERVAL, (TimeUnit)TimeUnit.MILLISECONDS);
        boolean fatal = false;
        StringBuilder errMsg = new StringBuilder();
        long pullInterval = HiveConf.getLongVar((Configuration)this.job, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COUNTERS_PULL_INTERVAL);
        boolean initializing = true;
        boolean initOutputPrinted = false;
        long cpuMsec = -1L;
        int numMap = -1;
        int numReduce = -1;
        List<ClientStatsPublisher> clientStatPublishers = this.getClientStatPublishers();
        boolean localMode = ShimLoader.getHadoopShims().isLocalMode((Configuration)this.job);
        MapRedStats mapRedStats = new MapRedStats(this.job, numMap, numReduce, cpuMsec, false, rj.getID().toString());
        this.updateMapRedTaskWebUIStatistics(mapRedStats, rj);
        while (!rj.isComplete()) {
            long newCpuMSec2;
            Counters.Counter counterCpuMsec2;
            if (th.getContext() != null) {
                th.getContext().checkHeartbeaterLockException();
            }
            try {
                Thread.sleep(pullInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (initializing && rj.getJobState() == JobStatus.PREP) continue;
            initializing = false;
            if (!localMode) {
                RunningJob newRj;
                if (!initOutputPrinted) {
                    Iterator<ClientStatsPublisher> logReducer;
                    Object logMapper;
                    SessionState ss = SessionState.get();
                    TaskReport[] mappers = jc.getMapTaskReports(rj.getID());
                    if (mappers == null) {
                        logMapper = "no information for number of mappers; ";
                    } else {
                        numMap = mappers.length;
                        if (ss != null) {
                            ss.getHiveHistory().setTaskProperty(this.queryId, this.getId(), HiveHistory.Keys.TASK_NUM_MAPPERS, Integer.toString(numMap));
                        }
                        logMapper = "number of mappers: " + numMap + "; ";
                    }
                    TaskReport[] reducers = jc.getReduceTaskReports(rj.getID());
                    if (reducers == null) {
                        logReducer = "no information for number of reducers. ";
                    } else {
                        numReduce = reducers.length;
                        if (ss != null) {
                            ss.getHiveHistory().setTaskProperty(this.queryId, this.getId(), HiveHistory.Keys.TASK_NUM_REDUCERS, Integer.toString(numReduce));
                        }
                        logReducer = "number of reducers: " + numReduce;
                    }
                    this.console.printInfo("Hadoop job information for " + this.getId() + ": " + (String)logMapper + (String)((Object)logReducer));
                    initOutputPrinted = true;
                }
                if ((newRj = jc.getJob(rj.getID())) == null) {
                    throw new IOException("Could not find status of job:" + String.valueOf(rj.getID()));
                }
                th.setRunningJob(newRj);
                rj = newRj;
            }
            if (fatal) continue;
            ctrs = th.getCounters();
            mapRedStats.setCounters(ctrs);
            mapRedStats.setNumMap(numMap);
            mapRedStats.setNumReduce(numReduce);
            this.updateMapRedTaskWebUIStatistics(mapRedStats, rj);
            fatal = this.checkFatalErrors(ctrs, errMsg);
            if (fatal) {
                this.console.printError("[Fatal Error] " + errMsg.toString() + ". Killing the job.");
                rj.killJob();
                continue;
            }
            errMsg.setLength(0);
            this.updateCounters(ctrs, rj);
            if (clientStatPublishers.size() > 0 && ctrs != null) {
                Map<String, Double> exctractedCounters = this.extractAllCounterValues(ctrs);
                for (ClientStatsPublisher clientStatPublisher : clientStatPublishers) {
                    try {
                        clientStatPublisher.run(exctractedCounters, rj.getID().toString());
                    }
                    catch (RuntimeException runtimeException) {
                        LOG.error("Exception " + runtimeException.getClass().getCanonicalName() + " thrown when running clientStatsPublishers. The stack trace is: ", (Throwable)runtimeException);
                    }
                }
            }
            if (this.mapProgress == this.lastMapProgress && this.reduceProgress == this.lastReduceProgress && System.currentTimeMillis() < reportTime + maxReportInterval) continue;
            StringBuilder report = new StringBuilder();
            report.append(dateFormat.format(Calendar.getInstance().getTime()));
            report.append(' ').append(this.getId());
            report.append(" map = ").append(this.mapProgress).append("%, ");
            report.append(" reduce = ").append(this.reduceProgress).append('%');
            if (ctrs != null && (counterCpuMsec2 = ctrs.findCounter("org.apache.hadoop.mapred.Task$Counter", "CPU_MILLISECONDS")) != null && (newCpuMSec2 = counterCpuMsec2.getValue()) > 0L) {
                cpuMsec = newCpuMSec2;
                report.append(", Cumulative CPU ").append((double)cpuMsec / 1000.0).append(" sec");
            }
            String output = report.toString();
            SessionState ss = SessionState.get();
            if (ss != null) {
                ss.getHiveHistory().setTaskCounters(this.queryId, this.getId(), ctrs);
                ss.getHiveHistory().setTaskProperty(this.queryId, this.getId(), HiveHistory.Keys.TASK_HADOOP_PROGRESS, output);
                if (ss.getConf().getBoolVar(HiveConf.ConfVars.HIVE_LOG_INCREMENTAL_PLAN_PROGRESS)) {
                    ss.getHiveHistory().progressTask(this.queryId, this.task);
                    this.callBackObj.logPlanProgress(ss);
                }
            }
            this.console.printInfo(output);
            this.task.setStatusMessage(output);
            reportTime = System.currentTimeMillis();
        }
        ctrs = th.getCounters();
        if (ctrs != null && (counterCpuMsec = ctrs.findCounter("org.apache.hadoop.mapred.Task$Counter", "CPU_MILLISECONDS")) != null && (newCpuMSec = counterCpuMsec.getValue()) > cpuMsec) {
            cpuMsec = newCpuMSec;
        }
        if (cpuMsec > 0L) {
            String status = "MapReduce Total cumulative CPU time: " + Utilities.formatMsecToStr(cpuMsec);
            this.console.printInfo(status);
            this.task.setStatusMessage(status);
        }
        if (fatal) {
            success = false;
        } else if (this.checkFatalErrors(ctrs, errMsg)) {
            this.console.printError("[Fatal Error] " + errMsg.toString());
            success = false;
        } else {
            SessionState ss = SessionState.get();
            if (ss != null) {
                ss.getHiveHistory().setTaskCounters(this.queryId, this.getId(), ctrs);
            }
            success = rj.isSuccessful();
        }
        mapRedStats.setSuccess(success);
        mapRedStats.setCounters(ctrs);
        mapRedStats.setCpuMSec(cpuMsec);
        this.updateMapRedTaskWebUIStatistics(mapRedStats, rj);
        this.updateCounters(ctrs, rj);
        SessionState ss = SessionState.get();
        if (ss != null) {
            Counters.Counter counter;
            if (ctrs != null && (counter = ctrs.findCounter(ss.getConf().getVar(HiveConf.ConfVars.HIVE_COUNTER_GROUP), "TOTAL_TABLE_ROWS_WRITTEN")) != null) {
                mapRedStats.setNumModifiedRows(counter.getValue());
            }
            this.callBackObj.logPlanProgress(ss);
        }
        return mapRedStats;
    }

    private void updateMapRedTaskWebUIStatistics(MapRedStats mapRedStats, RunningJob rj) {
        if (this.task instanceof MapRedTask) {
            ((MapRedTask)this.task).updateWebUiStats(mapRedStats, rj);
        }
    }

    private String getId() {
        return this.task.getId();
    }

    public void jobInfo(RunningJob rj) {
        if (ShimLoader.getHadoopShims().isLocalMode((Configuration)this.job)) {
            this.console.printInfo("Job running in-process (local Hadoop)");
        } else {
            if (SessionState.get() != null) {
                SessionState.get().getHiveHistory().setTaskProperty(this.queryId, this.getId(), HiveHistory.Keys.TASK_HADOOP_ID, rj.getID().toString());
            }
            this.console.printInfo(HadoopJobExecHelper.getJobStartMsg(rj.getID()) + ", Tracking URL = " + rj.getTrackingURL());
            this.console.printInfo("Kill Command = " + HiveConf.getVar((Configuration)this.job, (HiveConf.ConfVars)HiveConf.ConfVars.MAPRED_BIN) + " job  -kill " + String.valueOf(rj.getID()));
        }
    }

    public void localJobDebugger(int exitVal, String taskId) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("Task failed!\n");
        sb.append("Task ID:\n  " + taskId + "\n\n");
        sb.append("Logs:\n");
        this.console.printError(sb.toString());
        this.console.printError(LogUtils.getLogFilePath());
    }

    public int progressLocal(Process runningJob, String taskId) {
        int exitVal = -101;
        try {
            exitVal = runningJob.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (exitVal != 0) {
            this.console.printError("Execution failed with exit status: " + exitVal);
            this.console.printError("Obtaining error information");
            if (HiveConf.getBoolVar((Configuration)this.job, (HiveConf.ConfVars)HiveConf.ConfVars.SHOW_JOB_FAIL_DEBUG_INFO)) {
                this.localJobDebugger(exitVal, taskId);
            }
        } else {
            this.console.printInfo("Execution completed successfully");
            this.console.printInfo("MapredLocal task succeeded");
        }
        return exitVal;
    }

    public int progress(RunningJob rj, JobClient jc, Context ctx) throws IOException, LockException {
        this.jobId = rj.getID();
        int returnVal = 0;
        String pwd = HiveConf.getVar((Configuration)this.job, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_PWD);
        if (pwd != null) {
            HiveConf.setVar((Configuration)this.job, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_PWD, (String)"HIVE");
        }
        if (pwd != null) {
            HiveConf.setVar((Configuration)this.job, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_PWD, (String)pwd);
        }
        runningJobs.add(rj);
        ExecDriverTaskHandle th = new ExecDriverTaskHandle(jc, rj, ctx);
        this.jobInfo(rj);
        MapRedStats mapRedStats = this.progress(th);
        this.task.taskHandle = th;
        if (SessionState.get() != null) {
            SessionState.get().getMapRedStats().put(this.getId(), mapRedStats);
            if (this.task.getQueryPlan() != null) {
                this.computeReducerTimeStatsPerJob(rj);
            }
        }
        boolean success = mapRedStats.isSuccess();
        Object statusMesg = HadoopJobExecHelper.getJobEndMsg(rj.getID());
        if (!success) {
            statusMesg = (String)statusMesg + " with errors";
            returnVal = 2;
            this.console.printError((String)statusMesg);
            if (HiveConf.getBoolVar((Configuration)this.job, (HiveConf.ConfVars)HiveConf.ConfVars.SHOW_JOB_FAIL_DEBUG_INFO) || HiveConf.getBoolVar((Configuration)this.job, (HiveConf.ConfVars)HiveConf.ConfVars.JOB_DEBUG_CAPTURE_STACKTRACES)) {
                try {
                    JobDebugger jd = SessionState.get() != null ? new JobDebugger(this.job, rj, this.console, SessionState.get().getStackTraces()) : new JobDebugger(this.job, rj, this.console);
                    Thread t = new Thread(jd);
                    t.start();
                    t.join(HiveConf.getIntVar((Configuration)this.job, (HiveConf.ConfVars)HiveConf.ConfVars.JOB_DEBUG_TIMEOUT));
                    this.task.setDiagnosticMessage(jd.getDiagnosticMesg());
                    int ec = jd.getErrorCode();
                    if (ec > 0) {
                        returnVal = ec;
                    }
                }
                catch (InterruptedException e) {
                    this.console.printError("Timed out trying to grab more detailed job failure information, please check jobtracker for more info");
                }
            }
        } else {
            this.console.printInfo((String)statusMesg);
        }
        return returnVal;
    }

    private void computeReducerTimeStatsPerJob(RunningJob rj) throws IOException {
        TaskCompletionEvent[] taskCompletions = rj.getTaskCompletionEvents(0);
        ArrayList<Integer> reducersRunTimes = new ArrayList<Integer>();
        for (TaskCompletionEvent taskCompletion : taskCompletions) {
            if (taskCompletion.isMapTask()) continue;
            reducersRunTimes.add(taskCompletion.getTaskRunTime());
        }
        ReducerTimeStatsPerJob reducerTimeStatsPerJob = new ReducerTimeStatsPerJob(reducersRunTimes);
        this.task.getQueryPlan().getReducerTimeStatsPerJobList().add(reducerTimeStatsPerJob);
    }

    private Map<String, Double> extractAllCounterValues(Counters counters) {
        HashMap<String, Double> exctractedCounters = new HashMap<String, Double>();
        for (Counters.Group cg : counters) {
            for (Counters.Counter c : cg) {
                exctractedCounters.put(cg.getName() + "::" + c.getName(), Double.valueOf(c.getCounter()));
            }
        }
        return exctractedCounters;
    }

    private List<ClientStatsPublisher> getClientStatPublishers() {
        String[] clientStatsPublisherClasses;
        ArrayList<ClientStatsPublisher> clientStatsPublishers = new ArrayList<ClientStatsPublisher>();
        String confString = HiveConf.getVar((Configuration)this.job, (HiveConf.ConfVars)HiveConf.ConfVars.CLIENT_STATS_PUBLISHERS);
        if ((confString = confString.trim()).equals("")) {
            return clientStatsPublishers;
        }
        for (String clientStatsPublisherClass : clientStatsPublisherClasses = confString.split(",")) {
            try {
                clientStatsPublishers.add((ClientStatsPublisher)Class.forName(clientStatsPublisherClass.trim(), true, Utilities.getSessionSpecifiedClassLoader()).newInstance());
            }
            catch (Exception e) {
                LOG.warn(e.getClass().getName() + " occured when trying to create class: " + clientStatsPublisherClass.trim() + " implementing ClientStatsPublisher interface");
                LOG.warn("The exception message is: " + e.getMessage());
                LOG.warn("Program will continue, but without this ClientStatsPublisher working");
            }
        }
        return clientStatsPublishers;
    }

    static {
        ShutdownHookManager.addShutdownHook((Runnable)new Runnable(){

            @Override
            public void run() {
                HadoopJobExecHelper.killRunningJobs();
            }
        });
    }

    private static class ExecDriverTaskHandle
    extends TaskHandle {
        JobClient jc;
        RunningJob rj;
        Context ctx;

        JobClient getJobClient() {
            return this.jc;
        }

        RunningJob getRunningJob() {
            return this.rj;
        }

        Context getContext() {
            return this.ctx;
        }

        public ExecDriverTaskHandle(JobClient jc, RunningJob rj, Context ctx) {
            this.jc = jc;
            this.rj = rj;
            this.ctx = ctx;
        }

        public void setRunningJob(RunningJob job) {
            this.rj = job;
        }

        @Override
        public Counters getCounters() throws IOException {
            return this.rj.getCounters();
        }
    }
}

