/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.view.materialized.update;

import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.view.materialized.update.MaterializedViewUpdateDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveMaterializedViewsRegistry;
import org.apache.hadoop.hive.ql.metadata.MaterializedViewMetadata;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveMaterializedViewUtils;
import org.apache.hadoop.hive.ql.parse.ExplainConfiguration;

public class MaterializedViewUpdateOperation
extends DDLOperation<MaterializedViewUpdateDesc> {
    public MaterializedViewUpdateOperation(DDLOperationContext context, MaterializedViewUpdateDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        if (this.context.getContext().getExplainAnalyze() == ExplainConfiguration.AnalyzeState.RUNNING) {
            return 0;
        }
        try {
            if (((MaterializedViewUpdateDesc)this.desc).isRetrieveAndInclude()) {
                Table mvTable = this.context.getDb().getTable(((MaterializedViewUpdateDesc)this.desc).getName());
                HiveMaterializedViewsRegistry.get().createMaterializedView(this.context.getDb().getConf(), mvTable);
            } else if (((MaterializedViewUpdateDesc)this.desc).isDisableRewrite()) {
                String[] names = ((MaterializedViewUpdateDesc)this.desc).getName().split("\\.");
                HiveMaterializedViewsRegistry.get().dropMaterializedView(names[0], names[1]);
            } else if (((MaterializedViewUpdateDesc)this.desc).isUpdateCreationMetadata()) {
                Table mvTable = this.context.getDb().getTable(((MaterializedViewUpdateDesc)this.desc).getName());
                MaterializedViewMetadata newMetadata = mvTable.getMVMetadata().reset(HiveMaterializedViewUtils.getSnapshotOf(this.context, mvTable.getMVMetadata().getSourceTableNames()));
                this.context.getDb().updateCreationMetadata(mvTable.getDbName(), mvTable.getTableName(), newMetadata);
                mvTable.setMaterializedViewMetadata(newMetadata);
                HiveMaterializedViewsRegistry.get().refreshMaterializedView(this.context.getDb().getConf(), mvTable);
            }
        }
        catch (HiveException e) {
            LOG.debug("Exception during materialized view cache update", (Throwable)e);
            this.context.getTask().setException(e);
        }
        return 0;
    }
}

